/*
 * Decompiled with CFR 0.152.
 */
package dev.booky.cloudprotections.config;

import dev.booky.cloudprotections.region.ProtectionFlag;
import dev.booky.cloudprotections.region.ProtectionRegion;
import dev.booky.cloudprotections.region.area.IProtectionArea;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.RandomStringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

public final class ProtectionRegionSerializer
implements TypeSerializer<ProtectionRegion> {
    public static final ProtectionRegionSerializer INSTANCE = new ProtectionRegionSerializer();

    private ProtectionRegionSerializer() {
    }

    public ProtectionRegion deserialize(Type type, ConfigurationNode node) throws SerializationException {
        if (node.virtual()) {
            return null;
        }
        IProtectionArea area = Objects.requireNonNull((IProtectionArea)node.get(IProtectionArea.class));
        String id = node.node(new Object[]{"id"}).getString(RandomStringUtils.randomAlphanumeric((int)8));
        int priority = node.node(new Object[]{"priority"}).getInt();
        ConfigurationNode exclusionsNode = node.node(new Object[]{"exclusions"});
        List exclusions = exclusionsNode.getList(UUID.class, List::of);
        ConfigurationNode flagsNode = node.node(new Object[]{"flags"});
        List flags = flagsNode.getList(ProtectionFlag.class, List::of);
        return new ProtectionRegion(id, area, priority, Set.copyOf(exclusions), Set.copyOf(flags));
    }

    public void serialize(Type type, @Nullable ProtectionRegion obj, ConfigurationNode node) throws SerializationException {
        if (obj == null) {
            node.set(null);
            return;
        }
        node.set((Object)obj.getArea());
        node.node(new Object[]{"id"}).set((Object)obj.getId());
        node.node(new Object[]{"priority"}).set((Object)obj.getPriority());
        node.node(new Object[]{"exclusions"}).setList(UUID.class, List.copyOf(obj.getExcludedPlayerIds()));
        node.node(new Object[]{"flags"}).setList(ProtectionFlag.class, List.copyOf(obj.getFlags()));
    }
}

