/*
 * Decompiled with CFR 0.152.
 */
package dev.booky.cloudprotections.listener;

import com.destroystokyo.paper.event.entity.EntityPathfindEvent;
import dev.booky.cloudprotections.ProtectionsManager;
import dev.booky.cloudprotections.region.ProtectionFlag;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EntityEquipment;

public final class ProtectionListener
implements Listener {
    private final ProtectionsManager manager;

    public ProtectionListener(ProtectionsManager manager) {
        this.manager = manager;
    }

    @EventHandler
    public void onBreak(BlockBreakEvent event) {
        if (this.manager.isProtected(event.getBlock(), ProtectionFlag.BUILDING, event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlace(BlockPlaceEvent event) {
        if (this.manager.isProtected(event.getBlock(), ProtectionFlag.BUILDING, event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBucketFill(PlayerBucketFillEvent event) {
        if (this.manager.isProtected(event.getBlock(), ProtectionFlag.BUILDING, event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBucketEmpty(PlayerBucketEmptyEvent event) {
        if (this.manager.isProtected(event.getBlock(), ProtectionFlag.BUILDING, event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onDamage(EntityDamageEvent event) {
        if (this.manager.isProtected(event.getEntity().getLocation(), ProtectionFlag.HEALTH, null)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        if (this.manager.isProtected(event.getEntity().getLocation(), ProtectionFlag.MOB_SPAWNING, null)) {
            switch (event.getSpawnReason()) {
                case SPAWNER_EGG: 
                case BUILD_SNOWMAN: 
                case BUILD_IRONGOLEM: 
                case BUILD_WITHER: 
                case BREEDING: 
                case DISPENSE_EGG: 
                case INFECTION: 
                case CURED: 
                case SHOULDER_ENTITY: 
                case DROWNED: 
                case SHEARED: 
                case PIGLIN_ZOMBIFIED: 
                case FROZEN: 
                case METAMORPHOSIS: 
                case DUPLICATION: 
                case COMMAND: 
                case CUSTOM: 
                case DEFAULT: {
                    break;
                }
                default: {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public void onFoodChange(FoodLevelChangeEvent event) {
        if (event.getFoodLevel() >= event.getEntity().getFoodLevel()) {
            return;
        }
        HumanEntity humanEntity = event.getEntity();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (this.manager.isProtected(event.getEntity().getLocation(), ProtectionFlag.HUNGER, player)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onInteract(PlayerInteractEvent event) {
        if (event.getClickedBlock() == null) {
            return;
        }
        switch (event.getAction()) {
            case LEFT_CLICK_BLOCK: 
            case RIGHT_CLICK_BLOCK: {
                if (!this.manager.isProtected(event.getClickedBlock(), ProtectionFlag.INTERACT, event.getPlayer())) {
                    return;
                }
                Material blockType = event.getClickedBlock().getType();
                if (event.getMaterial().isAir() && (blockType == Material.ENDER_CHEST || blockType == Material.CRAFTING_TABLE)) {
                    return;
                }
                if (!event.getMaterial().isBlock()) {
                    event.setUseInteractedBlock(Event.Result.DENY);
                    return;
                }
                if (!event.getPlayer().isSneaking()) {
                    event.setUseInteractedBlock(Event.Result.DENY);
                    return;
                }
                EntityEquipment equipment = event.getPlayer().getEquipment();
                if (!equipment.getItemInMainHand().getType().isAir() || !equipment.getItemInOffHand().getType().isAir()) break;
                event.setUseInteractedBlock(Event.Result.DENY);
                break;
            }
            case PHYSICAL: {
                if (!this.manager.isProtected(event.getClickedBlock(), ProtectionFlag.INTERACT, null)) break;
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEntityEvent event) {
        if (this.manager.isProtected(event.getRightClicked().getLocation(), ProtectionFlag.INTERACT, event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onArmorStandManipulate(PlayerArmorStandManipulateEvent event) {
        if (this.manager.isProtected(event.getRightClicked().getLocation(), ProtectionFlag.INTERACT, event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onHangingBreak(HangingBreakByEntityEvent event) {
        Player remover;
        Player player = remover = event.getRemover() instanceof Player ? (Player)event.getRemover() : null;
        if (this.manager.isProtected(event.getEntity().getLocation(), ProtectionFlag.INTERACT, remover)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityExplosion(EntityExplodeEvent event) {
        event.blockList().removeIf(block -> this.manager.isProtected((Block)block, ProtectionFlag.EXPLOSION, null));
    }

    @EventHandler
    public void onBlockExplosion(BlockExplodeEvent event) {
        event.blockList().removeIf(block -> this.manager.isProtected((Block)block, ProtectionFlag.EXPLOSION, null));
    }

    @EventHandler
    public void onEntityRegainNegativeHealth(EntityRegainHealthEvent event) {
        if (event.getAmount() < 0.0) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onRedstone(BlockRedstoneEvent event) {
        if (this.manager.isProtected(event.getBlock(), ProtectionFlag.REDSTONE, null)) {
            event.setNewCurrent(0);
        }
    }

    private boolean checkPiston(Block piston, Iterable<Block> moved) {
        if (this.manager.isProtected(piston, ProtectionFlag.REDSTONE, null)) {
            return false;
        }
        for (Block block : moved) {
            if (!this.manager.isProtected(block, ProtectionFlag.REDSTONE, null)) continue;
            return false;
        }
        return true;
    }

    @EventHandler(ignoreCancelled=true)
    public void onPistonExtend(BlockPistonExtendEvent event) {
        boolean allowed = this.checkPiston(event.getBlock(), event.getBlocks());
        if (!allowed) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPistonRetract(BlockPistonRetractEvent event) {
        boolean allowed = this.checkPiston(event.getBlock(), event.getBlocks());
        if (!allowed) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPathfind(EntityPathfindEvent event) {
        if (this.manager.isProtected(event.getLoc(), ProtectionFlag.MOB_AI, null)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPathfind(EntityTargetEvent event) {
        Player player;
        Entity target = event.getTarget();
        if (target == null) {
            return;
        }
        Player player2 = player = target instanceof Player ? (Player)target : null;
        if (this.manager.isProtected(target.getLocation(), ProtectionFlag.MOB_AI, player)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onFireSpread(BlockSpreadEvent event) {
        if (event.getSource().getType() != Material.FIRE) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        if (this.manager.isProtected(event.getBlock(), ProtectionFlag.FIRE, null)) {
            event.setCancelled(true);
        } else if (this.manager.isProtected(event.getSource(), ProtectionFlag.FIRE, null)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockBurn(BlockBurnEvent event) {
        if (this.manager.isProtected(event.getBlock(), ProtectionFlag.FIRE, null)) {
            event.setCancelled(true);
        }
    }
}

