/*
 * Decompiled with CFR 0.152.
 */
package dev.booky.cloudprotections.region;

import dev.booky.cloudprotections.region.ProtectionFlag;
import dev.booky.cloudprotections.region.area.IProtectionArea;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public final class ProtectionRegion {
    private final String id;
    private final IProtectionArea area;
    private final int priority;
    private final Set<UUID> excludedPlayerIds;
    private final Set<ProtectionFlag> flags;

    public ProtectionRegion(String id, IProtectionArea area) {
        this(id, area, EnumSet.allOf(ProtectionFlag.class));
    }

    public ProtectionRegion(String id, IProtectionArea area, ProtectionFlag ... flags) {
        this(id, area, Set.of(flags));
    }

    public ProtectionRegion(String id, IProtectionArea area, Set<ProtectionFlag> flags) {
        this(id, area, Set.of(), flags);
    }

    public ProtectionRegion(String id, IProtectionArea area, Set<UUID> excludedPlayerIds, Set<ProtectionFlag> flags) {
        this(id, area, 0, excludedPlayerIds, flags);
    }

    public ProtectionRegion(String id, IProtectionArea area, int priority, Set<UUID> excludedPlayerIds, Set<ProtectionFlag> flags) {
        this.id = id;
        this.area = area;
        this.priority = priority;
        this.excludedPlayerIds = new HashSet<UUID>(excludedPlayerIds);
        this.flags = EnumSet.copyOf(flags);
    }

    public final boolean check(Block block, ProtectionFlag flag) {
        return this.flags.contains((Object)flag) && this.area.contains(block);
    }

    public final boolean isExcluded(Player player) {
        return this.excludedPlayerIds.contains(player.getUniqueId());
    }

    public final boolean addFlag(ProtectionFlag flag) {
        return this.flags.add(flag);
    }

    public final boolean removeFlag(ProtectionFlag flag) {
        return this.flags.remove((Object)flag);
    }

    public final boolean hasFlag(ProtectionFlag flag) {
        return this.flags.contains((Object)flag);
    }

    public final boolean addExclusion(UUID exclusion) {
        return this.excludedPlayerIds.add(exclusion);
    }

    public final boolean removeExclusion(UUID exclusion) {
        return this.excludedPlayerIds.remove(exclusion);
    }

    public final String getId() {
        return this.id;
    }

    public final IProtectionArea getArea() {
        return this.area;
    }

    public int getPriority() {
        return this.priority;
    }

    public final Set<UUID> getExcludedPlayerIds() {
        return Collections.unmodifiableSet(this.excludedPlayerIds);
    }

    public final Set<ProtectionFlag> getFlags() {
        return Collections.unmodifiableSet(this.flags);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProtectionRegion)) {
            return false;
        }
        ProtectionRegion that = (ProtectionRegion)obj;
        return this.area.equals(that.area);
    }

    public int hashCode() {
        return this.area.hashCode();
    }

    public String toString() {
        return "ProtectionRegion{id='" + this.id + "', area=" + String.valueOf(this.area) + ", priority=" + this.priority + ", excludedPlayerIds=" + String.valueOf(this.excludedPlayerIds) + ", flags=" + String.valueOf(this.flags) + "}";
    }
}

