/*
 * Decompiled with CFR 0.152.
 */
package dev.booky.cloudprotections.region.area;

import dev.booky.cloudprotections.region.area.IProtectionArea;
import io.papermc.paper.math.BlockPosition;
import io.papermc.paper.math.Position;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;

public final class SphericalProtectionArea
implements IProtectionArea {
    private final World world;
    private final BlockPosition centerBlock;
    private final double radius;
    private final transient double radiusSq;

    public SphericalProtectionArea(Block centerBlock, double radius) {
        this(centerBlock.getWorld(), Position.block((int)centerBlock.getX(), (int)centerBlock.getY(), (int)centerBlock.getZ()), radius);
    }

    public SphericalProtectionArea(World world, BlockPosition centerBlock, double radius) {
        this.world = world;
        this.centerBlock = centerBlock;
        this.radius = radius;
        this.radiusSq = radius * radius;
    }

    @Override
    public boolean contains(Block block) {
        double diffZ;
        double diffY;
        if (this.world != block.getWorld()) {
            return false;
        }
        BlockPosition centerBlock = this.centerBlock;
        double diffX = centerBlock.blockX() - block.getX();
        double distSq = diffX * diffX + (diffY = (double)(centerBlock.blockY() - block.getY())) * diffY + (diffZ = (double)(centerBlock.blockZ() - block.getZ())) * diffZ;
        return distSq <= this.radiusSq;
    }

    @Override
    public Location getCenterLocation() {
        return this.getCenterBlock().getLocation().add(0.5, 0.125, 0.5);
    }

    public Block getCenterBlock() {
        BlockPosition centerBlock = this.centerBlock;
        return this.world.getBlockAt(centerBlock.blockX(), centerBlock.blockY(), centerBlock.blockZ());
    }

    public World getWorld() {
        return this.world;
    }

    public BlockPosition getCenterBlockPos() {
        return this.centerBlock;
    }

    public double getRadius() {
        return this.radius;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SphericalProtectionArea)) {
            return false;
        }
        SphericalProtectionArea that = (SphericalProtectionArea)obj;
        if (Double.compare(that.radius, this.radius) != 0) {
            return false;
        }
        if (!this.world.equals((Object)that.world)) {
            return false;
        }
        return this.centerBlock.equals((Object)that.centerBlock);
    }

    public int hashCode() {
        int result = this.world.hashCode();
        result = 31 * result + this.centerBlock.hashCode();
        result = 31 * result + Double.hashCode(this.radius);
        return result;
    }
}

