/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.config;

import dev.shadowsoffire.placebo.config.ConfigCategory;
import dev.shadowsoffire.placebo.config.Configuration;
import dev.shadowsoffire.placebo.config.Property;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import ky.someone.mods.gag.GAG;
import ky.someone.mods.gag.config.TargetFilter;
import ky.someone.mods.gag.util.GAGUtil;
import net.minecraft.network.VarInt;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;

@EventBusSubscriber(modid="gag")
public class GAGConfig {
    public static PouchConfig temporalPouch;
    public static RopeConfig escapeRope;
    public static HearthstoneConfig hearthstone;
    public static int noSolicitorsRadius;
    public static DynamiteConfig dynamite;

    public static void load() {
        Configuration config = new Configuration("gag");
        config.setTitle("Config for Gadgets Against Grind");
        ConfigCategory pouch = config.getCategory("temporal_pouch");
        int capacity = config.getInt("pouch_capacity", pouch.getQualifiedName(), Integer.MAX_VALUE, 0, Integer.MAX_VALUE, "Max amount of grains a Pouch can hold");
        String[] _levelFilter = config.getStringList("level_filter", pouch.getQualifiedName(), new String[0], "List of levels that the Temporal Pouch will not work in");
        Set<ResourceKey<Level>> levelFilter = Arrays.stream(_levelFilter).map(ResourceLocation::tryParse).filter(Objects::nonNull).map(GAGUtil::dimension).collect(Collectors.toSet());
        boolean invertLevelFilter = config.getBoolean("invert_level_filter", pouch.getQualifiedName(), false, "If true, the Temporal Pouch will instead *only* work in the levels specified in the level_filter list");
        int grainsUsed = config.getInt("grains_used", pouch.getQualifiedName(), 600, 1, Integer.MAX_VALUE, "Amount of grains used per click of the Temporal Pouch\n(this is currently equivalent to the 'ticks' accrued by a player)\n");
        int durationPerUse = config.getInt("duration_per_use", pouch.getQualifiedName(), 30, 1, 60, "Time (in seconds) that a block is accelerated per use, default is 30 seconds.\nThis determines the 'worth' of grains as displayed in the Pouch's tooltip.\n");
        int maxRate = config.getInt("max_rate", pouch.getQualifiedName(), 8, 1, 16, "Maximum times the Temporal Pouch can be used in a row, corresponding to maximum speed, default is max speed of 2^8 = x256\n");
        boolean allowRandomTicks = config.getBoolean("allow_random_ticks", pouch.getQualifiedName(), true, "Whether the Temporal Pouch is allowed to accelerate random ticks");
        int randomTickChance = config.getInt("random_tick_chance", pouch.getQualifiedName(), 4096, 256, 65536, "Chance that a random tick will be performed when a random ticking block like crops or saplings is accelerated\nOn average, this is done every 4096 / 3 \u2248 1365.33 ticks in Vanilla (see https://minecraft.gamepedia.com/Tick#Random_tick)\nActual value is (config value) / (random tick game rule)\n");
        temporalPouch = new PouchConfig(capacity, levelFilter, invertLevelFilter, grainsUsed, durationPerUse, maxRate, allowRandomTicks, randomTickChance);
        ConfigCategory misc = config.getCategory("misc");
        ConfigCategory rope = new ConfigCategory("escape_rope", misc);
        int durability = config.getInt("durability", rope.getQualifiedName(), 512, 0, Short.MAX_VALUE, "Maximum durability of the rope, default is 512");
        int warmup = config.getInt("warmup", rope.getQualifiedName(), GAGConfig.seconds(3), 0, 72000, "Time (in ticks) it takes to use the rope, default is 3 seconds");
        int cooldown = config.getInt("cooldown", rope.getQualifiedName(), GAGConfig.seconds(10), 0, 72000, "Time (in ticks) the player has to wait after using the rope, default is 10 seconds");
        escapeRope = new RopeConfig(durability, warmup, cooldown);
        ConfigCategory hearth = new ConfigCategory("hearthstone", misc);
        durability = config.getInt("durability", hearth.getQualifiedName(), 64, 0, Short.MAX_VALUE, "Maximum durability of the stone, default is 64");
        int energizedDurability = config.getInt("energized_durability", hearth.getQualifiedName(), 256, 0, Short.MAX_VALUE, "Maximum durability of the energized hearthstone, default is 256");
        int range = config.getInt("range", hearth.getQualifiedName(), -1, -1, Integer.MAX_VALUE, "Maximum range of the stone, set to -1 for unlimited range");
        int dimensionMultiplier = config.getInt("dimension_multiplier", hearth.getQualifiedName(), 2, -1, Short.MAX_VALUE, "Damage multiplier for using the stone across dimensions, default is 2\nSet to -1 to disable teleporting across dimensions\n");
        int warmup2 = config.getInt("warmup", hearth.getQualifiedName(), GAGConfig.seconds(5), 0, 72000, "Time (in ticks) it takes to use the stone, default is 5 seconds");
        int cooldown2 = config.getInt("cooldown", hearth.getQualifiedName(), GAGConfig.seconds(60), 0, 72000, "Time (in ticks) the player has to wait after using the stone, default is 60 seconds");
        boolean allowWorldSpawn = config.getBoolean("allow_world_spawn", hearth.getQualifiedName(), true, "Whether the stone should teleport a player to the spawn point if they have no respawn point");
        boolean useAnchorCharge = config.getBoolean("use_anchor_charge", hearth.getQualifiedName(), true, "Whether the stone should use a charge on the player's respawn anchor, if applicable");
        boolean ignoreSpawnBlock = config.getBoolean("ignore_spawn_block", hearth.getQualifiedName(), false, "Whether the stone should ignore checking whether the spawn block is still valid and unobstructed");
        hearthstone = new HearthstoneConfig(durability, energizedDurability, range, dimensionMultiplier, warmup2, cooldown2, allowWorldSpawn, useAnchorCharge, ignoreSpawnBlock);
        noSolicitorsRadius = config.getInt("no_solicitors_radius", misc.getQualifiedName(), 64, 1, 512, "Radius (in blocks) in which the 'No Solicitors!' sign will stop Wandering Traders from spawning, default is 32");
        ConfigCategory dynamiteC = config.getCategory("dynamite");
        int miningRadius = config.getInt("mining_radius", dynamiteC.getQualifiedName(), 7, 1, 64, "Radius (in blocks) of the Mining Dynamite's explosion, default is 7");
        boolean miningGivesHaste = config.getBoolean("mining_gives_haste", dynamiteC.getQualifiedName(), true, "Controls whether the Mining Dynamite should give the Haste status effect if it hits a player");
        int fishingRadius = config.getInt("fishing_radius", dynamiteC.getQualifiedName(), 4, 1, 64, "Radius (in blocks) of the Fishing Dynamite's explosion, default is 4");
        boolean fishingInstakill = config.getBoolean("fishing_instakill", dynamiteC.getQualifiedName(), true, "Controls whether the Fishing Dynamite should instakill fish\nIf false, the Fishing Dynamite will instead deal 2x damage to fish\n");
        boolean fishingDamageAll = config.getBoolean("fishing_damage_all", dynamiteC.getQualifiedName(), true, "Controls whether the Fishing Dynamite should deal damage to all entities, or only to fish");
        TargetFilter fishingTargets = GAGConfig.getEnum(config, "fishing_targets", dynamiteC.getQualifiedName(), TargetFilter.class, TargetFilter.HYBRID, "Controls what entities the Fishing Dynamite should target as fish\nValid values are: tag, water_animal, abstract_fish, hybrid (default)\ntag: Only entities with the 'gag:fishing_dynamite_fish' tag will be targeted, this includes all vanilla fish by default\nwater_animal: Only entities that are instances of WaterAnimal will be targeted, note this *will* also include dolphins and other water animals!\nabstract_fish: Only entities that are instances of AbstractFish will be targeted, this might not work with some modded fish that do not extend AbstractFish\nhybrid: Combines the abstract_fish check with the tag filter, this is the default value since it should be the most reliable\n");
        int fishingAdditionalLoot = config.getInt("fishing_additional_loot", dynamiteC.getQualifiedName(), 5, 0, 16, "Describes the amount of additional fish (generated from the vanilla loot table) that may be dropped by Fishing Dynamite\n(This value is random and biased towards dropping less the more fish were already hit by the explosion)\n");
        dynamite = new DynamiteConfig(miningRadius, miningGivesHaste, fishingRadius, fishingInstakill, fishingDamageAll, fishingTargets, fishingAdditionalLoot);
        if (config.hasChanged()) {
            config.save();
        }
    }

    private static <E extends Enum<E>> Property enumProperty(Configuration config, String key, String category, E defaultValue, E[] enumValues, String comment) {
        String[] names = new String[enumValues.length];
        for (int i = 0; i < enumValues.length; ++i) {
            E value = enumValues[i];
            names[i] = ((Enum)value).name();
        }
        return config.get(category, key, defaultValue.name().toLowerCase(Locale.ROOT), comment, names);
    }

    private static <E extends Enum<E>> E getEnum(Configuration config, String key, String category, Class<E> enumClass, E defaultValue, String comment) {
        Enum[] values = (Enum[])enumClass.getEnumConstants();
        String strVal = GAGConfig.enumProperty((Configuration)config, (String)key, (String)category, defaultValue, (Enum[])values, (String)comment).getString();
        for (Enum value : values) {
            if (!value.name().equalsIgnoreCase(strVal)) continue;
            return (E)value;
        }
        GAG.LOGGER.warn("Invalid enum config value: {}, returning default", (Object)strVal);
        return defaultValue;
    }

    private static int seconds(int ticks) {
        return ticks * 20;
    }

    public static void handleSync(HearthstoneConfig hearthstone, RopeConfig escapeRope) {
        GAGConfig.hearthstone = hearthstone;
        GAGConfig.escapeRope = escapeRope;
    }

    @SubscribeEvent
    public static void onClientPlayerDisconnect(ClientPlayerNetworkEvent.LoggingOut event) {
        GAGConfig.load();
    }

    public record PouchConfig(int capacity, Collection<ResourceKey<Level>> levelFilter, boolean invertLevelFilter, int grainsUsed, int durationPerUse, int maxRate, boolean allowRandomTicks, int randomTickChance) {
        public boolean isLevelAllowed(Level level) {
            return this.levelFilter.contains(level.dimension()) == this.invertLevelFilter();
        }
    }

    public record RopeConfig(int durability, int warmup, int cooldown) {
        public static final StreamCodec<ByteBuf, RopeConfig> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, RopeConfig::durability, (StreamCodec)ByteBufCodecs.VAR_INT, RopeConfig::warmup, (StreamCodec)ByteBufCodecs.VAR_INT, RopeConfig::cooldown, RopeConfig::new);
    }

    public record HearthstoneConfig(int durability, int energizedDurability, int range, int dimensionMultiplier, int warmup, int cooldown, boolean allowWorldSpawn, boolean useAnchorCharge, boolean ignoreSpawnBlock) {
        public static final StreamCodec<ByteBuf, HearthstoneConfig> CODEC = new StreamCodec<ByteBuf, HearthstoneConfig>(){

            public HearthstoneConfig decode(ByteBuf buffer) {
                int durability = VarInt.read((ByteBuf)buffer);
                int energizedDurability = VarInt.read((ByteBuf)buffer);
                int range = VarInt.read((ByteBuf)buffer);
                int dimMult = VarInt.read((ByteBuf)buffer);
                int warmup = VarInt.read((ByteBuf)buffer);
                int cooldown = VarInt.read((ByteBuf)buffer);
                byte _bools = buffer.readByte();
                boolean allowWorldSpawn = (_bools & 1) != 0;
                boolean useAnchorCharge = (_bools & 2) != 0;
                boolean ignoreSpawnBlock = (_bools & 4) != 0;
                return new HearthstoneConfig(durability, energizedDurability, range, dimMult, warmup, cooldown, allowWorldSpawn, useAnchorCharge, ignoreSpawnBlock);
            }

            public void encode(ByteBuf buffer, HearthstoneConfig value) {
                VarInt.write((ByteBuf)buffer, (int)value.durability);
                VarInt.write((ByteBuf)buffer, (int)value.energizedDurability);
                VarInt.write((ByteBuf)buffer, (int)value.range);
                VarInt.write((ByteBuf)buffer, (int)value.dimensionMultiplier);
                VarInt.write((ByteBuf)buffer, (int)value.warmup);
                VarInt.write((ByteBuf)buffer, (int)value.cooldown);
                int _bools = 0;
                if (value.allowWorldSpawn) {
                    _bools |= 1;
                }
                if (value.useAnchorCharge) {
                    _bools |= 2;
                }
                if (value.ignoreSpawnBlock) {
                    _bools |= 4;
                }
                buffer.writeByte(_bools);
            }
        };
    }

    public record DynamiteConfig(int miningRadius, boolean miningGivesHaste, int fishingRadius, boolean fishingInstakill, boolean fishingDamageAll, TargetFilter fishingTargets, int fishingAdditionalLoot) {
    }
}

