/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.data;

import java.util.function.Supplier;
import ky.someone.mods.gag.GAGRegistry;
import ky.someone.mods.gag.data.provider.ComponentL10nProvider;
import net.minecraft.ChatFormatting;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class GAGLangProvider
extends ComponentL10nProvider {
    public GAGLangProvider(PackOutput output) {
        super(output, "gag", "en_us");
    }

    @Override
    protected void addTranslations() {
        this.add("itemGroup.gag.gag", "GAG \u2014 Gadgets Against Grind");
        this.add("info.gag.repelling_item", "When applied, gives the player an effect that stops nearby hostile mobs from spawning.");
        this.add("info.gag.supports_unbreaking", "(can be enchanted with Unbreaking and Mending)");
        this.add("info.gag.lightning_crafting_hint", "Strike with Lightning");
        this.addItem((Supplier<? extends Item>)GAGRegistry.TIME_SAND_POUCH, "Temporal Pouch");
        this.addItemSub((Supplier<? extends Item>)GAGRegistry.TIME_SAND_POUCH, "flavour", (Component)Component.literal((String)"If I could save time in a ").append((Component)Component.literal((String)"bottle").withStyle(ChatFormatting.STRIKETHROUGH)).append((Component)Component.literal((String)" bundle...")));
        this.addItemInfo((Supplier<? extends Item>)GAGRegistry.TIME_SAND_POUCH, "stored_grains", "Contains %2$s worth of Grains of Time");
        this.addItemInfo((Supplier<? extends Item>)GAGRegistry.TIME_SAND_POUCH, "Slowly accumulates time while in a player's inventory. Use on a ticking block to accelerate it, using some of the stored time from the pouch.");
        this.addItem((Supplier<? extends Item>)GAGRegistry.ESCAPE_ROPE, "Escape Rope");
        this.addItemSub((Supplier<? extends Item>)GAGRegistry.ESCAPE_ROPE, "no_space", "Could not find any space on the surface to teleport to.");
        this.addItemInfo((Supplier<? extends Item>)GAGRegistry.ESCAPE_ROPE, "Teleports a player out of caves and buildings to the nearest point on the surface.");
        this.addItem((Supplier<? extends Item>)GAGRegistry.HEARTHSTONE, "Hearthstone");
        this.addItem((Supplier<? extends Item>)GAGRegistry.ENERGIZED_HEARTHSTONE, "Energized Hearthstone");
        this.addItemSub((Supplier<? extends Item>)GAGRegistry.HEARTHSTONE, "no_target", "Couldn't find anywhere to teleport to, did you set your spawn point?");
        this.addItemSub((Supplier<? extends Item>)GAGRegistry.HEARTHSTONE, "too_weak", "It seems this hearthstone is too weak to call home from this place.");
        this.addItemSub((Supplier<? extends Item>)GAGRegistry.HEARTHSTONE, "info", "Teleports a player to their personal spawn point, or, if enabled, the world spawn.");
        this.addItemSub((Supplier<? extends Item>)GAGRegistry.HEARTHSTONE, "info_adv", "A stronger hearthstone that has channelled the energy of raw lightning, and can be used to teleport to a single bound location. You can reset the stone by hitting it with lightning again.");
        this.addItemSub((Supplier<? extends Item>)GAGRegistry.HEARTHSTONE, "target.bound", "\ud83e\udded %s");
        this.addItemSub((Supplier<? extends Item>)GAGRegistry.HEARTHSTONE, "target.hidden", "[hidden target]");
        this.addItemSub((Supplier<? extends Item>)GAGRegistry.HEARTHSTONE, "target.unbound", "\ud83e\udded Unbound");
        this.addItemSub((Supplier<? extends Item>)GAGRegistry.HEARTHSTONE, "target.respawn", "Your Respawn Point");
        this.addItemSub((Supplier<? extends Item>)GAGRegistry.HEARTHSTONE, "warmup", "Teleporting in %s seconds...");
        this.addItem((Supplier<? extends Item>)GAGRegistry.LABELING_TOOL, "Labeling Tool");
        this.addItemInfo((Supplier<? extends Item>)GAGRegistry.LABELING_TOOL, "Used to change the name of any item in your inventory at no cost.");
        this.addItemSub((Supplier<? extends Item>)GAGRegistry.LABELING_TOOL, "text_box", "Rename Item");
        this.addItem((Supplier<? extends Item>)GAGRegistry.PIGMENT_JAR, "Pigment Jar");
        this.addItemSub((Supplier<? extends Item>)GAGRegistry.PIGMENT_JAR, "contents", "Contains %s charges of %s");
        this.addItemSub((Supplier<? extends Item>)GAGRegistry.PIGMENT_JAR, "contents.empty", "Empty");
        this.addItemInfo((Supplier<? extends Item>)GAGRegistry.PIGMENT_JAR, "empty.1", "An empty jar used to store pigments. Probably needs to be filled to be useful.");
        this.addItemInfo((Supplier<? extends Item>)GAGRegistry.PIGMENT_JAR, "empty.2", "Hint: Grind up some dye with flint, then add some milk.");
        this.addItemInfo((Supplier<? extends Item>)GAGRegistry.PIGMENT_JAR, "filled.1", "Can be used in a labeling tool to change the color of the item's name.");
        this.addItemInfo((Supplier<? extends Item>)GAGRegistry.PIGMENT_JAR, "filled.2", "Hint: Combine with other pigment jars to mix colors.");
        this.addBlock(GAGRegistry.NO_SOLICITORS_SIGN, "'No Solicitors!' Sign");
        this.addBlockInfo(GAGRegistry.NO_SOLICITORS_SIGN, "1", "Wards off certain pesky intruders within a reasonable area.");
        this.addBlockInfo(GAGRegistry.NO_SOLICITORS_SIGN, "2", "(Right-click with wool to toggle silent mode)");
        this.addBlockSub(GAGRegistry.NO_SOLICITORS_SIGN, "silent", "Silent Mode: %s");
        this.addItem((Supplier<? extends Item>)GAGRegistry.SACRED_SALT, "Sacred Salt");
        this.addItem((Supplier<? extends Item>)GAGRegistry.SACRED_SALVE, "Sacred Salve");
        this.addItem((Supplier<? extends Item>)GAGRegistry.SACRED_BALM, "Sacred Balm");
        this.addItemSub((Supplier<? extends Item>)GAGRegistry.SACRED_SALVE, "extra", "Lasts a bit longer than the salt, and also works in a larger area.");
        this.addItemSub((Supplier<? extends Item>)GAGRegistry.SACRED_BALM, "extra", "Lasts considerably longer than either the salt or salve, but has a reduced radius.");
        this.addEffect((Supplier<? extends MobEffect>)GAGRegistry.REPELLING, "Repelling");
        this.addItem((Supplier<? extends Item>)GAGRegistry.MINING_DYNAMITE_ITEM, "Mining Dynamite");
        this.addItemInfo((Supplier<? extends Item>)GAGRegistry.MINING_DYNAMITE_ITEM, "Throwable explosive that has a high efficiency against stone. Drops all blocks it destroys.");
        this.addItem((Supplier<? extends Item>)GAGRegistry.FISHING_DYNAMITE_ITEM, "Fishing Dynamite");
        this.addItemInfo((Supplier<? extends Item>)GAGRegistry.FISHING_DYNAMITE_ITEM, "Throwable explosive that only works underwater and deals increased damage to fish. Perfect if you don't like fishing!");
        this.add("commands.gag.give_time.success", "Successfully gave %s ticks worth of time to %s");
        this.add("commands.gag.give_time.no_pouch", "%s does not have a temporal pouch in their inventory!");
        this.add("subtitles.gag.entity.dynamite.throw", "Dynamite thrown");
        this.add("subtitles.gag.item.repelling.apply", "Repelling item applied");
        this.add("subtitles.gag.item.time_sand_pouch.ding", "Block tick accelerated");
        this.add("subtitles.gag.item.time_sand_pouch.dong", "Block tick accelerated to very high speed");
        this.add("features.gag.capability_proxy", "Capability Proxies (GAG)");
        this.addBlock(GAGRegistry.ITEM_PROXY, "Item Proxy");
        this.addBlock(GAGRegistry.FLUID_PROXY, "Fluid Proxy");
    }

    public void addItemSub(Supplier<? extends Item> item, String sub, String value) {
        this.addItemSub(item, sub, (Component)Component.literal((String)value));
    }

    public void addItemSub(Supplier<? extends Item> item, String sub, Component value) {
        String key = item.get().getDescriptionId() + "." + sub;
        this.add(key, value);
    }

    public void addBlockSub(Supplier<? extends Block> block, String sub, String value) {
        this.addBlockSub(block, sub, (Component)Component.literal((String)value));
    }

    public void addBlockSub(Supplier<? extends Block> block, String sub, Component value) {
        String key = block.get().getDescriptionId() + "." + sub;
        this.add(key, value);
    }

    public void addItemInfo(Supplier<? extends Item> item, String key, String value) {
        this.addItemSub(item, "info." + key, value);
    }

    public void addItemInfo(Supplier<? extends Item> item, String key, Component value) {
        this.addItemSub(item, "info." + key, value);
    }

    public void addItemInfo(Supplier<? extends Item> item, String value) {
        this.addItemSub(item, "info", value);
    }

    public void addItemInfo(Supplier<? extends Item> item, Component value) {
        this.addItemSub(item, "info", value);
    }

    public void addBlockInfo(Supplier<? extends Block> block, String key, String value) {
        this.addBlockSub(block, "info." + key, value);
    }

    public void addBlockInfo(Supplier<? extends Block> block, String key, Component value) {
        this.addBlockSub(block, "info." + key, value);
    }

    public void addBlockInfo(Supplier<? extends Block> block, String value) {
        this.addBlockSub(block, "info", value);
    }

    public void addBlockInfo(Supplier<? extends Block> block, Component value) {
        this.addBlockSub(block, "info", value);
    }
}

