/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.util.tooltip;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import ky.someone.mods.gag.util.VerticalAlignment;
import ky.someone.mods.gag.util.tooltip.HStackTooltipComponent;
import ky.someone.mods.gag.util.tooltip.ItemTooltipComponent;
import ky.someone.mods.gag.util.tooltip.TooltipSink;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class TooltipListBuilder
implements TooltipSink {
    private final List<Either<Component, TooltipComponent>> tooltips = new ArrayList<Either<Component, TooltipComponent>>();

    public TooltipListBuilder add(TooltipComponent component) {
        this.acceptImage(component);
        return this;
    }

    public TooltipListBuilder text(Component component) {
        this.acceptText(component);
        return this;
    }

    public TooltipListBuilder text(String text) {
        return this.text((Component)Component.literal((String)text));
    }

    public TooltipListBuilder hstack(Consumer<TooltipListBuilder> components) {
        return this.hstack(components, 0);
    }

    public TooltipListBuilder hstack(Consumer<TooltipListBuilder> components, int padding) {
        HStackTooltipComponent list = new HStackTooltipComponent(padding, VerticalAlignment.TOP);
        components.accept(list);
        return this.add(list);
    }

    public TooltipListBuilder item(ItemStack item) {
        return this.add(new ItemTooltipComponent(item));
    }

    public TooltipListBuilder item(ItemLike item) {
        return this.item(item.asItem().getDefaultInstance());
    }

    public TooltipListBuilder itemWithCount(ItemStack item) {
        return this.add(new ItemTooltipComponent(item, true, null));
    }

    public TooltipListBuilder itemWithText(ItemStack item, Component text) {
        return this.add(new ItemTooltipComponent(item, false, text));
    }

    public void build(TooltipSink sink) {
        for (Either<Component, TooltipComponent> tooltip : this.tooltips) {
            tooltip.ifLeft(sink::acceptText).ifRight(sink::acceptImage);
        }
    }

    @Override
    public void acceptText(Component text) {
        this.tooltips.add((Either<Component, TooltipComponent>)Either.left((Object)text));
    }

    @Override
    public void acceptImage(TooltipComponent image) {
        this.tooltips.add((Either<Component, TooltipComponent>)Either.right((Object)image));
    }
}

