/*
 * Decompiled with CFR 0.152.
 */
package loyal0713.serversleepmod;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1928;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_5268;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Serversleepmod
implements ModInitializer {
    public static final String MOD_ID = "serversleepmod";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"serversleepmod");
    private int requiredSleepPercentage = 100;
    private String configFilePath = "config/serversleepmod.cfg";

    public void onInitialize() {
        this.requiredSleepPercentage = this.readConfigFile();
        ServerTickEvents.END_SERVER_TICK.register(this::checkSleepStatus);
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"serversleep").requires(source -> source.method_9259(2))).executes(this::showSleepPercentCommand)).then(class_2170.method_9247((String)"percent").then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(this::setSleepPercentCommand)))).then(class_2170.method_9247((String)"reloadConfig").executes(this::reloadConfigCommand))));
    }

    private int setSleepPercentCommand(CommandContext<class_2168> context) throws CommandSyntaxException {
        int value;
        this.requiredSleepPercentage = value = IntegerArgumentType.getInteger(context, (String)"value");
        this.saveConfigFile(value);
        ((class_2168)context.getSource()).method_9226(class_2561.method_30163((String)("Sleep percentage set to " + value)), false);
        return 1;
    }

    private int showSleepPercentCommand(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(class_2561.method_30163((String)("Current sleep percentage: " + this.requiredSleepPercentage)), false);
        return 1;
    }

    private int reloadConfigCommand(CommandContext<class_2168> context) {
        this.requiredSleepPercentage = this.readConfigFile();
        ((class_2168)context.getSource()).method_9226(class_2561.method_30163((String)("Config reloaded. Sleep percentage is now " + this.requiredSleepPercentage)), false);
        return 1;
    }

    private void checkSleepStatus(MinecraftServer server) {
        List players = server.method_30002().method_18456();
        int sleepingPlayers = 0;
        for (class_3222 player : players) {
            if (player.method_7297() < 100) continue;
            ++sleepingPlayers;
        }
        int required = Math.max(1, (int)Math.ceil((double)(players.size() * this.requiredSleepPercentage) / 100.0));
        if (sleepingPlayers >= required) {
            this.skipNight(server.method_30002(), players);
        }
    }

    private void skipNight(class_3218 server, List<class_3222> players) {
        class_5268 worldProps = (class_5268)server.method_8401();
        if (server.method_8450().method_8355(class_1928.field_19396)) {
            int numDays = (int)(worldProps.method_217() / 24000L);
            long newTime = (numDays + 1) * 24000;
            server.method_29199(newTime);
        }
        if (server.method_8450().method_8355(class_1928.field_19406)) {
            worldProps.method_164(0);
            worldProps.method_157(false);
            worldProps.method_173(0);
            worldProps.method_147(false);
        }
        for (class_3222 player : players) {
            if (!player.method_6113()) continue;
            player.method_7266(class_3468.field_15419.method_14956((Object)class_3468.field_15429));
            player.method_18400();
        }
    }

    private int readConfigFile() {
        try {
            Path path = Paths.get(this.configFilePath, new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                String line = Files.readAllLines(path).get(0).trim();
                String[] parts = line.split("=");
                if (parts.length == 2 && parts[0].trim().equals("sleepPercentage")) {
                    int sleepPercentage = Integer.parseInt(parts[1].trim());
                    return Math.min(100, Math.max(0, sleepPercentage));
                }
            } else {
                this.createConfigFile();
            }
        }
        catch (Exception e) {
            LOGGER.error("Error reading config file", (Throwable)e);
            this.saveConfigFile(this.requiredSleepPercentage);
        }
        return this.requiredSleepPercentage;
    }

    private void saveConfigFile(int sleepPercentage) {
        try {
            Path path = Paths.get(this.configFilePath, new String[0]);
            String content = "sleepPercentage=" + sleepPercentage;
            Files.write(path, content.getBytes(), new OpenOption[0]);
        }
        catch (Exception e) {
            LOGGER.error("Error saving config file", (Throwable)e);
            this.createConfigFile();
        }
    }

    private void createConfigFile() {
        try {
            Path path = Paths.get(this.configFilePath, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                String content = "sleepPercentage=" + this.requiredSleepPercentage;
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.write(path, content.getBytes(), new OpenOption[0]);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error creating config file", (Throwable)e);
        }
    }
}

