/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.commands;

import app.qwertz.qwertzcore.QWERTZcore;
import app.qwertz.qwertzcore.gui.ChatRevivalGUI;
import app.qwertz.qwertzcore.util.ChatListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ChatReviveCommand
implements CommandExecutor {
    private final QWERTZcore plugin;
    private final Random random = new Random();
    private ChatListener activeGame;
    private Map<UUID, ChatRevivalState> playerStates = new HashMap<UUID, ChatRevivalState>();
    private Map<UUID, String> playerQuestions = new HashMap<UUID, String>();
    private Map<UUID, String> playerAnswers = new HashMap<UUID, String>();
    private Map<UUID, Integer> playerGuessMax = new HashMap<UUID, Integer>();
    private Map<UUID, String> playerSelectedGame = new HashMap<UUID, String>();
    private static final List<String> WORDS = Arrays.asList("apple", "banana", "cat", "dog", "elephant", "frog", "giraffe", "house", "ice", "jump", "kite", "lemon", "monkey", "nest", "orange", "penguin", "queen", "rabbit", "sun", "tree", "umbrella", "violin", "water", "xylophone", "yellow", "zebra", "book", "car", "door", "egg", "qwertz");

    public ChatReviveCommand(QWERTZcore plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            this.plugin.getMessageManager().sendMessage(sender, "player-only");
            return false;
        }
        Player player = (Player)sender;
        if (args.length < 1) {
            this.createChatRevivalGUI(player).open();
            return true;
        }
        if (args[0].equalsIgnoreCase("cancel")) {
            this.cancelGame(sender);
            return true;
        }
        if (this.activeGame != null && !this.activeGame.isGameOver()) {
            this.plugin.getMessageManager().sendMessage(sender, "chatrevival.already-going");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "math": {
                this.startMathGame();
                break;
            }
            case "typer": {
                this.startTyperGame();
                break;
            }
            case "guess": {
                int max = 40;
                if (args.length >= 2) {
                    try {
                        max = Integer.parseInt(args[1]);
                    }
                    catch (NumberFormatException e) {
                        this.plugin.getMessageManager().sendMessage(sender, "chatrevival.invalid-number");
                        this.plugin.getSoundManager().playSoundToSender(sender);
                    }
                }
                this.startGuessGame(max);
                break;
            }
            case "custom": {
                if (args.length < 3) {
                    this.plugin.getMessageManager().sendInvalidUsage(sender, "/chatrevival custom <question> <answer>");
                    this.plugin.getSoundManager().playSoundToSender(sender);
                    return false;
                }
                String question = args[1];
                String answer = args[2];
                this.startCustomGame(question, answer);
                break;
            }
            default: {
                this.plugin.getMessageManager().sendMessage(sender, "chatrevival.invalid-game");
                this.plugin.getSoundManager().playSoundToSender(sender);
                return false;
            }
        }
        return true;
    }

    private void startMathGame() {
        int num1 = this.random.nextInt(20) + 1;
        int num2 = this.random.nextInt(20) + 1;
        int num3 = this.random.nextInt(20) + 1;
        char[] operators = new char[]{'+', '-', '*'};
        char op1 = operators[this.random.nextInt(operators.length)];
        char op2 = operators[this.random.nextInt(operators.length)];
        String question = String.format("%d %c %d %c %d", num1, Character.valueOf(op1), num2, Character.valueOf(op2), num3);
        int answer = this.evaluateExpression(num1, num2, num3, op1, op2);
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%question%", question);
        this.plugin.getMessageManager().broadcastMessage("chatrevival.math-question", localMap);
        this.plugin.getMessageManager().broadcastMessage("chatrevival.math-howto");
        this.plugin.getSoundManager().broadcastConfigSound();
        this.activeGame = new ChatListener(this.plugin, answer, "math", this);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this.activeGame, (Plugin)this.plugin);
    }

    private void startTyperGame() {
        int wordCount = this.random.nextInt(5) + 3;
        StringBuilder sentence = new StringBuilder();
        for (int i = 0; i < wordCount; ++i) {
            sentence.append(WORDS.get(this.random.nextInt(WORDS.size()))).append(" ");
        }
        String finalSentence = sentence.toString().trim();
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%sentence%", finalSentence);
        this.plugin.getMessageManager().broadcastMessage("chatrevival.typer-question", localMap);
        this.plugin.getSoundManager().broadcastConfigSound();
        this.activeGame = new ChatListener(this.plugin, finalSentence, "typer", this);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this.activeGame, (Plugin)this.plugin);
    }

    private void startGuessGame(int max) {
        int target = this.random.nextInt(max) + 1;
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%number%", String.valueOf(max));
        this.plugin.getMessageManager().broadcastMessage("chatrevival.guess-question", localMap);
        this.plugin.getSoundManager().broadcastConfigSound();
        this.activeGame = new ChatListener(this.plugin, target, "guess", this);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this.activeGame, (Plugin)this.plugin);
    }

    private int evaluateExpression(int num1, int num2, int num3, char op1, char op2) {
        if (op1 == '*') {
            return this.performOperation(num1 * num2, num3, op2);
        }
        if (op2 == '*') {
            return this.performOperation(num1, num2 * num3, op1);
        }
        return this.performOperation(this.performOperation(num1, num2, op1), num3, op2);
    }

    private int performOperation(int a, int b, char op) {
        switch (op) {
            case '+': {
                return a + b;
            }
            case '-': {
                return a - b;
            }
            case '*': {
                return a * b;
            }
        }
        throw new IllegalArgumentException("Invalid operator: " + op);
    }

    private void startCustomGame(String question, String answer) {
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%question%", question);
        this.plugin.getMessageManager().broadcastMessage("chatrevival.custom-question", localMap);
        this.plugin.getSoundManager().broadcastConfigSound();
        this.activeGame = new ChatListener(this.plugin, answer, "custom", this);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this.activeGame, (Plugin)this.plugin);
    }

    public void setPlayerState(UUID playerId, ChatRevivalState state) {
        this.playerStates.put(playerId, state);
    }

    public ChatRevivalState getPlayerState(UUID playerId) {
        return this.playerStates.get(playerId);
    }

    public void setPlayerQuestion(UUID playerId, String question) {
        this.playerQuestions.put(playerId, question);
    }

    public String getPlayerQuestion(UUID playerId) {
        return this.playerQuestions.getOrDefault(playerId, "");
    }

    public void setPlayerAnswer(UUID playerId, String answer) {
        this.playerAnswers.put(playerId, answer);
    }

    public String getPlayerAnswer(UUID playerId) {
        return this.playerAnswers.getOrDefault(playerId, "");
    }

    public void setPlayerGuessMax(UUID playerId, int max) {
        this.playerGuessMax.put(playerId, max);
    }

    public int getPlayerGuessMax(UUID playerId) {
        return this.playerGuessMax.getOrDefault(playerId, 40);
    }

    public void setPlayerSelectedGame(UUID playerId, String gameType) {
        this.playerSelectedGame.put(playerId, gameType);
    }

    public String getPlayerSelectedGame(UUID playerId) {
        return this.playerSelectedGame.getOrDefault(playerId, "");
    }

    public void clearPlayerState(UUID playerId) {
        this.playerStates.remove(playerId);
        this.playerQuestions.remove(playerId);
        this.playerAnswers.remove(playerId);
        this.playerGuessMax.remove(playerId);
        this.playerSelectedGame.remove(playerId);
    }

    public ChatRevivalGUI createChatRevivalGUI(Player player) {
        return new ChatRevivalGUI(this.plugin, player, this);
    }

    public void startCustomGameFromGUI(Player player) {
        String question = this.getPlayerQuestion(player.getUniqueId());
        String answer = this.getPlayerAnswer(player.getUniqueId());
        if (question.isEmpty() || answer.isEmpty()) {
            this.plugin.getMessageManager().sendMessage(player, "chatrevivalgui.incomplete");
            return;
        }
        this.startCustomGame(question, answer);
        this.clearPlayerState(player.getUniqueId());
    }

    public void startGuessGameFromGUI(Player player) {
        int max = this.getPlayerGuessMax(player.getUniqueId());
        this.startGuessGame(max);
        this.clearPlayerState(player.getUniqueId());
    }

    private void cancelGame(CommandSender sender) {
        if (this.activeGame != null) {
            this.activeGame.cancelGame();
            this.activeGame = null;
            this.plugin.getMessageManager().broadcastMessage("chatrevival.cancelled");
            this.plugin.getSoundManager().broadcastConfigSound();
        } else {
            this.plugin.getMessageManager().sendMessage(sender, "chatrevival.no-active-game");
            this.plugin.getSoundManager().playSoundToSender(sender);
        }
    }

    public void setActiveGameNull() {
        this.activeGame = null;
    }

    public static enum ChatRevivalState {
        QUESTION,
        ANSWER,
        GUESS_MAX;

    }
}

