/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.commands;

import app.qwertz.qwertzcore.QWERTZcore;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class HideCommand
implements CommandExecutor {
    private final QWERTZcore plugin;
    private final Map<UUID, String> playerHideStatus = new HashMap<UUID, String>();
    private final Map<UUID, Integer> playerHideNumber = new HashMap<UUID, Integer>();

    public HideCommand(QWERTZcore plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            this.plugin.getMessageManager().sendMessage(sender, "general.only-player-execute");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return true;
        }
        Player player = (Player)sender;
        if (args.length != 1) {
            this.plugin.getMessageManager().sendInvalidUsage(player, "/hide <number|host|staff|all|off>");
            this.plugin.getSoundManager().playSound(player);
            return true;
        }
        String arg = args[0].toLowerCase();
        try {
            int number = Integer.parseInt(arg);
            if (number < 0) {
                this.plugin.getMessageManager().sendMessage(player, "hide.invalid-number");
                this.plugin.getSoundManager().playSound(player);
                return true;
            }
            this.setHideNumber(player, number);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            switch (arg) {
                case "host": 
                case "staff": 
                case "all": {
                    this.setHideMode(player, arg);
                    break;
                }
                case "off": {
                    this.setHideMode(player, null);
                    break;
                }
                default: {
                    this.plugin.getMessageManager().sendMessage(player, "hide.invalid");
                    this.plugin.getSoundManager().playSound(player);
                    return true;
                }
            }
            return true;
        }
    }

    private void setHideNumber(Player player, int number) {
        this.playerHideNumber.put(player.getUniqueId(), number);
        this.playerHideStatus.remove(player.getUniqueId());
        this.updatePlayerVisibility(player);
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%number%", String.valueOf(number));
        this.plugin.getMessageManager().sendMessage(player, "hide.number-set", localMap);
        this.plugin.getSoundManager().playSound(player);
    }

    private void setHideMode(Player player, String mode) {
        this.playerHideStatus.put(player.getUniqueId(), mode);
        this.playerHideNumber.remove(player.getUniqueId());
        this.updatePlayerVisibility(player);
        if (mode == null) {
            this.plugin.getMessageManager().sendMessage(player, "hide.mode-off");
            this.plugin.getSoundManager().playSound(player);
        } else {
            HashMap<String, String> localMap = new HashMap<String, String>();
            localMap.put("%mode%", mode);
            this.plugin.getMessageManager().sendMessage(player, "hide.mode-on", localMap);
            this.plugin.getSoundManager().playSound(player);
        }
    }

    public void updatePlayerVisibility(Player player) {
        String mode = this.playerHideStatus.get(player.getUniqueId());
        Integer number = this.playerHideNumber.get(player.getUniqueId());
        List otherPlayers = Bukkit.getOnlinePlayers().stream().filter(p -> !p.equals((Object)player)).collect(Collectors.toList());
        if (mode == null && number == null) {
            for (Player otherPlayer : otherPlayers) {
                player.showPlayer((Plugin)this.plugin, otherPlayer);
            }
        } else if (number != null) {
            for (Object otherPlayer : otherPlayers) {
                player.hidePlayer((Plugin)this.plugin, (Player)otherPlayer);
            }
            List playersToShow = otherPlayers.stream().limit(number.intValue()).collect(Collectors.toList());
            for (Player otherPlayer : playersToShow) {
                player.showPlayer((Plugin)this.plugin, otherPlayer);
            }
        } else {
            for (Player otherPlayer : otherPlayers) {
                switch (mode) {
                    case "host": {
                        if (otherPlayer.hasPermission("qwertzcore.host")) {
                            player.showPlayer((Plugin)this.plugin, otherPlayer);
                            break;
                        }
                        player.hidePlayer((Plugin)this.plugin, otherPlayer);
                        break;
                    }
                    case "staff": {
                        if (otherPlayer.hasPermission("qwertzcore.staff")) {
                            player.showPlayer((Plugin)this.plugin, otherPlayer);
                            break;
                        }
                        player.hidePlayer((Plugin)this.plugin, otherPlayer);
                        break;
                    }
                    case "all": {
                        player.hidePlayer((Plugin)this.plugin, otherPlayer);
                    }
                }
            }
        }
    }

    public void handlePlayerJoin(Player newPlayer) {
        this.updateVisibilityForNewPlayer(newPlayer);
        String mode = this.playerHideStatus.get(newPlayer.getUniqueId());
        Integer number = this.playerHideNumber.get(newPlayer.getUniqueId());
        if (mode != null || number != null) {
            this.updatePlayerVisibility(newPlayer);
        }
    }

    public void updateVisibilityForNewPlayer(Player newPlayer) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            List visiblePlayers;
            String mode = this.playerHideStatus.get(player.getUniqueId());
            Integer number = this.playerHideNumber.get(player.getUniqueId());
            if (mode != null) {
                switch (mode) {
                    case "host": {
                        if (newPlayer.hasPermission("qwertzcore.host")) break;
                        player.hidePlayer((Plugin)this.plugin, newPlayer);
                        break;
                    }
                    case "staff": {
                        if (newPlayer.hasPermission("qwertzcore.staff") || newPlayer.hasPermission("qwertzcore.host")) break;
                        player.hidePlayer((Plugin)this.plugin, newPlayer);
                        break;
                    }
                    case "all": {
                        player.hidePlayer((Plugin)this.plugin, newPlayer);
                    }
                }
                continue;
            }
            if (number == null || (visiblePlayers = Bukkit.getOnlinePlayers().stream().filter(p -> !p.equals((Object)player)).limit(number.intValue()).collect(Collectors.toList())).contains(newPlayer)) continue;
            player.hidePlayer((Plugin)this.plugin, newPlayer);
        }
    }
}

