/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.commands;

import app.qwertz.qwertzcore.QWERTZcore;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class SpawnCommand
implements CommandExecutor {
    private final QWERTZcore plugin;
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private final Map<UUID, BukkitTask> pendingTeleports = new HashMap<UUID, BukkitTask>();

    public SpawnCommand(QWERTZcore plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            this.plugin.getMessageManager().sendMessage(sender, "general.only-player-execute");
            return true;
        }
        Player player = (Player)sender;
        UUID playerUUID = player.getUniqueId();
        if (this.plugin.getEventManager().isPlayerDead(player)) {
            this.teleportToSpawn(player, false);
        } else {
            long currentTime = System.currentTimeMillis();
            if (this.cooldowns.containsKey(playerUUID) && currentTime - this.cooldowns.get(playerUUID) < 10000L) {
                this.teleportToSpawn(player, true);
                this.cooldowns.remove(playerUUID);
                if (this.pendingTeleports.containsKey(playerUUID)) {
                    this.pendingTeleports.get(playerUUID).cancel();
                    this.pendingTeleports.remove(playerUUID);
                }
            } else {
                player.sendTitle(this.plugin.getMessageManager().prepareMessage(this.plugin.getMessageManager().getMessage("spawn.alive-title.title"), new HashMap<String, String>()), this.plugin.getMessageManager().prepareMessage(this.plugin.getMessageManager().getMessage("spawn.alive-title.subtitle"), new HashMap<String, String>()), 10, 70, 20);
                this.plugin.getMessageManager().sendMessage(player, "spawn.alive-message");
                this.plugin.getSoundManager().playSound(player);
                this.cooldowns.put(playerUUID, currentTime);
                BukkitTask task = this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                    this.cooldowns.remove(playerUUID);
                    this.pendingTeleports.remove(playerUUID);
                }, 200L);
                this.pendingTeleports.put(playerUUID, task);
            }
        }
        return true;
    }

    private void unrevivePlayer(Player player) {
        this.plugin.getEventManager().handlePlayerDeath(player, true);
        this.plugin.getMessageManager().sendMessage(player, "spawn.spawn-while-alive");
        this.plugin.getSoundManager().playSound(player);
    }

    private void teleportToSpawn(Player player, boolean wasAlive) {
        Location spawnLocation = this.plugin.getConfigManager().getSpawnLocation();
        if (spawnLocation != null) {
            if (this.plugin.getConfigManager().getClearOnTp() && !player.hasPermission("qwertzcore.staff.bypassclear")) {
                player.getInventory().clear();
                player.getInventory().setArmorContents(new ItemStack[4]);
                player.getInventory().setItemInOffHand(null);
                if (player.getOpenInventory() != null) {
                    player.getOpenInventory().setCursor(null);
                    player.getOpenInventory().getTopInventory().clear();
                }
            }
            player.teleport(spawnLocation);
            this.plugin.getMessageManager().sendMessage(player, "spawn.success");
            this.plugin.getSoundManager().playSound(player);
            if (wasAlive) {
                this.unrevivePlayer(player);
            }
        } else {
            this.plugin.getMessageManager().sendMessage(player, "spawn.no-spawn");
            this.plugin.getSoundManager().playSound(player);
        }
    }
}

