/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.commands;

import app.qwertz.qwertzcore.QWERTZcore;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class VanishCommands
implements CommandExecutor {
    private final QWERTZcore plugin;

    public VanishCommands(QWERTZcore plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        switch (label.toLowerCase()) {
            case "vanish": {
                return this.vanish(sender);
            }
            case "unvanish": {
                return this.unVanish(sender);
            }
        }
        return false;
    }

    public boolean vanish(CommandSender sender) {
        if (!(sender instanceof Player)) {
            this.plugin.getMessageManager().sendMessage(sender, "general.only-player-execute");
            return true;
        }
        if (!this.plugin.getVanishManager().getVanishedPlayers().contains(((Player)sender).getUniqueId())) {
            if (this.plugin.getConfigManager().getMsgsOnVanish()) {
                int fakeCount = this.plugin.getVanishManager().getNonVanishedPlayerCount();
                int newCount = fakeCount - 1;
                HashMap<String, String> localMap = new HashMap<String, String>();
                localMap.put("%name%", sender.getName());
                localMap.put("%fakeCount%", String.valueOf(fakeCount));
                localMap.put("%newCount%", String.valueOf(newCount));
                this.plugin.getMessageManager().broadcastMessage("vanish.leave-msg", localMap);
                this.plugin.getSoundManager().broadcastConfigSound();
            }
            this.plugin.getMessageManager().sendMessage(sender, "vanish.you-got-vanished");
            this.plugin.getVanishManager().addVanishedPlayer((Player)sender);
            for (Player loop : Bukkit.getOnlinePlayers()) {
                loop.hidePlayer((Player)sender);
            }
        } else {
            this.plugin.getMessageManager().sendMessage(sender, "vanish.already-vanished");
            this.plugin.getSoundManager().playSoundToSender(sender);
        }
        return true;
    }

    public boolean unVanish(CommandSender sender) {
        if (!(sender instanceof Player)) {
            this.plugin.getMessageManager().sendMessage(sender, "general.only-player-execute");
            return true;
        }
        if (this.plugin.getVanishManager().getVanishedPlayers().contains(((Player)sender).getUniqueId())) {
            if (this.plugin.getConfigManager().getMsgsOnVanish()) {
                int fakeCount = this.plugin.getVanishManager().getNonVanishedPlayerCount();
                int newCount = fakeCount + 1;
                HashMap<String, String> localMap = new HashMap<String, String>();
                localMap.put("%name%", sender.getName());
                localMap.put("%fakeCount%", String.valueOf(fakeCount));
                localMap.put("%newCount%", String.valueOf(newCount));
                this.plugin.getMessageManager().broadcastMessage("vanish.join-msg", localMap);
                this.plugin.getSoundManager().broadcastConfigSound();
            }
            this.plugin.getMessageManager().sendMessage(sender, "vanish.you-got-unvanished");
            this.plugin.getSoundManager().playSoundToSender(sender);
            this.plugin.getVanishManager().removeVanishedPlayer((Player)sender);
            for (Player loop : Bukkit.getOnlinePlayers()) {
                loop.showPlayer((Player)sender);
            }
        } else {
            this.plugin.getMessageManager().sendMessage(sender, "vanish.not-vanished");
            this.plugin.getSoundManager().playSoundToSender(sender);
        }
        return true;
    }
}

