/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.gui;

import app.qwertz.qwertzcore.QWERTZcore;
import app.qwertz.qwertzcore.commands.ChatReviveCommand;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class ChatRevivalGUI
implements Listener {
    private static final Map<UUID, PendingInput> pendingInputs = new HashMap<UUID, PendingInput>();
    private final QWERTZcore plugin;
    private final Player player;
    private final ChatReviveCommand chatReviveCommand;
    private Inventory inventory;

    public ChatRevivalGUI(QWERTZcore plugin, Player player, ChatReviveCommand chatReviveCommand) {
        this.plugin = plugin;
        this.player = player;
        this.chatReviveCommand = chatReviveCommand;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.inventory = this.buildGUI();
    }

    public void open() {
        this.player.openInventory(this.inventory);
    }

    private Inventory buildGUI() {
        Inventory gui = Bukkit.createInventory(null, (int)27, (String)(QWERTZcore.CORE_ICON + " " + String.valueOf(ChatColor.DARK_PURPLE) + "Chat Revival"));
        ItemStack blackPane = new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
        for (int i = 0; i < 27; ++i) {
            gui.setItem(i, blackPane);
        }
        String question = this.chatReviveCommand.getPlayerQuestion(this.player.getUniqueId());
        String answer = this.chatReviveCommand.getPlayerAnswer(this.player.getUniqueId());
        String selectedGame = this.chatReviveCommand.getPlayerSelectedGame(this.player.getUniqueId());
        int currentGuessMax = this.chatReviveCommand.getPlayerGuessMax(this.player.getUniqueId());
        ItemStack mathItem = this.createItem(Material.PAPER, "\u00a7eMath Game", "\u00a77Start a math question game", "\u00a77Players solve math problems");
        if (selectedGame.equals("math")) {
            mathItem.addUnsafeEnchantment(Enchantment.values()[0], 1);
        }
        gui.setItem(10, mathItem);
        ItemStack typerItem = this.createItem(Material.BOOK, "\u00a7eTyper Game", "\u00a77Start a typing game", "\u00a77Players type random sentences");
        if (selectedGame.equals("typer")) {
            typerItem.addUnsafeEnchantment(Enchantment.values()[0], 1);
        }
        gui.setItem(11, typerItem);
        ItemStack guessItem = this.createItem(Material.COMPASS, "\u00a7eGuess Game", "\u00a77Start a number guessing game", "\u00a77Max number: \u00a7a" + currentGuessMax, "\u00a77Click to set max number or start game");
        if (selectedGame.equals("guess")) {
            guessItem.addUnsafeEnchantment(Enchantment.values()[0], 1);
        }
        gui.setItem(12, guessItem);
        ItemStack customItem = this.createItem(Material.NAME_TAG, "\u00a7eCustom Game", "\u00a77Create a custom question", "\u00a77Question: " + (String)(question.isEmpty() ? "\u00a7cNot set" : "\u00a7a" + question), "\u00a77Answer: " + (String)(answer.isEmpty() ? "\u00a7cNot set" : "\u00a7a" + answer), "\u00a77Click to set question and answer");
        if (selectedGame.equals("custom")) {
            customItem.addUnsafeEnchantment(Enchantment.values()[0], 1);
        }
        gui.setItem(13, customItem);
        if (!selectedGame.isEmpty()) {
            Object startLore = "";
            switch (selectedGame) {
                case "math": {
                    startLore = "\u00a77Click to start the math game";
                    break;
                }
                case "typer": {
                    startLore = "\u00a77Click to start the typer game";
                    break;
                }
                case "guess": {
                    startLore = "\u00a77Click to start the guess game\n\u00a77Max number: \u00a7a" + currentGuessMax;
                    break;
                }
                case "custom": {
                    startLore = !question.isEmpty() && !answer.isEmpty() ? "\u00a77Click to start the custom game\n\u00a77Question: \u00a7a" + question + "\n\u00a77Answer: \u00a7a" + answer : "\u00a7cSet question and answer first";
                }
            }
            gui.setItem(16, this.createItem(Material.EMERALD_BLOCK, "\u00a7aStart " + selectedGame.substring(0, 1).toUpperCase() + selectedGame.substring(1) + " Game", ((String)startLore).split("\n")));
        }
        gui.setItem(22, this.createItem(Material.REDSTONE_BLOCK, "\u00a7cCancel", "\u00a77Click to close the GUI"));
        return gui;
    }

    private ItemStack createItem(Material material, String name, String ... lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            if (lore.length > 0) {
                meta.setLore(Arrays.asList(lore));
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getInventory() != this.inventory) {
            return;
        }
        event.setCancelled(true);
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player clicker = (Player)event.getWhoClicked();
        if (!clicker.equals((Object)this.player)) {
            return;
        }
        int slot = event.getRawSlot();
        switch (slot) {
            case 10: {
                this.selectGame("math");
                break;
            }
            case 11: {
                this.selectGame("typer");
                break;
            }
            case 12: {
                this.selectGame("guess");
                break;
            }
            case 13: {
                this.selectGame("custom");
                break;
            }
            case 16: {
                this.startSelectedGame();
                break;
            }
            case 22: {
                this.chatReviveCommand.clearPlayerState(this.player.getUniqueId());
                ChatRevivalGUI.removePendingInput(this.player.getUniqueId());
                clicker.closeInventory();
            }
        }
    }

    private void selectGame(String gameType) {
        this.chatReviveCommand.setPlayerSelectedGame(this.player.getUniqueId(), gameType);
        if (gameType.equals("guess")) {
            this.requestGuessMaxInput(this.player);
        } else if (gameType.equals("custom")) {
            this.requestQuestionInput(this.player);
        } else {
            this.refreshGUI();
        }
    }

    private void startSelectedGame() {
        String selectedGame;
        switch (selectedGame = this.chatReviveCommand.getPlayerSelectedGame(this.player.getUniqueId())) {
            case "math": {
                this.startMathGame(this.player);
                break;
            }
            case "typer": {
                this.startTyperGame(this.player);
                break;
            }
            case "guess": {
                this.startGuessGame(this.player);
                break;
            }
            case "custom": {
                this.startCustomGame(this.player);
            }
        }
    }

    private void startMathGame(Player player) {
        player.closeInventory();
        this.chatReviveCommand.onCommand((CommandSender)player, null, "chatrevival", new String[]{"math"});
    }

    private void startTyperGame(Player player) {
        player.closeInventory();
        this.chatReviveCommand.onCommand((CommandSender)player, null, "chatrevival", new String[]{"typer"});
    }

    private void startGuessGame(Player player) {
        this.chatReviveCommand.startGuessGameFromGUI(player);
        player.closeInventory();
    }

    private void startCustomGame(Player player) {
        this.chatReviveCommand.startCustomGameFromGUI(player);
        player.closeInventory();
    }

    private void requestQuestionInput(Player player) {
        this.chatReviveCommand.setPlayerState(player.getUniqueId(), ChatReviveCommand.ChatRevivalState.QUESTION);
        pendingInputs.put(player.getUniqueId(), new PendingInput(ChatReviveCommand.ChatRevivalState.QUESTION));
        player.closeInventory();
        this.plugin.getMessageManager().sendMessage(player, "chatrevivalgui.enter-question");
    }

    private void requestGuessMaxInput(Player player) {
        this.chatReviveCommand.setPlayerState(player.getUniqueId(), ChatReviveCommand.ChatRevivalState.GUESS_MAX);
        pendingInputs.put(player.getUniqueId(), new PendingInput(ChatReviveCommand.ChatRevivalState.GUESS_MAX));
        player.closeInventory();
        this.plugin.getMessageManager().sendMessage(player, "chatrevivalgui.enter-guess-max");
    }

    private void refreshGUI() {
        this.inventory = this.buildGUI();
        this.player.openInventory(this.inventory);
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getInventory() != this.inventory) {
            return;
        }
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player closer = (Player)event.getPlayer();
        if (!closer.equals((Object)this.player)) {
            return;
        }
        if (!pendingInputs.containsKey(this.player.getUniqueId())) {
            HandlerList.unregisterAll((Listener)this);
        }
    }

    public static void handleChatInput(Player player, final String input, QWERTZcore plugin, ChatReviveCommand chatReviveCommand) {
        PendingInput pending = pendingInputs.get(player.getUniqueId());
        if (pending == null) {
            return;
        }
        switch (pending.getState()) {
            case QUESTION: {
                chatReviveCommand.setPlayerQuestion(player.getUniqueId(), input);
                plugin.getMessageManager().sendMessage(player, "chatrevivalgui.question-set", new HashMap<String, String>(){
                    {
                        this.put("%question%", input);
                    }
                });
                chatReviveCommand.setPlayerState(player.getUniqueId(), ChatReviveCommand.ChatRevivalState.ANSWER);
                pendingInputs.put(player.getUniqueId(), new PendingInput(ChatReviveCommand.ChatRevivalState.ANSWER));
                plugin.getMessageManager().sendMessage(player, "chatrevivalgui.enter-answer");
                break;
            }
            case ANSWER: {
                chatReviveCommand.setPlayerAnswer(player.getUniqueId(), input);
                plugin.getMessageManager().sendMessage(player, "chatrevivalgui.answer-set", new HashMap<String, String>(){
                    {
                        this.put("%answer%", input);
                    }
                });
                pendingInputs.remove(player.getUniqueId());
                Bukkit.getScheduler().runTask((Plugin)plugin, () -> chatReviveCommand.createChatRevivalGUI(player).open());
                break;
            }
            case GUESS_MAX: {
                try {
                    int max = Integer.parseInt(input);
                    if (max > 0) {
                        chatReviveCommand.setPlayerGuessMax(player.getUniqueId(), max);
                        plugin.getMessageManager().sendMessage(player, "chatrevivalgui.guess-max-set", new HashMap<String, String>(){
                            {
                                this.put("%max%", input);
                            }
                        });
                        pendingInputs.remove(player.getUniqueId());
                        Bukkit.getScheduler().runTask((Plugin)plugin, () -> chatReviveCommand.createChatRevivalGUI(player).open());
                        break;
                    }
                    plugin.getMessageManager().sendMessage(player, "chatrevivalgui.invalid-number");
                    break;
                }
                catch (NumberFormatException e) {
                    plugin.getMessageManager().sendMessage(player, "chatrevivalgui.invalid-number");
                }
            }
        }
    }

    public static void removePendingInput(UUID playerId) {
        pendingInputs.remove(playerId);
    }

    public static boolean hasPendingInput(UUID playerId) {
        return pendingInputs.containsKey(playerId);
    }

    private static class PendingInput {
        private final ChatReviveCommand.ChatRevivalState state;

        public PendingInput(ChatReviveCommand.ChatRevivalState state) {
            this.state = state;
        }

        public ChatReviveCommand.ChatRevivalState getState() {
            return this.state;
        }
    }
}

