/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.gui;

import app.qwertz.qwertzcore.QWERTZcore;
import app.qwertz.qwertzcore.commands.PollCommand;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class PollGUI
implements Listener {
    private static final Map<UUID, PendingInput> pendingInputs = new HashMap<UUID, PendingInput>();
    private final QWERTZcore plugin;
    private final Player player;
    private final PollCommand pollCommand;
    private Inventory inventory;

    public PollGUI(QWERTZcore plugin, Player player, PollCommand pollCommand) {
        this.plugin = plugin;
        this.player = player;
        this.pollCommand = pollCommand;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.inventory = this.buildGUI();
    }

    public void open() {
        this.player.openInventory(this.inventory);
    }

    private Inventory buildGUI() {
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)(QWERTZcore.CORE_ICON + " " + String.valueOf(ChatColor.DARK_PURPLE) + "Poll Creator"));
        ItemStack blackPane = new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
        for (int i = 0; i < 54; ++i) {
            gui.setItem(i, blackPane);
        }
        String question = this.pollCommand.getPlayerQuestion(this.player.getUniqueId());
        int duration = this.pollCommand.getPlayerDuration(this.player.getUniqueId());
        List<String> options = this.pollCommand.getPlayerOptions(this.player.getUniqueId());
        gui.setItem(13, this.createItem(Material.PAPER, "\u00a7eQuestion", "\u00a77Current: " + (String)(question.isEmpty() ? "\u00a7cNot set" : "\u00a7a" + question), "\u00a77Click to set the poll question"));
        gui.setItem(12, this.createItem(Material.CLOCK, "\u00a7eDuration", "\u00a77Current: \u00a7a" + duration + " seconds", "\u00a77Click to change duration"));
        gui.setItem(14, this.createItem(Material.BOOK, "\u00a7eOptions", "\u00a77Current: \u00a7a" + options.size() + " options", "\u00a77Click to add options"));
        gui.setItem(19, this.createItem(Material.EMERALD_BLOCK, "\u00a7aCreate Poll", "\u00a77Click to create the poll", "\u00a77Question: " + (String)(question.isEmpty() ? "\u00a7cNot set" : "\u00a7a" + question), "\u00a77Duration: \u00a7a" + duration + " seconds", "\u00a77Options: \u00a7a" + options.size()));
        gui.setItem(25, this.createItem(Material.REDSTONE_BLOCK, "\u00a7cCancel", "\u00a77Click to cancel poll creation"));
        if (!options.isEmpty()) {
            for (int i = 0; i < Math.min(options.size(), 9); ++i) {
                gui.setItem(36 + i, this.createItem(Material.NAME_TAG, "\u00a7bOption " + (i + 1), "\u00a77" + options.get(i), "\u00a7cClick to remove!"));
            }
        }
        return gui;
    }

    private ItemStack createItem(Material material, String name, String ... lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            if (lore.length > 0) {
                meta.setLore(Arrays.asList(lore));
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getInventory() != this.inventory) {
            return;
        }
        event.setCancelled(true);
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player clicker = (Player)event.getWhoClicked();
        if (!clicker.equals((Object)this.player)) {
            return;
        }
        int slot = event.getRawSlot();
        switch (slot) {
            case 13: {
                this.requestInput(clicker, PollCommand.PollCreationState.QUESTION, "Enter the poll question:");
                break;
            }
            case 12: {
                this.requestInput(clicker, PollCommand.PollCreationState.DURATION, "Enter the poll duration in seconds:");
                break;
            }
            case 14: {
                this.requestInput(clicker, PollCommand.PollCreationState.OPTIONS, "Enter a poll option:");
                break;
            }
            case 19: {
                this.createPoll(clicker);
                break;
            }
            case 25: {
                this.pollCommand.clearPlayerState(this.player.getUniqueId());
                PollGUI.removePendingInput(this.player.getUniqueId());
                clicker.closeInventory();
                break;
            }
            default: {
                List<String> currentOptions;
                int optionIndex;
                if (slot < 36 || slot > 44 || (optionIndex = slot - 36) >= (currentOptions = this.pollCommand.getPlayerOptions(this.player.getUniqueId())).size()) break;
                final String removedOption = currentOptions.remove(optionIndex);
                this.pollCommand.setPlayerOptions(this.player.getUniqueId(), currentOptions);
                this.plugin.getMessageManager().sendMessage(clicker, "pollgui.option-removed", new HashMap<String, String>(){
                    {
                        this.put("%option%", removedOption);
                    }
                });
                clicker.closeInventory();
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.pollCommand.createPollGUI(clicker).open());
            }
        }
    }

    private void requestInput(Player player, PollCommand.PollCreationState state, final String message) {
        this.pollCommand.setPlayerState(player.getUniqueId(), state);
        pendingInputs.put(player.getUniqueId(), new PendingInput(state));
        player.closeInventory();
        this.plugin.getMessageManager().sendMessage(player, "pollgui.enter-value", new HashMap<String, String>(){
            {
                this.put("%message%", message);
            }
        });
    }

    private void createPoll(Player player) {
        String question = this.pollCommand.getPlayerQuestion(player.getUniqueId());
        int duration = this.pollCommand.getPlayerDuration(player.getUniqueId());
        List<String> options = this.pollCommand.getPlayerOptions(player.getUniqueId());
        if (question.isEmpty()) {
            this.plugin.getMessageManager().sendMessage(player, "pollgui.no-question");
            return;
        }
        if (options.size() < 2) {
            this.plugin.getMessageManager().sendMessage(player, "pollgui.not-enough-options");
            return;
        }
        this.pollCommand.createPollFromGUI(player, duration, question, options);
        this.pollCommand.clearPlayerState(player.getUniqueId());
        player.closeInventory();
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getInventory() != this.inventory) {
            return;
        }
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player closer = (Player)event.getPlayer();
        if (!closer.equals((Object)this.player)) {
            return;
        }
        if (!pendingInputs.containsKey(this.player.getUniqueId())) {
            HandlerList.unregisterAll((Listener)this);
        }
    }

    public static void handleChatInput(Player player, final String input, QWERTZcore plugin, PollCommand pollCommand) {
        PendingInput pending = pendingInputs.get(player.getUniqueId());
        if (pending == null) {
            return;
        }
        switch (pending.getState()) {
            case QUESTION: {
                pollCommand.setPlayerQuestion(player.getUniqueId(), input);
                plugin.getMessageManager().sendMessage(player, "pollgui.question-set", new HashMap<String, String>(){
                    {
                        this.put("%question%", input);
                    }
                });
                break;
            }
            case DURATION: {
                try {
                    final int duration = Integer.parseInt(input);
                    if (duration <= 0) {
                        plugin.getMessageManager().sendMessage(player, "pollgui.invalid-duration");
                        return;
                    }
                    pollCommand.setPlayerDuration(player.getUniqueId(), duration);
                    plugin.getMessageManager().sendMessage(player, "pollgui.duration-set", new HashMap<String, String>(){
                        {
                            this.put("%duration%", String.valueOf(duration));
                        }
                    });
                    break;
                }
                catch (NumberFormatException e) {
                    plugin.getMessageManager().sendMessage(player, "pollgui.invalid-duration");
                    return;
                }
            }
            case OPTIONS: {
                List<String> currentOptions = pollCommand.getPlayerOptions(player.getUniqueId());
                if (currentOptions.size() >= 9) {
                    plugin.getMessageManager().sendMessage(player, "pollgui.too-many-options");
                    return;
                }
                currentOptions.add(input);
                pollCommand.setPlayerOptions(player.getUniqueId(), currentOptions);
                plugin.getMessageManager().sendMessage(player, "pollgui.option-added", new HashMap<String, String>(){
                    {
                        this.put("%option%", input);
                    }
                });
            }
        }
        pendingInputs.remove(player.getUniqueId());
        Bukkit.getScheduler().runTask((Plugin)plugin, () -> pollCommand.createPollGUI(player).open());
    }

    public static void removePendingInput(UUID playerId) {
        pendingInputs.remove(playerId);
    }

    public static boolean hasPendingInput(UUID playerId) {
        return pendingInputs.containsKey(playerId);
    }

    private static class PendingInput {
        private final PollCommand.PollCreationState state;

        public PendingInput(PollCommand.PollCreationState state) {
            this.state = state;
        }

        public PollCommand.PollCreationState getState() {
            return this.state;
        }
    }
}

