/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.listeners;

import app.qwertz.qwertzcore.QWERTZcore;
import app.qwertz.qwertzcore.commands.ChatReviveCommand;
import app.qwertz.qwertzcore.gui.ChatRevivalGUI;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class ChatRevivalChatListener
implements Listener {
    private final QWERTZcore plugin;
    private final ChatReviveCommand chatReviveCommand;

    public ChatRevivalChatListener(QWERTZcore plugin, ChatReviveCommand chatReviveCommand) {
        this.plugin = plugin;
        this.chatReviveCommand = chatReviveCommand;
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        if (ChatRevivalGUI.hasPendingInput(event.getPlayer().getUniqueId())) {
            event.setCancelled(true);
            String input = event.getMessage();
            ChatRevivalGUI.handleChatInput(event.getPlayer(), input, this.plugin, this.chatReviveCommand);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        ChatRevivalGUI.removePendingInput(event.getPlayer().getUniqueId());
        this.chatReviveCommand.clearPlayerState(event.getPlayer().getUniqueId());
    }
}

