/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.util;

import app.qwertz.qwertzcore.QWERTZcore;
import app.qwertz.qwertzcore.blocks.QWERTZcoreBlock;
import app.qwertz.qwertzcore.util.BlockManager;
import java.util.HashMap;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class BlockEventListener
implements Listener {
    private final QWERTZcore plugin;

    public BlockEventListener(QWERTZcore plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        String displayName;
        Player player = event.getPlayer();
        Block block = event.getBlockPlaced();
        ItemStack item = event.getItemInHand();
        ItemMeta meta = item.getItemMeta();
        if (meta != null && meta.hasDisplayName() && (displayName = ChatColor.stripColor((String)meta.getDisplayName())).startsWith("\u2747 QWERTZ Core ")) {
            String blockType = displayName.substring("\u2747 QWERTZ Core ".length());
            BlockManager blockManager = this.plugin.getBlockManager();
            if (blockManager.isValidBlockType(blockType)) {
                blockManager.setSpecialBlock(block.getLocation(), blockType, block.getType());
                if (((Boolean)this.plugin.getConfigManager().get("specialBlockOutput")).booleanValue()) {
                    HashMap<String, String> localMap = new HashMap<String, String>();
                    localMap.put("%blockType%", blockType);
                    localMap.put("%x%", String.valueOf(block.getLocation().getBlockX()));
                    localMap.put("%y%", String.valueOf(block.getLocation().getBlockY()));
                    localMap.put("%z%", String.valueOf(block.getLocation().getBlockZ()));
                    localMap.put("%world%", block.getWorld().getName());
                    this.plugin.getMessageManager().sendMessage(player, "specialblocks.place", localMap);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        BlockManager blockManager = this.plugin.getBlockManager();
        QWERTZcoreBlock specialBlock = blockManager.getSpecialBlock(block.getLocation());
        if (specialBlock != null) {
            specialBlock.onMine(event.getPlayer(), block);
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                if (!event.isCancelled()) {
                    blockManager.removeSpecialBlock(block.getLocation());
                    if (((Boolean)this.plugin.getConfigManager().get("specialBlockOutput")).booleanValue()) {
                        HashMap<String, String> localMap = new HashMap<String, String>();
                        localMap.put("%x%", String.valueOf(block.getLocation().getBlockX()));
                        localMap.put("%y%", String.valueOf(block.getLocation().getBlockY()));
                        localMap.put("%z%", String.valueOf(block.getLocation().getBlockZ()));
                        localMap.put("%world%", block.getWorld().getName());
                        this.plugin.getMessageManager().sendMessage(event.getPlayer(), "specialblocks.remove", localMap);
                    }
                }
            });
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        Location playerLoc = player.getLocation();
        Block blockInside = playerLoc.getBlock();
        Block blockBelow = playerLoc.subtract(0.0, 1.0, 0.0).getBlock();
        this.checkAndTriggerBlock(player, blockInside);
        this.checkAndTriggerBlock(player, blockBelow);
    }

    private void checkAndTriggerBlock(Player player, Block block) {
        BlockManager blockManager = this.plugin.getBlockManager();
        QWERTZcoreBlock specialBlock = blockManager.getSpecialBlock(block.getLocation());
        if (specialBlock != null) {
            specialBlock.onTouch(player, block);
        }
    }
}

