/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.util;

import app.qwertz.qwertzcore.QWERTZcore;
import app.qwertz.qwertzcore.util.OptionalTypeAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.CompassMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionType;

public class ConfigManager {
    private final QWERTZcore plugin;
    private final File configFile;
    private final File warpsFile;
    private final File kitsFile;
    private final File kitsYamlFile;
    private final Gson gson;
    private Map<String, Object> config;
    private Set<String> keep;
    private Map<String, Map<String, Object>> warps;
    private Map<String, List<Map<String, Object>>> kits;
    private YamlConfiguration kitsYaml;

    public ConfigManager(QWERTZcore plugin) {
        this.plugin = plugin;
        this.configFile = new File(plugin.getDataFolder(), "config.json");
        this.warpsFile = new File(plugin.getDataFolder(), "warps.json");
        this.kitsFile = new File(plugin.getDataFolder(), "kits.json");
        this.kitsYamlFile = new File(plugin.getDataFolder(), "kits.yml");
        this.gson = new GsonBuilder().registerTypeAdapter(Optional.class, (Object)new OptionalTypeAdapter()).enableComplexMapKeySerialization().setPrettyPrinting().create();
        this.config = new HashMap<String, Object>();
        this.warps = new HashMap<String, Map<String, Object>>();
        this.kits = new HashMap<String, List<Map<String, Object>>>();
        this.kitsYaml = new YamlConfiguration();
        this.ensurePluginFolder();
        this.loadConfig();
        this.loadWarps();
        this.loadKits();
    }

    public void loadConfig() {
        if (!this.configFile.exists()) {
            this.createDefaultConfig();
        }
        try (FileReader reader = new FileReader(this.configFile);){
            this.config = (Map)this.gson.fromJson((Reader)reader, Map.class);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Could not load config file: " + e.getMessage());
            this.createDefaultConfig();
        }
        if (this.config == null) {
            this.config = new HashMap<String, Object>();
        }
        this.ensureConfigDefaults();
    }

    public void loadWarps() {
        if (!this.warpsFile.exists()) {
            this.saveWarps();
        }
        try (FileReader reader = new FileReader(this.warpsFile);){
            this.warps = (Map)this.gson.fromJson((Reader)reader, Map.class);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Could not load warps file: " + e.getMessage());
            this.saveWarps();
        }
        if (this.warps == null) {
            this.warps = new HashMap<String, Map<String, Object>>();
        }
    }

    private void createDefaultConfig() {
        this.config = new HashMap<String, Object>();
        this.ensureConfigDefaults();
        this.saveConfig();
        this.plugin.getLogger().info("Created default config.json file");
    }

    private void ensureConfigDefaults() {
        HashSet<String> keysToRemove = new HashSet<String>(this.config.keySet());
        this.keep = new HashSet<String>();
        this.addDefault("spawn", null);
        this.addDefault("tpOnRevive", true);
        this.addDefault("tpOnUnrevive", true);
        this.addDefault("tpOnDeath", true);
        this.addDefault("tpOnJoin", true);
        this.addDefault("server", "My Server");
        this.addDefault("event", "Event");
        this.addDefault("sound", true);
        this.addDefault("soundEffect", "BLOCK_NOTE_BLOCK_PLING");
        this.addDefault("soundPitch", 1);
        this.addDefault("soundVolume", 100);
        this.addDefault("reviveTokensEnabled", true);
        this.addDefault("discord", "https://discord.gg/Vp6Q4FHCzf");
        this.addDefault("youtube", "https://youtube.com");
        this.addDefault("store", "https://yourstore.com");
        this.addDefault("tiktok", "https://tiktok.com");
        this.addDefault("twitch", "https://twitch.tv");
        this.addDefault("website", "https://qwertz.app");
        this.addDefault("other", "https://example.com");
        this.addDefault("chat", true);
        this.addDefault("doScoreboard", true);
        this.addDefault("doTabList", true);
        this.addDefault("doChat", true);
        this.addDefault("checkForUpdates", true);
        this.addDefault("specialBlockOutput", false);
        this.addDefault("joinLeaveMsgsOnVanish", true);
        this.addDefault("suppressVanilla", true);
        this.addDefault("biggerMessages", true);
        this.addDefault("chatTimer", true);
        this.addDefault("reviveStaff", false);
        this.addDefault("emojis", true);
        this.addDefault("coloredChat", true);
        this.addDefault("allowRejoining", true);
        this.addDefault("rejoinTime", 30);
        this.addDefault("clearOnJoin", true);
        this.addDefault("clearOnTp", true);
        System.out.print(this.keep);
        keysToRemove.removeAll(this.keep);
        for (String key : keysToRemove) {
            this.config.remove(key);
            this.plugin.getLogger().info("Removed deprecated config key: " + key);
        }
        this.saveConfig();
    }

    private void addDefault(String key, Object defaultValue) {
        this.keep.add(key);
        if (!this.config.containsKey(key)) {
            if (key.equals("spawn")) {
                this.setDefaultSpawnLocation();
            } else {
                this.config.put(key, defaultValue);
            }
        }
    }

    private String getDefaultWorldName() {
        String string;
        File serverProperties = new File(this.plugin.getServer().getWorldContainer(), "server.properties");
        Properties props = new Properties();
        FileInputStream fis = new FileInputStream(serverProperties);
        try {
            props.load(fis);
            string = props.getProperty("level-name", "world");
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Could not read server.properties: " + e.getMessage());
                return "world";
            }
        }
        fis.close();
        return string;
    }

    private void setDefaultSpawnLocation() {
        HashMap<String, Object> spawnMap = new HashMap<String, Object>();
        spawnMap.put("world", this.getDefaultWorldName());
        spawnMap.put("x", 0.0);
        spawnMap.put("y", 64.0);
        spawnMap.put("z", 0.0);
        spawnMap.put("yaw", Float.valueOf(0.0f));
        spawnMap.put("pitch", Float.valueOf(0.0f));
        this.config.put("spawn", spawnMap);
        this.saveConfig();
    }

    public void saveConfig() {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.configFile));){
            this.gson.toJson(this.config, (Appendable)writer);
            writer.flush();
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Could not save config file: " + e.getMessage());
        }
    }

    public Location getSpawnLocation() {
        Map spawnMap = (Map)this.config.get("spawn");
        if (spawnMap != null) {
            World world = Bukkit.getWorld((String)((String)spawnMap.get("world")));
            double x = ((Number)spawnMap.get("x")).doubleValue();
            double y = ((Number)spawnMap.get("y")).doubleValue();
            double z = ((Number)spawnMap.get("z")).doubleValue();
            float yaw = ((Number)spawnMap.get("yaw")).floatValue();
            float pitch = ((Number)spawnMap.get("pitch")).floatValue();
            return new Location(world, x, y, z, yaw, pitch);
        }
        return ((World)this.plugin.getServer().getWorlds().get(0)).getSpawnLocation();
    }

    public boolean getTpOnRevive() {
        return (Boolean)this.config.getOrDefault("tpOnRevive", true);
    }

    private void ensurePluginFolder() {
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getLogger().info("Creating plugin folder: " + this.plugin.getDataFolder().getPath());
            if (this.plugin.getDataFolder().mkdirs()) {
                this.plugin.getLogger().info("Plugin folder created successfully.");
            } else {
                this.plugin.getLogger().warning("Failed to create plugin folder.");
            }
        }
    }

    public Set<String> getKeys() {
        return this.config.keySet();
    }

    public boolean hasKey(String key) {
        return this.config.containsKey(key);
    }

    public Object get(String key) {
        return this.config.get(key);
    }

    public void set(String key, Object value) {
        this.config.put(key, value);
        this.saveConfig();
    }

    private void loadKits() {
        if (this.kitsYamlFile.exists()) {
            try {
                this.kitsYaml = YamlConfiguration.loadConfiguration((File)this.kitsYamlFile);
                this.plugin.getLogger().info("Loaded YAML kits from kits.yml");
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Could not load YAML kits file: " + e.getMessage());
                this.kitsYaml = new YamlConfiguration();
            }
        } else {
            this.kitsYaml = new YamlConfiguration();
        }
        if (this.kitsFile.exists()) {
            try (FileReader reader = new FileReader(this.kitsFile);){
                this.kits = (Map)this.gson.fromJson((Reader)reader, new TypeToken<Map<String, List<Map<String, Object>>>>(){}.getType());
                if (this.kits != null) {
                    this.plugin.getLogger().info("Loaded legacy JSON kits from kits.json");
                }
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Could not load legacy kits file: " + e.getMessage());
                this.kits = new HashMap<String, List<Map<String, Object>>>();
            }
        } else {
            this.kits = new HashMap<String, List<Map<String, Object>>>();
        }
    }

    private void saveKitsYaml() {
        try {
            this.kitsYaml.save(this.kitsYamlFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Could not save YAML kits file: " + e.getMessage());
        }
    }

    private void saveKits() {
        try (FileWriter writer = new FileWriter(this.kitsFile);){
            this.gson.toJson(this.kits, (Appendable)writer);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Could not save legacy kits file: " + e.getMessage());
        }
    }

    public void saveKit(String kitName, List<ItemStack> items) {
        try {
            HashMap<CallSite, Map> kitData = new HashMap<CallSite, Map>();
            for (int i = 0; i < items.size(); ++i) {
                ItemStack item = items.get(i);
                if (item == null) continue;
                kitData.put((CallSite)((Object)("slot" + i)), item.serialize());
            }
            this.kitsYaml.set("kits." + kitName, kitData);
            this.saveKitsYaml();
            this.plugin.getLogger().info("Saved kit '" + kitName + "' in YAML format");
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error saving kit " + kitName + " in YAML format: " + e.getMessage());
            this.saveKitLegacy(kitName, items);
        }
    }

    private void saveKitLegacy(String kitName, List<ItemStack> items) {
        ArrayList<Map<String, Object>> serializedItems = new ArrayList<Map<String, Object>>();
        for (ItemStack item : items) {
            try {
                if (item != null) {
                    Map<String, Object> serializedItem = this.serializeItemStack(item);
                    serializedItems.add(serializedItem);
                    continue;
                }
                serializedItems.add(null);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error serializing item in kit " + kitName + ": " + e.getMessage());
                serializedItems.add(null);
            }
        }
        this.kits.put(this.encodeString(kitName), serializedItems);
        this.saveKits();
    }

    public List<ItemStack> getKit(String kitName) {
        List<Map<String, Object>> serializedItems;
        if (this.kitsYaml.contains("kits." + kitName)) {
            try {
                Map kitData = this.kitsYaml.getConfigurationSection("kits." + kitName).getValues(false);
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                for (int i = 0; i < 41; ++i) {
                    items.add(null);
                }
                for (Map.Entry entry : kitData.entrySet()) {
                    if (!((String)entry.getKey()).startsWith("slot")) continue;
                    try {
                        String slotStr = ((String)entry.getKey()).substring(4);
                        int slot = Integer.parseInt(slotStr);
                        if (slot < 0 || slot >= 41) continue;
                        Map itemData = (Map)entry.getValue();
                        ItemStack item = ItemStack.deserialize((Map)itemData);
                        items.set(slot, item);
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().warning("Error deserializing item in slot " + (String)entry.getKey() + " for kit " + kitName + ": " + e.getMessage());
                    }
                }
                return items;
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error loading kit " + kitName + " from YAML: " + e.getMessage());
            }
        }
        if ((serializedItems = this.kits.get(this.encodeString(kitName))) == null) {
            return null;
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (Map<String, Object> serializedItem : serializedItems) {
            if (serializedItem != null) {
                try {
                    items.add(this.deserializeItemStack(serializedItem));
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Error deserializing item in kit " + kitName + ": " + e.getMessage());
                    items.add(null);
                }
                continue;
            }
            items.add(null);
        }
        return items;
    }

    public void deleteKit(String kitName) {
        if (this.kitsYaml.contains("kits." + kitName)) {
            this.kitsYaml.set("kits." + kitName, null);
            this.saveKitsYaml();
            this.plugin.getLogger().info("Deleted kit '" + kitName + "' from YAML format");
            return;
        }
        this.kits.remove(this.encodeString(kitName));
        this.saveKits();
    }

    public Set<String> getKitNames() {
        HashSet<String> kitNames = new HashSet<String>();
        if (this.kitsYaml.contains("kits")) {
            try {
                for (String key : this.kitsYaml.getConfigurationSection("kits").getKeys(false)) {
                    kitNames.add(key);
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error getting kit names from YAML: " + e.getMessage());
            }
        }
        Set<String> encodedNames = this.kits.keySet();
        for (String encodedName : encodedNames) {
            kitNames.add(this.decodeString(encodedName));
        }
        return kitNames;
    }

    private String encodeString(String input) {
        return Base64.getEncoder().encodeToString(input.getBytes(StandardCharsets.UTF_16));
    }

    private String decodeString(String input) {
        return new String(Base64.getDecoder().decode(input), StandardCharsets.UTF_16);
    }

    private Map<String, Object> serializeItemStack(ItemStack item) {
        HashMap<String, Object> serialized = new HashMap<String, Object>();
        serialized.put("type", item.getType().name());
        serialized.put("amount", item.getAmount());
        serialized.put("durability", item.getDurability());
        if (item.hasItemMeta()) {
            BannerMeta bannerMeta;
            SkullMeta skullMeta;
            LeatherArmorMeta leatherMeta;
            ItemMeta meta = item.getItemMeta();
            HashMap<String, Object> metaData = new HashMap<String, Object>();
            if (meta.hasDisplayName()) {
                metaData.put("displayName", meta.getDisplayName());
            }
            if (meta.hasLore()) {
                metaData.put("lore", meta.getLore());
            }
            if (meta.hasEnchants()) {
                HashMap enchants = new HashMap();
                for (Map.Entry entry : meta.getEnchants().entrySet()) {
                    enchants.put(((Enchantment)entry.getKey()).getName(), entry.getValue());
                }
                metaData.put("enchants", enchants);
            }
            if (meta instanceof LeatherArmorMeta && (leatherMeta = (LeatherArmorMeta)meta).getColor() != null) {
                HashMap<String, Integer> color = new HashMap<String, Integer>();
                color.put("red", leatherMeta.getColor().getRed());
                color.put("green", leatherMeta.getColor().getGreen());
                color.put("blue", leatherMeta.getColor().getBlue());
                metaData.put("leatherColor", color);
            }
            if (meta instanceof PotionMeta) {
                PotionMeta potionMeta = (PotionMeta)meta;
                PotionData basePotionData = potionMeta.getBasePotionData();
                if (basePotionData != null) {
                    HashMap<String, Object> potionInfo = new HashMap<String, Object>();
                    potionInfo.put("type", basePotionData.getType().name());
                    potionInfo.put("extended", basePotionData.isExtended());
                    potionInfo.put("upgraded", basePotionData.isUpgraded());
                    metaData.put("potionData", potionInfo);
                }
                if (potionMeta.hasCustomEffects()) {
                    ArrayList<PotionEffect> customEffects = new ArrayList<PotionEffect>();
                    for (PotionEffect effect : potionMeta.getCustomEffects()) {
                        customEffects.add(effect);
                    }
                    metaData.put("customEffects", customEffects);
                }
                if (potionMeta.hasColor()) {
                    Color color = potionMeta.getColor();
                    HashMap<String, Integer> colorData = new HashMap<String, Integer>();
                    colorData.put("red", color.getRed());
                    colorData.put("green", color.getGreen());
                    colorData.put("blue", color.getBlue());
                    metaData.put("potionColor", colorData);
                }
            }
            if (meta instanceof BookMeta) {
                BookMeta bookMeta = (BookMeta)meta;
                if (bookMeta.hasTitle()) {
                    metaData.put("bookTitle", bookMeta.getTitle());
                }
                if (bookMeta.hasAuthor()) {
                    metaData.put("bookAuthor", bookMeta.getAuthor());
                }
                if (bookMeta.hasPages()) {
                    metaData.put("bookPages", bookMeta.getPages());
                }
                metaData.put("bookGeneration", bookMeta.getGeneration() != null ? bookMeta.getGeneration().name() : null);
            }
            if (meta instanceof SkullMeta && (skullMeta = (SkullMeta)meta).hasOwner()) {
                metaData.put("skullOwner", skullMeta.getOwner());
            }
            if (meta instanceof BannerMeta && (bannerMeta = (BannerMeta)meta).getPatterns() != null && !bannerMeta.getPatterns().isEmpty()) {
                ArrayList patterns = new ArrayList();
                for (Pattern pattern : bannerMeta.getPatterns()) {
                    HashMap<String, String> patternData = new HashMap<String, String>();
                    patternData.put("type", pattern.getPattern().name());
                    patternData.put("color", pattern.getColor().name());
                    patterns.add(patternData);
                }
                metaData.put("bannerPatterns", patterns);
            }
            if (meta instanceof FireworkMeta) {
                FireworkMeta fireworkMeta = (FireworkMeta)meta;
                if (fireworkMeta.hasEffects()) {
                    ArrayList effects = new ArrayList();
                    for (FireworkEffect effect : fireworkMeta.getEffects()) {
                        HashMap<String, Object> effectData = new HashMap<String, Object>();
                        effectData.put("type", effect.getType().name());
                        effectData.put("flicker", effect.hasFlicker());
                        effectData.put("trail", effect.hasTrail());
                        ArrayList<CallSite> colors = new ArrayList<CallSite>();
                        for (Color color : effect.getColors()) {
                            colors.add((CallSite)((Object)("" + color.asRGB())));
                        }
                        effectData.put("colors", colors);
                        ArrayList<CallSite> fadeColors = new ArrayList<CallSite>();
                        for (Color color : effect.getFadeColors()) {
                            fadeColors.add((CallSite)((Object)("" + color.asRGB())));
                        }
                        effectData.put("fadeColors", fadeColors);
                        effects.add(effectData);
                    }
                    metaData.put("fireworkEffects", effects);
                }
                metaData.put("fireworkPower", fireworkMeta.getPower());
            }
            if (meta instanceof CompassMeta) {
                CompassMeta compassMeta = (CompassMeta)meta;
                if (compassMeta.hasLodestone()) {
                    HashMap<String, Object> lodestoneData = new HashMap<String, Object>();
                    lodestoneData.put("world", compassMeta.getLodestone().getWorld().getName());
                    lodestoneData.put("x", compassMeta.getLodestone().getX());
                    lodestoneData.put("y", compassMeta.getLodestone().getY());
                    lodestoneData.put("z", compassMeta.getLodestone().getZ());
                    metaData.put("lodestone", lodestoneData);
                }
                metaData.put("tracking", compassMeta.isLodestoneTracked());
            }
            if (meta instanceof MapMeta) {
                MapMeta mapMeta = (MapMeta)meta;
                if (mapMeta.hasMapId()) {
                    metaData.put("mapId", mapMeta.getMapId());
                }
                if (mapMeta.hasLocationName()) {
                    metaData.put("locationName", mapMeta.getLocationName());
                }
                metaData.put("scaling", mapMeta.isScaling());
            }
            if (meta.hasCustomModelData()) {
                metaData.put("customModelData", meta.getCustomModelData());
            }
            if (meta.isUnbreakable()) {
                metaData.put("unbreakable", true);
            }
            if (meta.getItemFlags() != null && !meta.getItemFlags().isEmpty()) {
                ArrayList<String> hideFlags = new ArrayList<String>();
                for (ItemFlag flag : meta.getItemFlags()) {
                    hideFlags.add(flag.name());
                }
                metaData.put("hideFlags", hideFlags);
            }
            serialized.put("meta", metaData);
        }
        return serialized;
    }

    private ItemStack deserializeItemStack(Map<String, Object> serialized) {
        String typeName = (String)serialized.get("type");
        int amount = ((Number)serialized.get("amount")).intValue();
        short durability = ((Number)serialized.get("durability")).shortValue();
        ItemStack item = new ItemStack(Material.valueOf((String)typeName), amount);
        item.setDurability(durability);
        if (serialized.containsKey("meta")) {
            Map metaData = (Map)serialized.get("meta");
            ItemMeta meta = item.getItemMeta();
            if (metaData.containsKey("displayName")) {
                meta.setDisplayName((String)metaData.get("displayName"));
            }
            if (metaData.containsKey("lore")) {
                List lore = (List)metaData.get("lore");
                meta.setLore(lore);
            }
            if (metaData.containsKey("enchants")) {
                Map enchants = (Map)metaData.get("enchants");
                for (Map.Entry entry : enchants.entrySet()) {
                    Enchantment enchant = Enchantment.getByName((String)((String)entry.getKey()));
                    if (enchant == null) continue;
                    int level = entry.getValue() instanceof Integer ? (Integer)entry.getValue() : (entry.getValue() instanceof Double ? ((Double)entry.getValue()).intValue() : ((Number)entry.getValue()).intValue());
                    meta.addEnchant(enchant, level, true);
                }
            }
            if (metaData.containsKey("leatherColor") && meta instanceof LeatherArmorMeta) {
                Map colorData = (Map)metaData.get("leatherColor");
                LeatherArmorMeta leatherMeta = (LeatherArmorMeta)meta;
                Color color = Color.fromRGB((int)((Integer)colorData.get("red")), (int)((Integer)colorData.get("green")), (int)((Integer)colorData.get("blue")));
                leatherMeta.setColor(color);
                meta = leatherMeta;
            }
            if (metaData.containsKey("customEffects") && meta instanceof PotionMeta) {
                PotionMeta potionMeta = (PotionMeta)meta;
                if (metaData.containsKey("potionData")) {
                    Map potionData = (Map)metaData.get("potionData");
                    try {
                        String potionTypeName = (String)potionData.get("type");
                        boolean extended = (Boolean)potionData.get("extended");
                        boolean upgraded = (Boolean)potionData.get("upgraded");
                        PotionType potionType = PotionType.valueOf((String)potionTypeName);
                        PotionData basePotionData = new PotionData(potionType, extended, upgraded);
                        potionMeta.setBasePotionData(basePotionData);
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().warning("Could not restore potion base data: " + e.getMessage());
                    }
                }
                List customEffects = (List)metaData.get("customEffects");
                Iterator e = customEffects.iterator();
                while (e.hasNext()) {
                    PotionEffect effect = (PotionEffect)e.next();
                    potionMeta.addCustomEffect(effect, true);
                }
                if (metaData.containsKey("potionColor")) {
                    Map colorData = (Map)metaData.get("potionColor");
                    Color color = Color.fromRGB((int)((Integer)colorData.get("red")), (int)((Integer)colorData.get("green")), (int)((Integer)colorData.get("blue")));
                    potionMeta.setColor(color);
                }
                meta = potionMeta;
            }
            if (metaData.containsKey("customModelData")) {
                meta.setCustomModelData(Integer.valueOf(((Number)metaData.get("customModelData")).intValue()));
            }
            if (metaData.containsKey("unbreakable") && ((Boolean)metaData.get("unbreakable")).booleanValue()) {
                meta.setUnbreakable(true);
            }
            if (metaData.containsKey("hideFlags")) {
                List hideFlags = (List)metaData.get("hideFlags");
                for (Iterator flagName : hideFlags) {
                    try {
                        ItemFlag flag = ItemFlag.valueOf((String)((Object)flagName));
                        meta.addItemFlags(new ItemFlag[]{flag});
                    }
                    catch (IllegalArgumentException flag) {}
                }
            }
            if (metaData.containsKey("bookTitle") && meta instanceof BookMeta) {
                BookMeta bookMeta = (BookMeta)meta;
                bookMeta.setTitle((String)metaData.get("bookTitle"));
                if (metaData.containsKey("bookAuthor")) {
                    bookMeta.setAuthor((String)metaData.get("bookAuthor"));
                }
                if (metaData.containsKey("bookPages")) {
                    List pages = (List)metaData.get("bookPages");
                    bookMeta.setPages(pages);
                }
                if (metaData.containsKey("bookGeneration") && metaData.get("bookGeneration") != null) {
                    bookMeta.setGeneration(BookMeta.Generation.valueOf((String)((String)metaData.get("bookGeneration"))));
                }
                meta = bookMeta;
            }
            if (metaData.containsKey("skullOwner") && meta instanceof SkullMeta) {
                SkullMeta skullMeta = (SkullMeta)meta;
                skullMeta.setOwner((String)metaData.get("skullOwner"));
                meta = skullMeta;
            }
            if (metaData.containsKey("bannerPatterns") && meta instanceof BannerMeta) {
                BannerMeta bannerMeta = (BannerMeta)meta;
                List patterns = (List)metaData.get("bannerPatterns");
                for (Map patternData : patterns) {
                    PatternType type = PatternType.valueOf((String)((String)patternData.get("type")));
                    DyeColor color = DyeColor.valueOf((String)((String)patternData.get("color")));
                    bannerMeta.addPattern(new Pattern(color, type));
                }
                meta = bannerMeta;
            }
            if (metaData.containsKey("fireworkEffects") && meta instanceof FireworkMeta) {
                FireworkMeta fireworkMeta = (FireworkMeta)meta;
                List effects = (List)metaData.get("fireworkEffects");
                for (Map effectData : effects) {
                    FireworkEffect.Type type = FireworkEffect.Type.valueOf((String)((String)effectData.get("type")));
                    boolean flicker = (Boolean)effectData.get("flicker");
                    boolean trail = (Boolean)effectData.get("trail");
                    List colorStrings = (List)effectData.get("colors");
                    ArrayList<Color> colors = new ArrayList<Color>();
                    for (String colorStr : colorStrings) {
                        colors.add(Color.fromRGB((int)Integer.parseInt(colorStr)));
                    }
                    List fadeColorStrings = (List)effectData.get("fadeColors");
                    ArrayList<Color> fadeColors = new ArrayList<Color>();
                    for (String colorStr : fadeColorStrings) {
                        fadeColors.add(Color.fromRGB((int)Integer.parseInt(colorStr)));
                    }
                    fireworkMeta.addEffect(FireworkEffect.builder().with(type).flicker(flicker).trail(trail).withColor(colors).withFade(fadeColors).build());
                }
                if (metaData.containsKey("fireworkPower")) {
                    fireworkMeta.setPower(((Number)metaData.get("fireworkPower")).intValue());
                }
                meta = fireworkMeta;
            }
            if (metaData.containsKey("lodestone") && meta instanceof CompassMeta) {
                CompassMeta compassMeta = (CompassMeta)meta;
                Map lodestoneData = (Map)metaData.get("lodestone");
                String worldName = (String)lodestoneData.get("world");
                double x = ((Number)lodestoneData.get("x")).doubleValue();
                double y = ((Number)lodestoneData.get("y")).doubleValue();
                double z = ((Number)lodestoneData.get("z")).doubleValue();
                World world = Bukkit.getWorld((String)worldName);
                if (world != null) {
                    compassMeta.setLodestone(new Location(world, x, y, z));
                }
                if (metaData.containsKey("tracking")) {
                    compassMeta.setLodestoneTracked(((Boolean)metaData.get("tracking")).booleanValue());
                }
                meta = compassMeta;
            }
            if (metaData.containsKey("mapId") && meta instanceof MapMeta) {
                MapMeta mapMeta = (MapMeta)meta;
                int mapId = ((Number)metaData.get("mapId")).intValue();
                mapMeta.setMapId(mapId);
                if (metaData.containsKey("locationName")) {
                    mapMeta.setLocationName((String)metaData.get("locationName"));
                }
                if (metaData.containsKey("scaling")) {
                    mapMeta.setScaling(((Boolean)metaData.get("scaling")).booleanValue());
                }
                meta = mapMeta;
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    public void saveWarps() {
        try (FileWriter writer = new FileWriter(this.warpsFile);){
            this.gson.toJson(this.warps, (Appendable)writer);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Could not save warps file: " + e.getMessage());
        }
    }

    public void addWarp(String name, Location location) {
        HashMap<String, Object> warpMap = new HashMap<String, Object>();
        warpMap.put("world", location.getWorld().getName());
        warpMap.put("x", location.getX());
        warpMap.put("y", location.getY());
        warpMap.put("z", location.getZ());
        warpMap.put("yaw", Float.valueOf(location.getYaw()));
        warpMap.put("pitch", Float.valueOf(location.getPitch()));
        this.warps.put(name, warpMap);
        this.saveWarps();
    }

    public void removeWarp(String name) {
        this.warps.remove(name);
        this.saveWarps();
    }

    public Location getWarp(String name) {
        Map<String, Object> warpMap = this.warps.get(name);
        if (warpMap != null) {
            World world = Bukkit.getWorld((String)((String)warpMap.get("world")));
            double x = ((Number)warpMap.get("x")).doubleValue();
            double y = ((Number)warpMap.get("y")).doubleValue();
            double z = ((Number)warpMap.get("z")).doubleValue();
            float yaw = ((Number)warpMap.get("yaw")).floatValue();
            float pitch = ((Number)warpMap.get("pitch")).floatValue();
            return new Location(world, x, y, z, yaw, pitch);
        }
        return null;
    }

    public Set<String> getWarpNames() {
        return this.warps.keySet();
    }

    public String getServerName() {
        return (String)this.config.getOrDefault("server", "My Server");
    }

    public String getEventName() {
        return (String)this.config.getOrDefault("event", "Event");
    }

    public boolean getTpOnUnrevive() {
        return (Boolean)this.config.getOrDefault("tpOnUnrevive", true);
    }

    public boolean getMsgsOnVanish() {
        return (Boolean)this.config.getOrDefault("joinLeaveMsgsOnVanish", true);
    }

    public boolean getTpOnDeath() {
        return (Boolean)this.config.getOrDefault("tpOnDeath", true);
    }

    public boolean getTpOnJoin() {
        return (Boolean)this.config.getOrDefault("tpOnJoin", true);
    }

    public boolean getScoreBoard() {
        return (Boolean)this.config.getOrDefault("doScoreboard", true);
    }

    public boolean getTabList() {
        return (Boolean)this.config.getOrDefault("doTabList", true);
    }

    public boolean getChatFormatting() {
        return (Boolean)this.config.getOrDefault("doChat", true);
    }

    public String getFont() {
        return (String)this.config.getOrDefault("font", "modern");
    }

    public String getConfigSound() {
        return (String)this.config.getOrDefault("soundEffect", "BLOCK_NOTE_BLOCK_PLING");
    }

    public double getSoundVolume() {
        return (Double)this.config.getOrDefault("soundVolume", 100);
    }

    public double getSoundPitch() {
        return (Double)this.config.getOrDefault("soundPitch", 1);
    }

    public boolean playSounds() {
        return (Boolean)this.config.getOrDefault("sound", true);
    }

    public boolean isReviveTokensEnabled() {
        return (Boolean)this.config.getOrDefault("reviveTokensEnabled", true);
    }

    public String getDiscordLink() {
        return (String)this.config.getOrDefault("discord", "https://discord.gg/Vp6Q4FHCzf");
    }

    public boolean getChat() {
        return (Boolean)this.config.getOrDefault("chat", true);
    }

    public boolean getColoredChat() {
        return (Boolean)this.config.getOrDefault("coloredChat", true);
    }

    public boolean getAllowRejoining() {
        return (Boolean)this.config.getOrDefault("allowRejoining", true);
    }

    public int getRejoinTime() {
        return ((Number)this.config.getOrDefault("rejoinTime", 30)).intValue();
    }

    public boolean getClearOnJoin() {
        return (Boolean)this.config.getOrDefault("clearOnJoin", false);
    }

    public boolean getClearOnTp() {
        return (Boolean)this.config.getOrDefault("clearOnTp", false);
    }
}

