/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.util;

import app.qwertz.qwertzcore.QWERTZcore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class EventManager {
    private final QWERTZcore plugin;
    private final Set<UUID> deadPlayers;
    private final Set<UUID> alivePlayers;
    private final Map<UUID, Long> deathTimes;

    public EventManager(QWERTZcore plugin) {
        this.plugin = plugin;
        this.deadPlayers = new HashSet<UUID>();
        this.initDead();
        this.alivePlayers = new HashSet<UUID>();
        this.deathTimes = new HashMap<UUID, Long>();
    }

    private void initDead() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.deadPlayers.add(player.getUniqueId());
        }
    }

    public boolean revivePlayer(Player target, Player executor) {
        UUID targetUUID = target.getUniqueId();
        if (this.deadPlayers.remove(targetUUID)) {
            this.alivePlayers.add(targetUUID);
            if (this.plugin.getConfigManager().getTpOnRevive()) {
                target.teleport(executor.getLocation());
            }
            this.deathTimes.remove(targetUUID);
            HashMap<String, String> localMap = new HashMap<String, String>();
            localMap.put("%name%", target.getName());
            localMap.put("%player%", executor.getName());
            this.broadcastMessage("event.revive", localMap);
            return true;
        }
        if (!this.deadPlayers.contains(targetUUID) && !this.alivePlayers.contains(targetUUID)) {
            this.alivePlayers.add(targetUUID);
            if (this.plugin.getConfigManager().getTpOnRevive()) {
                target.teleport(executor.getLocation());
            }
            this.deathTimes.remove(targetUUID);
            HashMap<String, String> localMap = new HashMap<String, String>();
            localMap.put("%name%", target.getName());
            localMap.put("%player%", executor.getName());
            this.broadcastMessage("event.revive", localMap);
            return true;
        }
        return false;
    }

    public boolean unrevivePlayer(Player target, Player executor) {
        UUID targetUUID = target.getUniqueId();
        if (this.alivePlayers.remove(targetUUID)) {
            this.deadPlayers.add(targetUUID);
            if (this.plugin.getConfigManager().getTpOnUnrevive()) {
                target.teleport(this.plugin.getConfigManager().getSpawnLocation());
            }
            HashMap<String, String> localMap = new HashMap<String, String>();
            localMap.put("%name%", target.getName());
            localMap.put("%player%", executor.getName());
            this.broadcastMessage("event.unrevive", localMap);
            return true;
        }
        return false;
    }

    public int getAliveCount() {
        return this.alivePlayers.size();
    }

    public int getDeadCount() {
        return this.deadPlayers.size();
    }

    public void handlePlayerDeath(Player player, boolean noTp) {
        UUID playerUUID = player.getUniqueId();
        if (this.alivePlayers.remove(playerUUID)) {
            this.deathTimes.put(playerUUID, System.currentTimeMillis());
            this.deadPlayers.add(playerUUID);
            HashMap<String, String> localMap = new HashMap<String, String>();
            localMap.put("%name%", player.getName());
            this.broadcastMessage("chatting.death", localMap);
        } else if (!this.deadPlayers.contains(playerUUID)) {
            this.deadPlayers.add(playerUUID);
        }
        if (this.plugin.getConfigManager().getTpOnDeath() && !noTp) {
            player.teleport(this.plugin.getConfigManager().getSpawnLocation());
        }
    }

    public void reviveAll(Player sender) {
        HashSet<UUID> toRemove = new HashSet<UUID>();
        for (UUID uuid : this.deadPlayers) {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (!((Boolean)this.plugin.getConfigManager().get("reviveStaff")).booleanValue() && player.hasPermission("qwertzcore.staff")) continue;
            if (this.plugin.getConfigManager().getTpOnRevive()) {
                player.teleport(sender.getLocation());
            }
            toRemove.add(uuid);
            this.alivePlayers.add(uuid);
        }
        for (UUID uuid : toRemove) {
            this.deadPlayers.remove(uuid);
        }
    }

    public void unReviveAll() {
        for (UUID uuid : this.alivePlayers) {
            if (this.plugin.getConfigManager().getTpOnUnrevive()) {
                Player player = Bukkit.getPlayer((UUID)uuid);
                player.teleport(this.plugin.getConfigManager().getSpawnLocation());
            }
            this.deadPlayers.add(uuid);
        }
        this.alivePlayers.clear();
    }

    public boolean isPlayerDead(Player player) {
        return this.deadPlayers.contains(player.getUniqueId());
    }

    public boolean isPlayerAlive(Player player) {
        return this.alivePlayers.contains(player.getUniqueId());
    }

    public Set<UUID> getDeadPlayers() {
        return new HashSet<UUID>(this.deadPlayers);
    }

    public Set<UUID> getAlivePlayers() {
        return new HashSet<UUID>(this.alivePlayers);
    }

    public Integer getAlivePlayerCountWithoutVanish() {
        Integer counter = 0;
        for (UUID uuid : this.alivePlayers) {
            if (this.plugin.getVanishManager().getVanishedPlayers().contains(uuid)) continue;
            Integer n = counter;
            counter = counter + 1;
        }
        return counter;
    }

    public Integer getDeadPlayerCountWithoutVanish() {
        Integer counter = 0;
        for (UUID uuid : this.deadPlayers) {
            if (this.plugin.getVanishManager().getVanishedPlayers().contains(uuid)) continue;
            Integer n = counter;
            counter = counter + 1;
        }
        return counter;
    }

    public void addNewPlayer(Player player) {
        this.deadPlayers.add(player.getUniqueId());
    }

    public void removePlayer(Player player) {
        UUID playerUUID = player.getUniqueId();
        this.deadPlayers.remove(playerUUID);
        this.alivePlayers.remove(playerUUID);
    }

    public List<Player> getRecentlyDeadPlayers(int seconds) {
        long currentTime = System.currentTimeMillis();
        long timeThreshold = currentTime - (long)seconds * 1000L;
        ArrayList<Player> recentlyDead = new ArrayList<Player>();
        for (Map.Entry<UUID, Long> entry : this.deathTimes.entrySet()) {
            Player player;
            if (entry.getValue() < timeThreshold || (player = this.plugin.getServer().getPlayer(entry.getKey())) == null) continue;
            recentlyDead.add(player);
        }
        return recentlyDead;
    }

    private void broadcastMessage(String message, HashMap<String, String> localMap) {
        this.plugin.getMessageManager().broadcastMessage(message, localMap);
        this.plugin.getSoundManager().broadcastConfigSound();
    }
}

