/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.util;

import app.qwertz.qwertzcore.QWERTZcore;
import java.util.Set;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.cacheddata.CachedMetaData;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.node.types.WeightNode;
import nl.svenar.powerranks.api.PowerRanksAPI;
import nl.svenar.powerranks.common.structure.PRPlayerRank;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class RankManager {
    private final QWERTZcore plugin;
    private LuckPerms luckPerms;
    private PowerRanksAPI powerRanksAPI;
    private boolean usingLuckPerms;
    private boolean usingPowerRanks;

    public RankManager(QWERTZcore plugin) {
        this.plugin = plugin;
        this.usingLuckPerms = this.setupLuckPerms();
        this.usingPowerRanks = this.setupPowerRanks();
    }

    private boolean setupLuckPerms() {
        RegisteredServiceProvider provider;
        if (this.plugin.getServer().getPluginManager().getPlugin("LuckPerms") != null && (provider = this.plugin.getServer().getServicesManager().getRegistration(LuckPerms.class)) != null) {
            this.luckPerms = (LuckPerms)provider.getProvider();
            return true;
        }
        return false;
    }

    private boolean setupPowerRanks() {
        if (this.plugin.getServer().getPluginManager().getPlugin("PowerRanks") != null) {
            this.powerRanksAPI = new PowerRanksAPI();
            return true;
        }
        return false;
    }

    public String getRank(Player player) {
        Set playerRanks;
        if (this.usingLuckPerms) {
            User user = this.luckPerms.getUserManager().getUser(player.getUniqueId());
            if (user != null) {
                return user.getPrimaryGroup();
            }
        } else if (this.usingPowerRanks && !(playerRanks = this.powerRanksAPI.getPlayersAPI().getRanks(player.getUniqueId())).isEmpty()) {
            PRPlayerRank primaryRank = (PRPlayerRank)playerRanks.iterator().next();
            return primaryRank.getName();
        }
        return "default";
    }

    public String getTag(Player player) {
        Set playerRanks;
        if (this.usingLuckPerms) {
            User user = this.luckPerms.getUserManager().getUser(player.getUniqueId());
            if (user != null) {
                String tag = user.getCachedData().getMetaData().getMetaValue("tag");
                return tag != null ? tag : "";
            }
        } else if (this.usingPowerRanks && !(playerRanks = this.powerRanksAPI.getPlayersAPI().getRanks(player.getUniqueId())).isEmpty()) {
            PRPlayerRank primaryRank = (PRPlayerRank)playerRanks.iterator().next();
            return this.powerRanksAPI.getRanksAPI().getPrefix(primaryRank.getName());
        }
        return "";
    }

    public String getPrefix(Player player) {
        Set playerRanks;
        if (this.usingLuckPerms) {
            String prefix;
            User user = this.luckPerms.getUserManager().getUser(player.getUniqueId());
            if (user != null && (prefix = user.getCachedData().getMetaData().getPrefix()) != null) {
                return ChatColor.translateAlternateColorCodes((char)'&', (String)prefix);
            }
        } else if (this.usingPowerRanks && !(playerRanks = this.powerRanksAPI.getPlayersAPI().getRanks(player.getUniqueId())).isEmpty()) {
            PRPlayerRank primaryRank = (PRPlayerRank)playerRanks.iterator().next();
            String prefix = this.powerRanksAPI.getRanksAPI().getPrefix(primaryRank.getName());
            if (prefix != null && !prefix.isEmpty()) {
                return ChatColor.translateAlternateColorCodes((char)'&', (String)prefix);
            }
        }
        if (player.isOp()) {
            return "\u00a76[\u00a76\u00a7lHOST\u00a76] ";
        }
        return "\u00a7a[PLAYER] ";
    }

    public String getSuffix(Player player) {
        Set playerRanks;
        if (this.usingLuckPerms) {
            String suffix;
            User user = this.luckPerms.getUserManager().getUser(player.getUniqueId());
            if (user != null && (suffix = user.getCachedData().getMetaData().getSuffix()) != null) {
                return ChatColor.translateAlternateColorCodes((char)'&', (String)suffix);
            }
        } else if (this.usingPowerRanks && !(playerRanks = this.powerRanksAPI.getPlayersAPI().getRanks(player.getUniqueId())).isEmpty()) {
            PRPlayerRank primaryRank = (PRPlayerRank)playerRanks.iterator().next();
            String suffix = this.powerRanksAPI.getRanksAPI().getSuffix(primaryRank.getName());
            if (suffix != null && !suffix.isEmpty()) {
                return ChatColor.translateAlternateColorCodes((char)'&', (String)suffix);
            }
        }
        return "";
    }

    public int getWeight(Player player) {
        CachedMetaData metaData;
        User user;
        if (this.usingLuckPerms && (user = this.luckPerms.getUserManager().getUser(player.getUniqueId())) != null && (metaData = user.getCachedData().getMetaData()) != null) {
            return user.getNodes(NodeType.WEIGHT).stream().mapToInt(WeightNode::getWeight).max().orElse(0);
        }
        if (player.isOp()) {
            return 100;
        }
        return 0;
    }

    public boolean isUsingLuckPerms() {
        return this.usingLuckPerms;
    }

    public boolean isUsingPowerRanks() {
        return this.usingPowerRanks;
    }
}

