/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.util;

import app.qwertz.qwertzcore.QWERTZcore;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class ScoreboardManager {
    private final QWERTZcore plugin;
    private final Map<UUID, Scoreboard> playerScoreboards;
    public String eventcountdown;
    private FileConfiguration fileScoreboardConfig;
    private FileConfiguration scoreboardConfig;
    private FileConfiguration internalScoreboardConfig;
    private File scoreboardFile;
    private int scoreboardTaskID = -1;

    public ScoreboardManager(QWERTZcore plugin) {
        this.plugin = plugin;
        this.playerScoreboards = new HashMap<UUID, Scoreboard>();
        this.eventcountdown = "...";
        this.loadScoreboardConfig();
        this.scoreboardConfig = this.getConfigToUse();
        this.startScoreboardUpdater();
        this.initialScoreboards();
    }

    private FileConfiguration getConfigToUse() {
        String activeTheme = this.plugin.getMessageManager().messagesConfig.getString("active-theme");
        if (Objects.equals(activeTheme, "file")) {
            return this.fileScoreboardConfig;
        }
        if (Objects.equals(activeTheme, "internal")) {
            return this.internalScoreboardConfig;
        }
        FileConfiguration repoConfig = this.plugin.getMessageManager().loadFromRepo(activeTheme, "scoreboard");
        if (repoConfig != null) {
            return repoConfig;
        }
        this.plugin.getLogger().warning("Failed to load theme from repo, using internal.");
        return this.internalScoreboardConfig;
    }

    private void loadScoreboardConfig() {
        this.scoreboardFile = new File(this.plugin.getDataFolder(), "scoreboard.yml");
        if (!this.scoreboardFile.exists()) {
            this.plugin.saveResource("scoreboard.yml", false);
        }
        this.fileScoreboardConfig = YamlConfiguration.loadConfiguration((File)this.scoreboardFile);
        InputStream defaultStream = this.plugin.getResource("scoreboard.yml");
        if (defaultStream != null) {
            this.internalScoreboardConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultStream));
        }
    }

    public void setScoreboard(Player player) {
        if (this.plugin.getConfigManager().getScoreBoard()) {
            Scoreboard board = Bukkit.getScoreboardManager().getNewScoreboard();
            String title = this.scoreboardConfig.getString("title", "&e" + this.plugin.getConfigManager().getServerName());
            title = title.replace("%event%", this.plugin.getConfigManager().getEventName()).replace("%alive%", String.valueOf(this.plugin.getEventManager().getAlivePlayerCountWithoutVanish())).replace("%dead%", String.valueOf(this.plugin.getEventManager().getDeadPlayerCountWithoutVanish())).replace("%countdown%", this.eventcountdown).replace("%player%", player.getName()).replace("%server%", this.plugin.getConfigManager().getServerName()).replace("%rank%", this.plugin.getRankManager().getRank(player)).replace("%wins%", String.valueOf(this.plugin.getDatabaseManager().getWins(player.getUniqueId()))).replace("%tokens%", String.valueOf(this.plugin.getDatabaseManager().getReviveTokens(player.getUniqueId())));
            title = this.plugin.getMessageManager().prepareMessage(title, new HashMap<String, String>());
            Objective obj = board.registerNewObjective("qwertzcore", "dummy", QWERTZcore.translateHexColorCodes(ChatColor.translateAlternateColorCodes((char)'&', (String)title)));
            obj.setDisplaySlot(DisplaySlot.SIDEBAR);
            this.updateScoreboard(player, board, obj);
            player.setScoreboard(board);
            this.playerScoreboards.put(player.getUniqueId(), board);
        }
    }

    private void updateScoreboard(Player player, Scoreboard board, Objective obj) {
        board.getEntries().forEach(arg_0 -> ((Scoreboard)board).resetScores(arg_0));
        Map lines = this.scoreboardConfig.getConfigurationSection("lines").getValues(false);
        for (Map.Entry entry : lines.entrySet()) {
            try {
                int lineNumber = Integer.parseInt((String)entry.getKey());
                String lineValue = (String)entry.getValue();
                if (lineValue == null || lineValue.isEmpty()) continue;
                String formattedLine = lineValue.replace("%event%", this.plugin.getConfigManager().getEventName()).replace("%alive%", String.valueOf(this.plugin.getEventManager().getAlivePlayerCountWithoutVanish())).replace("%dead%", String.valueOf(this.plugin.getEventManager().getDeadPlayerCountWithoutVanish())).replace("%countdown%", this.eventcountdown).replace("%player%", player.getName()).replace("%server%", this.plugin.getConfigManager().getServerName()).replace("%rank%", this.plugin.getRankManager().getRank(player)).replace("%wins%", String.valueOf(this.plugin.getDatabaseManager().getWins(player.getUniqueId()))).replace("%tokens%", String.valueOf(this.plugin.getDatabaseManager().getReviveTokens(player.getUniqueId())));
                formattedLine = this.plugin.getMessageManager().prepareMessage(formattedLine, new HashMap<String, String>());
                String processedLine = this.processHexColorsForScoreboard(board, formattedLine, lineNumber);
                obj.getScore(processedLine).setScore(lineNumber);
            }
            catch (NumberFormatException e) {
                this.plugin.getLogger().warning("Invalid line number in scoreboard.yml: " + (String)entry.getKey());
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error processing scoreboard line: " + (String)entry.getKey() + " - " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private void startScoreboardUpdater() {
        this.stopScoreboardUpdater();
        this.scoreboardTaskID = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                Scoreboard board = this.playerScoreboards.get(player.getUniqueId());
                if (board == null) continue;
                this.updateScoreboard(player, board, board.getObjective("qwertzcore"));
            }
        }, 20L, 100L).getTaskId();
    }

    public void stopScoreboardUpdater() {
        if (this.scoreboardTaskID != -1) {
            Bukkit.getScheduler().cancelTask(this.scoreboardTaskID);
            this.scoreboardTaskID = -1;
        }
    }

    public int getScoreboardTaskID() {
        return this.scoreboardTaskID;
    }

    public void updateCountdown(String timeLeft) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            Scoreboard board = player.getScoreboard();
            Objective obj = board.getObjective("qwertzcore");
            this.eventcountdown = timeLeft;
            this.updateScoreboard(player, board, obj);
        }
    }

    public void removeScoreboard(Player player) {
        this.playerScoreboards.remove(player.getUniqueId());
    }

    public void removeScoreboardFromAllPlayers() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.playerScoreboards.remove(player.getUniqueId());
            player.setScoreboard(Objects.requireNonNull(Bukkit.getScoreboardManager()).getNewScoreboard());
        }
    }

    private void initialScoreboards() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.setScoreboard(player);
        }
    }

    private String processHexColorsForScoreboard(Scoreboard board, String line, int lineNumber) {
        String processedLine = ChatColor.translateAlternateColorCodes((char)'&', (String)line);
        if (processedLine.contains("\u00a7x")) {
            String teamName = "line_" + lineNumber;
            Team team = board.getTeam(teamName);
            if (team == null) {
                team = board.registerNewTeam(teamName);
            }
            String entryName = String.valueOf(ChatColor.values()[lineNumber % ChatColor.values().length]) + String.valueOf(ChatColor.RESET);
            team.setPrefix(processedLine);
            team.addEntry(entryName);
            return entryName;
        }
        return processedLine;
    }
}

