/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.blocks;

import app.qwertz.qwertzcore.blocks.DamageBlock;
import app.qwertz.qwertzcore.blocks.GravityFlipBlock;
import app.qwertz.qwertzcore.blocks.InstantDeathBlock;
import app.qwertz.qwertzcore.blocks.QWERTZcoreBlock;
import app.qwertz.qwertzcore.blocks.RandomDropBlock;
import org.bukkit.Material;

public enum QWERTZcoreBlockType {
    DAMAGE_BLOCK("DAMAGE_BLOCK", Material.RED_WOOL),
    INSTANT_DEATH_BLOCK("INSTANT_DEATH_BLOCK", Material.REDSTONE_BLOCK),
    RANDOM_DROP_BLOCK("RANDOM_DROP_BLOCK", Material.GRASS_BLOCK),
    GRAVITY_FLIP_BLOCK("GRAVITY_FLIP_BLOCK", Material.END_STONE);

    private final String name;
    private final Material defaultMaterial;

    private QWERTZcoreBlockType(String name, Material defaultMaterial) {
        this.name = name;
        this.defaultMaterial = defaultMaterial;
    }

    public static QWERTZcoreBlockType fromBlock(QWERTZcoreBlock block) {
        if (block instanceof DamageBlock) {
            return DAMAGE_BLOCK;
        }
        if (block instanceof InstantDeathBlock) {
            return INSTANT_DEATH_BLOCK;
        }
        if (block instanceof RandomDropBlock) {
            return RANDOM_DROP_BLOCK;
        }
        if (block instanceof GravityFlipBlock) {
            return GRAVITY_FLIP_BLOCK;
        }
        throw new IllegalArgumentException("Unknown block type: " + block.getClass().getSimpleName());
    }

    public String getName() {
        return this.name;
    }

    public Material getDefaultMaterial() {
        return this.defaultMaterial;
    }
}

