/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.blocks;

import app.qwertz.qwertzcore.blocks.QWERTZcoreBlock;
import app.qwertz.qwertzcore.blocks.QWERTZcoreBlockType;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class RandomDropBlock
extends QWERTZcoreBlock {
    private static final List<Material> VALID_MATERIALS;
    private static final Random RANDOM;

    public RandomDropBlock(Material material) {
        super(material != null ? material : QWERTZcoreBlockType.RANDOM_DROP_BLOCK.getDefaultMaterial());
    }

    @Override
    public void onTouch(Player player, Block block) {
    }

    @Override
    public void onMine(Player player, Block block) {
        if (!VALID_MATERIALS.isEmpty()) {
            Material randomMaterial = VALID_MATERIALS.get(RANDOM.nextInt(VALID_MATERIALS.size()));
            ItemStack randomItem = new ItemStack(randomMaterial);
            block.getWorld().dropItemNaturally(block.getLocation(), randomItem);
        }
    }

    static {
        RANDOM = new Random();
        VALID_MATERIALS = Arrays.stream(Material.values()).filter(Material::isItem).collect(Collectors.toList());
    }
}

