/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.commands;

import app.qwertz.qwertzcore.QWERTZcore;
import app.qwertz.qwertzcore.gui.ConfigGUI;
import java.util.Arrays;
import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ConfigCommand
implements CommandExecutor {
    private final QWERTZcore plugin;

    public ConfigCommand(QWERTZcore plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            if (!(sender instanceof Player)) {
                this.plugin.getMessageManager().sendMessage(sender, "general.only-player-execute");
                return true;
            }
            Player player = (Player)sender;
            new ConfigGUI(this.plugin, player, 0).open();
            return true;
        }
        if (args.length < 2) {
            this.plugin.getMessageManager().sendInvalidUsage(sender, "/config <key> <value>");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return true;
        }
        String key = args[0];
        String value = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
        if (!this.plugin.getConfigManager().hasKey(key) && !key.equals("spawn")) {
            HashMap<String, String> localMap = new HashMap<String, String>();
            localMap.put("%key%", key);
            this.plugin.getMessageManager().sendMessage(sender, "config.key-not-found", localMap);
            this.plugin.getSoundManager().playSoundToSender(sender);
            return true;
        }
        if (key.equals("spawn")) {
            if (!(sender instanceof Player)) {
                this.plugin.getMessageManager().sendMessage(sender, "general.only-player-execute");
                return true;
            }
            if (value.equalsIgnoreCase("currentpos")) {
                Player player = (Player)sender;
                Location loc = player.getLocation();
                HashMap<String, Object> spawnMap = new HashMap<String, Object>();
                spawnMap.put("world", loc.getWorld().getName());
                spawnMap.put("x", loc.getX());
                spawnMap.put("y", loc.getY());
                spawnMap.put("z", loc.getZ());
                spawnMap.put("yaw", Double.valueOf(loc.getYaw()));
                spawnMap.put("pitch", Double.valueOf(loc.getPitch()));
                this.plugin.getConfigManager().set("spawn", spawnMap);
                this.plugin.getMessageManager().sendMessage(sender, "config.set-spawn");
                this.plugin.getSoundManager().playSoundToSender(sender);
            } else {
                this.plugin.getMessageManager().sendMessage(sender, "config.invalid-spawn");
            }
        } else {
            Object currentValue = this.plugin.getConfigManager().get(key);
            HashMap<String, String> localMap = new HashMap<String, String>();
            localMap.put("%key%", key);
            if (currentValue instanceof Boolean) {
                boolean boolValue = Boolean.parseBoolean(value);
                this.plugin.getConfigManager().set(key, boolValue);
                localMap.put("%value%", String.valueOf(boolValue));
                this.plugin.getMessageManager().sendMessage(sender, "config.set-key", localMap);
                this.plugin.getSoundManager().playSoundToSender(sender);
            } else if (currentValue instanceof String) {
                this.plugin.getConfigManager().set(key, value);
                localMap.put("%value%", value);
                this.plugin.getMessageManager().sendMessage(sender, "config.set-key", localMap);
                this.plugin.getSoundManager().playSoundToSender(sender);
            } else if (currentValue instanceof Number) {
                try {
                    if (value.contains(".")) {
                        double doubleValue = Double.parseDouble(value);
                        this.plugin.getConfigManager().set(key, doubleValue);
                        localMap.put("%value%", String.valueOf(doubleValue));
                        this.plugin.getMessageManager().sendMessage(sender, "config.set-key", localMap);
                        this.plugin.getSoundManager().playSoundToSender(sender);
                    }
                    int intValue = Integer.parseInt(value);
                    this.plugin.getConfigManager().set(key, intValue);
                    localMap.put("%value%", String.valueOf(intValue));
                    this.plugin.getMessageManager().sendMessage(sender, "config.set-key", localMap);
                    this.plugin.getSoundManager().playSoundToSender(sender);
                }
                catch (NumberFormatException e) {
                    HashMap<String, String> localMap2 = new HashMap<String, String>();
                    localMap2.put("%value%", value);
                    this.plugin.getMessageManager().sendMessage(sender, "config.invalid-number-format", localMap2);
                    this.plugin.getSoundManager().playSoundToSender(sender);
                    return true;
                }
            } else {
                HashMap<String, String> localMap3 = new HashMap<String, String>();
                localMap3.put("%key%", key);
                this.plugin.getMessageManager().sendMessage(sender, "config.invalid-type", localMap3);
                this.plugin.getSoundManager().playSoundToSender(sender);
                return true;
            }
        }
        this.plugin.getConfigManager().saveConfig();
        return true;
    }
}

