/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.commands;

import app.qwertz.qwertzcore.QWERTZcore;
import java.util.HashMap;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class DiscordCommand
implements CommandExecutor {
    private final QWERTZcore plugin;

    public DiscordCommand(QWERTZcore plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String discordLink = this.plugin.getConfigManager().getDiscordLink();
        if (discordLink == null || discordLink.isEmpty()) {
            this.plugin.getMessageManager().sendMessage(sender, "discord.no-discord");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return true;
        }
        TextComponent message = new TextComponent();
        TextComponent iconComponent = new TextComponent("\u2747");
        iconComponent.setColor(ChatColor.of((String)"#FF6700"));
        message.addExtra((BaseComponent)iconComponent);
        message.addExtra((BaseComponent)new TextComponent(" "));
        TextComponent clickHere = new TextComponent(this.plugin.getMessageManager().prepareMessage(this.plugin.getMessageManager().getMessage("discord.clickhere"), new HashMap<String, String>()));
        String[] parts = discordLink.split(" ");
        StringBuilder messageBuilder = new StringBuilder();
        String link = parts[parts.length - 1];
        if (!link.startsWith("http://") && !link.startsWith("https://")) {
            this.plugin.getMessageManager().sendMessage(sender, "discord.invalid-url");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return true;
        }
        clickHere.setColor(ChatColor.AQUA);
        clickHere.setBold(Boolean.valueOf(true));
        clickHere.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, link));
        clickHere.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(this.plugin.getMessageManager().prepareMessage(this.plugin.getMessageManager().getMessage("discord.hover"), new HashMap<String, String>())).create()));
        message.addExtra((BaseComponent)clickHere);
        if (sender instanceof Player) {
            ((Player)sender).spigot().sendMessage((BaseComponent)message);
            this.plugin.getSoundManager().playSound((Player)sender);
        } else {
            sender.sendMessage(String.valueOf(ChatColor.AQUA) + "Discord link: " + discordLink);
            this.plugin.getSoundManager().playSoundToSender(sender);
        }
        return true;
    }
}

