/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.commands;

import app.qwertz.qwertzcore.QWERTZcore;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class EventCommands
implements CommandExecutor {
    private final QWERTZcore plugin;

    public EventCommands(QWERTZcore plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        switch (command.getName().toLowerCase()) {
            case "revive": {
                return this.handleRevive(sender, args);
            }
            case "unrevive": {
                return this.handleUnrevive(sender, args);
            }
            case "reviveall": {
                return this.handleReviveAll(sender);
            }
            case "unreviveall": {
                return this.handleUnReviveAll(sender);
            }
            case "listalive": {
                return this.handleListAlive(sender);
            }
            case "listdead": {
                return this.handleListDead(sender);
            }
            case "givedead": {
                return this.handleGive(sender, args, true);
            }
            case "givealive": {
                return this.handleGive(sender, args, false);
            }
            case "tpalive": {
                return this.handleTeleport(sender, false, true);
            }
            case "tpdead": {
                return this.handleTeleport(sender, true, true);
            }
            case "tpall": {
                return this.handleTeleport(sender, true, false);
            }
            case "tphere": {
                return this.handleTpHere(sender, args);
            }
            case "revivelast": {
                return this.handleReviveLast(sender, args);
            }
            case "healalive": {
                return this.handleHeal(sender, true, args);
            }
            case "healdead": {
                return this.handleHeal(sender, false, args);
            }
        }
        return false;
    }

    private boolean handleRevive(CommandSender sender, String[] args) {
        if (args.length != 1) {
            this.plugin.getMessageManager().sendInvalidUsage(sender, "/revive <player>");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return false;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            this.plugin.getMessageManager().sendMessage(sender, "general.player-not-found");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return false;
        }
        if (!this.plugin.getEventManager().revivePlayer(target, (Player)sender)) {
            HashMap<String, String> localMap = new HashMap<String, String>();
            localMap.put("%player%", target.getName());
            this.plugin.getMessageManager().sendMessage(sender, "event.alreadyalive", localMap);
            this.plugin.getSoundManager().playSoundToSender(sender);
        }
        return true;
    }

    private boolean handleUnrevive(CommandSender sender, String[] args) {
        if (args.length != 1) {
            this.plugin.getMessageManager().sendInvalidUsage(sender, "/unrevive <player>");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return false;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            this.plugin.getMessageManager().sendMessage(sender, "general.player-not-found");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return false;
        }
        if (!this.plugin.getEventManager().unrevivePlayer(target, (Player)sender)) {
            HashMap<String, String> localMap = new HashMap<String, String>();
            localMap.put("%player%", target.getName());
            this.plugin.getMessageManager().sendMessage(sender, "event.alreadydead", localMap);
            this.plugin.getSoundManager().playSoundToSender(sender);
        }
        return true;
    }

    private boolean handleReviveAll(CommandSender sender) {
        this.plugin.getEventManager().reviveAll((Player)sender);
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%player%", sender.getName());
        this.plugin.getMessageManager().broadcastMessage("event.revivedall", localMap);
        this.plugin.getSoundManager().broadcastConfigSound();
        return true;
    }

    private boolean handleUnReviveAll(CommandSender sender) {
        this.plugin.getEventManager().unReviveAll();
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%player%", sender.getName());
        this.plugin.getMessageManager().broadcastMessage("event.unrevivedall", localMap);
        this.plugin.getSoundManager().broadcastConfigSound();
        return true;
    }

    private boolean handleListAlive(CommandSender sender) {
        String aliveList = this.plugin.getEventManager().getAlivePlayers().stream().map(Bukkit::getPlayer).filter(player -> player != null).map(Player::getName).collect(Collectors.joining(", "));
        if (aliveList.isEmpty()) {
            this.plugin.getMessageManager().sendMessage(sender, "event.noalive");
            this.plugin.getSoundManager().playSoundToSender(sender);
        } else {
            HashMap<String, String> localMap = new HashMap<String, String>();
            localMap.put("%list%", aliveList);
            this.plugin.getMessageManager().sendMessage(sender, "event.listalive", localMap);
            this.plugin.getSoundManager().playSoundToSender(sender);
        }
        return true;
    }

    private boolean handleListDead(CommandSender sender) {
        String deadList = this.plugin.getEventManager().getDeadPlayers().stream().map(Bukkit::getPlayer).filter(player -> player != null).map(Player::getName).collect(Collectors.joining(", "));
        if (deadList.isEmpty()) {
            this.plugin.getMessageManager().sendMessage(sender, "event.nodead");
            this.plugin.getSoundManager().playSoundToSender(sender);
        } else {
            HashMap<String, String> localMap = new HashMap<String, String>();
            localMap.put("%list%", deadList);
            this.plugin.getMessageManager().sendMessage(sender, "event.listdead", localMap);
            this.plugin.getSoundManager().playSoundToSender(sender);
        }
        return true;
    }

    private boolean handleGive(CommandSender sender, String[] args, boolean isDead) {
        if (args.length < 1 || args.length > 3) {
            this.plugin.getMessageManager().sendInvalidUsage(sender, "/" + (isDead ? "givedead" : "givealive") + " <item> [amount] [data]");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return false;
        }
        Material material = Material.matchMaterial((String)args[0]);
        if (material == null) {
            HashMap<String, String> localMap = new HashMap<String, String>();
            localMap.put("%item%", args[0]);
            this.plugin.getMessageManager().sendMessage(sender, "event.invalid-item", localMap);
            this.plugin.getSoundManager().playSoundToSender(sender);
            return false;
        }
        int amount = 1;
        if (args.length >= 2) {
            try {
                amount = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                HashMap<String, String> localMap = new HashMap<String, String>();
                localMap.put("%amount%", args[1]);
                this.plugin.getMessageManager().sendMessage(sender, "event.invalid-amount", localMap);
                this.plugin.getSoundManager().playSoundToSender(sender);
                return false;
            }
        }
        short data = 0;
        if (args.length == 3) {
            try {
                data = Short.parseShort(args[2]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage("\u00a7cInvalid data value: " + args[2]);
                this.plugin.getSoundManager().playSoundToSender(sender);
                return false;
            }
        }
        ItemStack itemStack = new ItemStack(material, amount, data);
        int playersAffected = 0;
        for (Player player : Bukkit.getOnlinePlayers()) {
            if ((!isDead || !this.plugin.getEventManager().isPlayerDead(player)) && (isDead || !this.plugin.getEventManager().isPlayerAlive(player))) continue;
            player.getInventory().addItem(new ItemStack[]{itemStack.clone()});
            ++playersAffected;
        }
        String playerType = isDead ? "dead" : "alive";
        String playerTypeColor = isDead ? "%colorDead%" : "%colorAlive%";
        String itemName = itemStack.getType().toString().toLowerCase().replace("_", " ");
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%affected%", String.valueOf(playersAffected));
        localMap.put("%type%", playerType);
        localMap.put("%typeColor%", playerTypeColor);
        localMap.put("%amount%", String.valueOf(amount));
        localMap.put("%item%", itemName);
        this.plugin.getMessageManager().broadcastMessage("event.give-broadcast", localMap);
        this.plugin.getSoundManager().broadcastConfigSound();
        return true;
    }

    private boolean handleTeleport(CommandSender sender, boolean isDead, boolean filter) {
        if (!(sender instanceof Player)) {
            this.plugin.getMessageManager().sendMessage(sender, "general.only-player-execute");
            return true;
        }
        Player executor = (Player)sender;
        int teleportedCount = 0;
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (player == executor) continue;
            if (filter) {
                if ((!isDead || !this.plugin.getEventManager().isPlayerDead(player)) && (isDead || !this.plugin.getEventManager().isPlayerAlive(player))) continue;
                player.teleport(executor.getLocation());
                ++teleportedCount;
                continue;
            }
            player.teleport(executor.getLocation());
            ++teleportedCount;
        }
        String playerType = isDead ? "dead" : "alive";
        String playerTypeColor = isDead ? "%colorDead%" : "%colorAlive%";
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%name%", executor.getName());
        if (filter) {
            localMap.put("%typeColor%", playerTypeColor);
            localMap.put("%type%", playerType);
            this.plugin.getMessageManager().broadcastMessage("event.tp-group", localMap);
        } else {
            this.plugin.getMessageManager().broadcastMessage("event.tpall", localMap);
        }
        this.plugin.getSoundManager().broadcastConfigSound();
        return true;
    }

    private boolean handleTpHere(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            this.plugin.getMessageManager().sendMessage(sender, "general.only-player-execute");
            return true;
        }
        if (args.length != 1) {
            this.plugin.getMessageManager().sendInvalidUsage(sender, "/tphere <player>");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return true;
        }
        Player commandSender = (Player)sender;
        Player targetPlayer = Bukkit.getPlayer((String)args[0]);
        if (targetPlayer == null) {
            this.plugin.getMessageManager().sendMessage(sender, "general.player-not-found");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return true;
        }
        if (targetPlayer == commandSender) {
            this.plugin.getMessageManager().sendMessage(sender, "event.canttptoyourself");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return true;
        }
        targetPlayer.teleport(commandSender.getLocation());
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%name%", targetPlayer.getName());
        HashMap<String, String> localMap2 = new HashMap<String, String>();
        localMap2.put("%name%", commandSender.getName());
        this.plugin.getMessageManager().sendMessage(commandSender, "event.tphere-sender-msg", localMap);
        this.plugin.getSoundManager().playSound(commandSender);
        this.plugin.getMessageManager().sendMessage(targetPlayer, "event.tphere-target-msg", localMap2);
        this.plugin.getSoundManager().playSound(targetPlayer);
        return true;
    }

    private boolean handleReviveLast(CommandSender sender, String[] args) {
        int seconds = 30;
        if (args.length > 0) {
            String timeArg = args[0].toLowerCase();
            seconds = this.parseTimeArgument(timeArg);
            if (seconds == -1) {
                this.plugin.getMessageManager().sendMessage(sender, "event.revivelast.invalid-format");
                this.plugin.getSoundManager().playSoundToSender(sender);
                return true;
            }
            if (seconds <= 0 || seconds > 300) {
                this.plugin.getMessageManager().sendMessage(sender, "event.revivelast.no-number");
                this.plugin.getSoundManager().playSoundToSender(sender);
                return true;
            }
        }
        List<Player> recentlyDeadPlayers = this.plugin.getEventManager().getRecentlyDeadPlayers(seconds);
        int revivedCount = 0;
        for (Player player : recentlyDeadPlayers) {
            this.plugin.getEventManager().revivePlayer(player, (Player)sender);
            ++revivedCount;
        }
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%amount%", String.valueOf(revivedCount));
        localMap.put("%seconds%", String.valueOf(seconds));
        this.plugin.getMessageManager().broadcastMessage("event.revivelast.broadcast", localMap);
        this.plugin.getSoundManager().broadcastConfigSound();
        return true;
    }

    private int parseTimeArgument(String timeArg) {
        if ((timeArg = timeArg.trim()).matches("^\\d+$")) {
            int minutes = Integer.parseInt(timeArg);
            if (minutes < 1 || minutes > 5) {
                return -1;
            }
            return minutes * 60;
        }
        if (timeArg.matches("^\\d+(min|m)$")) {
            int minutes = Integer.parseInt(timeArg.replaceAll("(min|m)", ""));
            if (minutes < 1 || minutes > 5) {
                return -1;
            }
            return minutes * 60;
        }
        if (timeArg.matches("^\\d+(s|sec)$")) {
            int secs = Integer.parseInt(timeArg.replaceAll("(s|sec)", ""));
            if (secs < 1 || secs > 300) {
                return -1;
            }
            return secs;
        }
        return -1;
    }

    public boolean handleHeal(CommandSender sender, Boolean alive, String[] args) {
        boolean healAlive = alive;
        int healedCount = 0;
        for (Player player : Bukkit.getOnlinePlayers()) {
            boolean isDead = this.plugin.getEventManager().isPlayerDead(player);
            if ((!healAlive || isDead) && (healAlive || !isDead)) continue;
            this.healPlayer(player);
            ++healedCount;
        }
        String playerType = healAlive ? "alive" : "dead";
        String playerTypeColor = healAlive ? "%colorAlive%" : "%colorDead%";
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%amount%", String.valueOf(healedCount));
        localMap.put("%type%", playerType);
        localMap.put("%typeColor%", playerTypeColor);
        localMap.put("%name%", sender.getName());
        this.plugin.getMessageManager().broadcastMessage("event.heal-broadcast", localMap);
        this.plugin.getSoundManager().broadcastConfigSound();
        return true;
    }

    private void healPlayer(Player player) {
        double maxHealth = player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue();
        player.setHealth(maxHealth);
        player.setFoodLevel(20);
        player.setSaturation(20.0f);
        player.setFireTicks(0);
        player.getActivePotionEffects().forEach(effect -> player.removePotionEffect(effect.getType()));
    }
}

