/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.commands;

import app.qwertz.qwertzcore.QWERTZcore;
import java.util.HashMap;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class EventCountdownCommand
implements CommandExecutor {
    private final QWERTZcore plugin;
    private BukkitRunnable countdownTask;
    private int remainingSeconds;

    public EventCountdownCommand(QWERTZcore plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length != 1) {
            this.plugin.getMessageManager().sendInvalidUsage(sender, "/eventcountdown <time|cancel>");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return true;
        }
        if (args[0].equalsIgnoreCase("cancel")) {
            this.cancelCountdown();
            this.plugin.getScoreboardManager().updateCountdown("...");
            return true;
        }
        String timeArg = args[0].toLowerCase();
        int minutes = 0;
        int seconds = 0;
        if (timeArg.matches("\\d+s")) {
            seconds = Integer.parseInt(timeArg.substring(0, timeArg.length() - 1));
        } else if (timeArg.matches("\\d+min")) {
            minutes = Integer.parseInt(timeArg.substring(0, timeArg.length() - 3));
        } else if (timeArg.matches("\\d+sec")) {
            seconds = Integer.parseInt(timeArg.substring(0, timeArg.length() - 3));
        } else if (timeArg.matches("\\d+m")) {
            minutes = Integer.parseInt(timeArg.substring(0, timeArg.length() - 1));
        } else if (timeArg.matches("\\d+")) {
            minutes = Integer.parseInt(timeArg);
        } else {
            this.plugin.getMessageManager().sendMessage(sender, "eventcountdown.invalid-time");
            return true;
        }
        this.remainingSeconds = minutes * 60 + seconds;
        if (this.remainingSeconds <= 0 || this.remainingSeconds > 3600) {
            if (this.countdownTask != null) {
                this.countdownTask.cancel();
            }
            this.cancelCountdown();
            this.plugin.getScoreboardManager().updateCountdown("...");
            this.plugin.getMessageManager().sendMessage(sender, "eventcountdown.out-of-range");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return true;
        }
        if (this.countdownTask != null) {
            this.countdownTask.cancel();
        }
        this.startCountdown();
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%time%", this.formatTime(this.remainingSeconds));
        this.plugin.getMessageManager().broadcastMessage("eventcountdown.started-countdown", localMap);
        this.plugin.getSoundManager().playSoundToSender(sender);
        return true;
    }

    private void startCountdown() {
        this.countdownTask = new BukkitRunnable(){

            public void run() {
                if (EventCountdownCommand.this.remainingSeconds <= 0) {
                    HashMap<String, String> localMap = new HashMap<String, String>();
                    localMap.put("%event%", EventCountdownCommand.this.plugin.getConfigManager().getEventName());
                    EventCountdownCommand.this.plugin.getMessageManager().broadcastMessage("eventcountdown.starting-now", localMap);
                    EventCountdownCommand.this.plugin.getSoundManager().broadcastConfigSound();
                    EventCountdownCommand.this.updateScoreboard(0);
                    this.cancel();
                    return;
                }
                if (EventCountdownCommand.this.remainingSeconds <= 10 || EventCountdownCommand.this.remainingSeconds <= 60 && EventCountdownCommand.this.remainingSeconds % 10 == 0 || EventCountdownCommand.this.remainingSeconds % 60 == 0) {
                    EventCountdownCommand.this.broadcastCountdown();
                }
                EventCountdownCommand.this.updateScoreboard(EventCountdownCommand.this.remainingSeconds);
                --EventCountdownCommand.this.remainingSeconds;
            }
        };
        this.countdownTask.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    private void broadcastCountdown() {
        String timeLeft = this.formatTime(this.remainingSeconds);
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%event%", this.plugin.getConfigManager().getEventName());
        localMap.put("%time%", timeLeft);
        this.plugin.getMessageManager().broadcastMessage("eventcountdown.broadcast", localMap);
        this.plugin.getSoundManager().broadcastConfigSound();
    }

    private String formatTime(int seconds) {
        if (seconds >= 60) {
            return seconds / 60 + "min";
        }
        return seconds + "s";
    }

    private void updateScoreboard(int seconds) {
        this.plugin.getScoreboardManager().updateCountdown(this.formatTime(seconds));
    }

    public void cancelCountdown() {
        if (this.countdownTask != null) {
            this.countdownTask.cancel();
            this.countdownTask = null;
        }
        this.updateScoreboard(0);
    }
}

