/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.commands;

import app.qwertz.qwertzcore.QWERTZcore;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MessageCommands
implements CommandExecutor {
    private final QWERTZcore plugin;

    public MessageCommands(QWERTZcore plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            this.plugin.getMessageManager().sendMessage(sender, "general.only-player-execute");
            return true;
        }
        Player player = (Player)sender;
        switch (label.toLowerCase()) {
            case "message": 
            case "msg": 
            case "tell": {
                return this.handleMessageCommand(player, args);
            }
            case "reply": 
            case "r": {
                return this.handleReplyCommand(player, args);
            }
            case "messagetoggle": 
            case "msgtoggle": 
            case "togglemsgs": {
                return this.handleMessageToggleCommand(player);
            }
        }
        return false;
    }

    private boolean handleMessageCommand(Player sender, String[] args) {
        if (args.length < 2) {
            this.plugin.getMessageManager().sendInvalidUsage(sender, "/message <player> <message>");
            this.plugin.getSoundManager().playSound(sender);
            return true;
        }
        Player recipient = Bukkit.getPlayer((String)args[0]);
        if (recipient == null) {
            this.plugin.getMessageManager().sendMessage(sender, "general.player-not-found");
            this.plugin.getSoundManager().playSound(sender);
            return true;
        }
        if (!this.plugin.getMessageManager().canReceiveMessages(recipient)) {
            HashMap<String, String> localMap = new HashMap<String, String>();
            localMap.put("%name%", recipient.getName());
            this.plugin.getMessageManager().sendMessage(sender, "messaging.cannot-message", localMap);
            this.plugin.getSoundManager().playSound(sender);
            return true;
        }
        String message = String.join((CharSequence)" ", args).substring(args[0].length() + 1);
        this.sendPrivateMessage(sender, recipient, message);
        this.plugin.getSoundManager().playSound(sender);
        this.plugin.getSoundManager().playSound(recipient);
        return true;
    }

    private boolean handleReplyCommand(Player sender, String[] args) {
        if (args.length < 1) {
            this.plugin.getMessageManager().sendInvalidUsage(sender, "/reply <message>");
            return true;
        }
        Player recipient = this.plugin.getMessageManager().getReplyTarget(sender);
        if (recipient == null) {
            this.plugin.getMessageManager().sendMessage(sender, "messaging.cannot-reply");
            this.plugin.getSoundManager().playSound(sender);
            return true;
        }
        if (!this.plugin.getMessageManager().canReceiveMessages(recipient)) {
            HashMap<String, String> localMap = new HashMap<String, String>();
            localMap.put("%name%", recipient.getName());
            this.plugin.getMessageManager().sendMessage(sender, "messaging.cannot-message", localMap);
            return true;
        }
        String message = String.join((CharSequence)" ", args);
        this.sendPrivateMessage(sender, recipient, message);
        this.plugin.getSoundManager().playSound(sender);
        this.plugin.getSoundManager().playSound(recipient);
        return true;
    }

    private boolean handleMessageToggleCommand(Player player) {
        this.plugin.getMessageManager().toggleMessages(player);
        boolean enabled = this.plugin.getMessageManager().canReceiveMessages(player);
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%state%", enabled ? "enabled" : "disabled");
        localMap.put("%stateColor%", enabled ? "%colorAlive%" : "%colorDead%");
        this.plugin.getMessageManager().sendMessage(player, "messaging.togglemsg", localMap);
        this.plugin.getSoundManager().playSound(player);
        return true;
    }

    private void sendPrivateMessage(Player sender, Player recipient, String message) {
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%sender%", sender.getName());
        localMap.put("%recipient%", recipient.getName());
        message = this.plugin.getChatManager().translateEmojis(message, sender);
        if (this.plugin.getConfigManager().getColoredChat() && sender.hasPermission("qwertzcore.chat.color")) {
            message = QWERTZcore.translateHexColorCodes(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
        }
        String message2 = this.plugin.getMessageManager().getMessage("messaging.direct-message");
        message2 = this.plugin.getMessageManager().prepareMessage(message2, localMap).replace("%message%", message);
        recipient.sendMessage(message2);
        sender.sendMessage(message2);
        this.plugin.getSoundManager().playSound(sender);
        this.plugin.getSoundManager().playSound(recipient);
        this.plugin.getMessageManager().setReplyTarget(sender, recipient);
    }
}

