/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.commands;

import app.qwertz.qwertzcore.QWERTZcore;
import app.qwertz.qwertzcore.util.ConfigManager;
import java.util.HashMap;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class RejoinCommand
implements CommandExecutor {
    private final QWERTZcore plugin;
    private final ConfigManager configManager;

    public RejoinCommand(QWERTZcore plugin) {
        this.plugin = plugin;
        this.configManager = plugin.getConfigManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (!(sender instanceof Player)) {
            this.plugin.getMessageManager().sendMessage(sender, "general.only-player-execute");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("qwertzcore.admin.rejoin")) {
            this.plugin.getMessageManager().sendMessage(player, "no-permission");
            return true;
        }
        if (args.length == 0) {
            boolean allowRejoining = this.configManager.getAllowRejoining();
            int rejoinTime = this.configManager.getRejoinTime();
            this.plugin.getMessageManager().sendMessage(player, "rejoin.status-title");
            if (allowRejoining) {
                this.plugin.getMessageManager().sendMessage(player, "rejoin.status-enabled");
            } else {
                this.plugin.getMessageManager().sendMessage(player, "rejoin.status-disabled");
            }
            HashMap<String, String> timeMap = new HashMap<String, String>();
            timeMap.put("%time%", String.valueOf(rejoinTime));
            this.plugin.getMessageManager().sendMessage(player, "rejoin.status-time", timeMap);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "enable": {
                this.configManager.set("allowRejoining", true);
                this.plugin.getMessageManager().sendMessage(player, "rejoin.enabled");
                break;
            }
            case "disable": {
                this.configManager.set("allowRejoining", false);
                this.plugin.getMessageManager().sendMessage(player, "rejoin.disabled");
                break;
            }
            case "time": {
                if (args.length < 2) {
                    HashMap<String, String> usageMap = new HashMap<String, String>();
                    usageMap.put("%usage%", "/rejoin time <seconds>");
                    this.plugin.getMessageManager().sendMessage(player, "general.invalid-usage", usageMap);
                    return true;
                }
                try {
                    int newTime = Integer.parseInt(args[1]);
                    if (newTime < 0) {
                        this.plugin.getMessageManager().sendMessage(player, "rejoin.invalid-number");
                        return true;
                    }
                    this.configManager.set("rejoinTime", newTime);
                    HashMap<String, String> timeMap = new HashMap<String, String>();
                    timeMap.put("%time%", String.valueOf(newTime));
                    this.plugin.getMessageManager().sendMessage(player, "rejoin.time-set", timeMap);
                    break;
                }
                catch (NumberFormatException e) {
                    this.plugin.getMessageManager().sendMessage(player, "rejoin.invalid-number");
                    return true;
                }
            }
            default: {
                this.plugin.getMessageManager().sendInvalidUsage(player, "/rejoin [enable|disable|time <seconds>]");
            }
        }
        return true;
    }
}

