/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.commands;

import app.qwertz.qwertzcore.QWERTZcore;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ReviveTokenCommands
implements CommandExecutor {
    private final QWERTZcore plugin;
    private final Map<UUID, Long> pendingReviveRequests = new HashMap<UUID, Long>();

    public ReviveTokenCommands(QWERTZcore plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        switch (label.toLowerCase()) {
            case "userevive": {
                return this.handleUseRevive(sender);
            }
            case "reviveaccept": {
                return this.handleReviveAccept(sender, args);
            }
            case "revivedeny": {
                return this.handleReviveDeny(sender, args);
            }
            case "addrevive": {
                return this.handleAddRevive(sender, args);
            }
            case "removerevive": {
                return this.handleRemoveRevive(sender, args);
            }
            case "revives": {
                return this.handleRevivals(sender, args);
            }
        }
        return false;
    }

    private boolean handleRevivals(CommandSender sender, String[] args) {
        Player target;
        if (args.length == 0 && sender instanceof Player) {
            target = (Player)sender;
        } else if (args.length == 1) {
            target = Bukkit.getPlayer((String)args[0]);
            if (target == null) {
                this.plugin.getMessageManager().sendMessage(sender, "general.player-not-found");
                this.plugin.getSoundManager().playSoundToSender(sender);
                return true;
            }
        } else {
            this.plugin.getMessageManager().sendInvalidUsage(sender, "/revives [player]");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return true;
        }
        int reviveTokens = this.plugin.getDatabaseManager().getReviveTokens(target.getUniqueId());
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%name%", target.getName());
        localMap.put("%tokens%", String.valueOf(reviveTokens));
        this.plugin.getMessageManager().sendMessage(sender, "revivaltokens.showrevives", localMap);
        this.plugin.getSoundManager().playSoundToSender(sender);
        return true;
    }

    private boolean handleUseRevive(CommandSender sender) {
        long cooldownEndTime;
        if (!(sender instanceof Player)) {
            this.plugin.getMessageManager().sendMessage(sender, "general.only-player-execute");
            return true;
        }
        Player player = (Player)sender;
        if (!this.plugin.getConfigManager().isReviveTokensEnabled()) {
            this.plugin.getMessageManager().sendMessage(player, "revivaltokens.tokens-disabled");
            this.plugin.getSoundManager().playSound(player);
            return true;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime < (cooldownEndTime = this.plugin.getDatabaseManager().getReviveRequestCooldown(player.getUniqueId()))) {
            long remainingCooldown = (cooldownEndTime - currentTime) / 1000L;
            HashMap<String, String> localMap = new HashMap<String, String>();
            localMap.put("%time%", String.valueOf(remainingCooldown));
            this.plugin.getMessageManager().sendMessage(player, "revivaltokens.cooldown", localMap);
            this.plugin.getSoundManager().playSound(player);
            return true;
        }
        int tokens = this.plugin.getDatabaseManager().getReviveTokens(player.getUniqueId());
        if (tokens <= 0) {
            this.plugin.getMessageManager().sendMessage(player, "revivaltokens.no-tokens");
            this.plugin.getSoundManager().playSound(player);
            return true;
        }
        if (this.plugin.getEventManager().isPlayerAlive(player)) {
            this.plugin.getMessageManager().sendMessage(player, "revivaltokens.already-alive");
            this.plugin.getSoundManager().playSound(player);
            return true;
        }
        this.pendingReviveRequests.put(player.getUniqueId(), currentTime + 30000L);
        this.plugin.getDatabaseManager().setReviveRequestCooldown(player.getUniqueId(), currentTime + 30000L);
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%name%", player.getName());
        this.plugin.getMessageManager().broadcastMessage("revivaltokens.request-revive", localMap);
        this.plugin.getSoundManager().broadcastConfigSound();
        return true;
    }

    private boolean handleReviveAccept(CommandSender sender, String[] args) {
        if (args.length != 1) {
            this.plugin.getMessageManager().sendInvalidUsage(sender, "/reviveaccept <player>");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            this.plugin.getMessageManager().sendMessage(sender, "general.player-not-found");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return true;
        }
        if (!this.pendingReviveRequests.containsKey(target.getUniqueId()) || this.pendingReviveRequests.get(target.getUniqueId()) < System.currentTimeMillis()) {
            this.plugin.getMessageManager().sendMessage(sender, "revivaltokens.no-pending-request");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return true;
        }
        this.pendingReviveRequests.remove(target.getUniqueId());
        this.plugin.getDatabaseManager().removeReviveToken(target.getUniqueId());
        this.plugin.getEventManager().revivePlayer(target, (Player)sender);
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%name%", target.getName());
        this.plugin.getMessageManager().broadcastMessage("revivaltokens.revive-accepted", localMap);
        this.plugin.getSoundManager().broadcastConfigSound();
        return true;
    }

    private boolean handleReviveDeny(CommandSender sender, String[] args) {
        if (args.length != 1) {
            this.plugin.getMessageManager().sendInvalidUsage(sender, "/revivedeny <player>");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            this.plugin.getMessageManager().sendMessage(sender, "general.player-not-found");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return true;
        }
        this.pendingReviveRequests.remove(target.getUniqueId());
        this.plugin.getDatabaseManager().setReviveRequestCooldown(target.getUniqueId(), System.currentTimeMillis() + 120000L);
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%name%", target.getName());
        this.plugin.getMessageManager().broadcastMessage("revivaltokens.revive-denied", localMap);
        this.plugin.getSoundManager().broadcastConfigSound();
        return true;
    }

    private boolean handleAddRevive(CommandSender sender, String[] args) {
        if (args.length != 1) {
            this.plugin.getMessageManager().sendInvalidUsage(sender, "/addrevive <player>");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            this.plugin.getMessageManager().sendMessage(sender, "general.player-not-found");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return true;
        }
        this.plugin.getDatabaseManager().addReviveToken(target.getUniqueId());
        int tokens = this.plugin.getDatabaseManager().getReviveTokens(target.getUniqueId());
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%name%", target.getName());
        localMap.put("%tokens%", String.valueOf(tokens));
        this.plugin.getMessageManager().broadcastMessage("revivaltokens.token-given", localMap);
        this.plugin.getSoundManager().broadcastConfigSound();
        return true;
    }

    private boolean handleRemoveRevive(CommandSender sender, String[] args) {
        if (args.length != 1) {
            this.plugin.getMessageManager().sendInvalidUsage(sender, "/removerevive <player>");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            this.plugin.getMessageManager().sendMessage(sender, "general.player-not-found");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return true;
        }
        this.plugin.getDatabaseManager().removeReviveToken(target.getUniqueId());
        int tokens = this.plugin.getDatabaseManager().getReviveTokens(target.getUniqueId());
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%name%", target.getName());
        localMap.put("%tokens%", String.valueOf(tokens));
        this.plugin.getMessageManager().broadcastMessage("revivaltokens.token-removed", localMap);
        this.plugin.getSoundManager().broadcastConfigSound();
        return true;
    }
}

