/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.commands;

import app.qwertz.qwertzcore.QWERTZcore;
import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SetterCommands
implements CommandExecutor {
    private final QWERTZcore plugin;

    public SetterCommands(QWERTZcore plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("setspawn")) {
            this.setSpawn(sender);
        } else if (command.getName().equalsIgnoreCase("setserver")) {
            this.setServer(sender, args);
        } else if (command.getName().equalsIgnoreCase("setevent")) {
            this.setEvent(sender, args);
        }
        return true;
    }

    public void setSpawn(CommandSender sender) {
        if (!(sender instanceof Player)) {
            this.plugin.getMessageManager().sendMessage(sender, "general.only-player-execute");
        }
        Player player = (Player)sender;
        Location loc = player.getLocation();
        HashMap<String, Object> spawnMap = new HashMap<String, Object>();
        spawnMap.put("world", loc.getWorld().getName());
        spawnMap.put("x", loc.getX());
        spawnMap.put("y", loc.getY());
        spawnMap.put("z", loc.getZ());
        spawnMap.put("yaw", Double.valueOf(loc.getYaw()));
        spawnMap.put("pitch", Double.valueOf(loc.getPitch()));
        this.plugin.getConfigManager().set("spawn", spawnMap);
        this.plugin.getMessageManager().sendMessage(sender, "config.set-spawn");
        this.plugin.getSoundManager().playSoundToSender(sender);
    }

    public void setServer(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            this.plugin.getMessageManager().sendMessage(sender, "general.only-player-execute");
        }
        if (args.length != 1) {
            this.plugin.getMessageManager().sendInvalidUsage(sender, "/setserver <server>");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return;
        }
        String server = args[0];
        this.plugin.getConfigManager().set("server", server);
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%value%", server);
        localMap.put("%key%", "server");
        this.plugin.getMessageManager().sendMessage(sender, "config.set-key", localMap);
        this.plugin.getSoundManager().playSoundToSender(sender);
    }

    public void setEvent(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            this.plugin.getMessageManager().sendMessage(sender, "general.only-player-execute");
        }
        if (args.length != 1) {
            this.plugin.getMessageManager().sendInvalidUsage(sender, "/setevent <event>");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return;
        }
        String event = args[0];
        this.plugin.getConfigManager().set("event", event);
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%value%", event);
        localMap.put("%key%", "event");
        this.plugin.getMessageManager().sendMessage(sender, "config.set-key", localMap);
        this.plugin.getSoundManager().playSoundToSender(sender);
    }
}

