/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.commands;

import app.qwertz.qwertzcore.QWERTZcore;
import java.util.HashMap;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class TimerCommand
implements CommandExecutor {
    private final QWERTZcore plugin;
    private BukkitTask currentTimer;

    public TimerCommand(QWERTZcore plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length != 1) {
            this.plugin.getMessageManager().sendInvalidUsage(sender, "/timer <seconds> or /timer cancel");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return false;
        }
        if (args[0].equalsIgnoreCase("cancel")) {
            this.cancelTimer();
            this.plugin.getMessageManager().sendMessage(sender, "timer.cancelled");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return true;
        }
        try {
            int seconds = Integer.parseInt(args[0]);
            if (seconds <= 0) {
                this.plugin.getMessageManager().sendMessage(sender, "timer.no-number");
                this.plugin.getSoundManager().playSoundToSender(sender);
                return false;
            }
            this.startTimer(seconds);
            return true;
        }
        catch (NumberFormatException e) {
            this.plugin.getMessageManager().sendMessage(sender, "timer.invalid-number");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return false;
        }
    }

    private void startTimer(final int seconds) {
        this.cancelTimer();
        String startMessage = this.plugin.getMessageManager().prepareMessage(this.plugin.getMessageManager().getMessage("timer.started"), new HashMap<String, String>());
        this.broadcastMessage(startMessage);
        this.broadcastActionBar(startMessage);
        this.currentTimer = new BukkitRunnable(this){
            int timeLeft;
            final /* synthetic */ TimerCommand this$0;
            {
                this.this$0 = this$0;
                this.timeLeft = seconds;
            }

            public void run() {
                if (this.timeLeft <= 0) {
                    String msg = this.this$0.plugin.getMessageManager().prepareMessage(this.this$0.plugin.getMessageManager().getMessage("timer.time-up"), new HashMap<String, String>());
                    this.this$0.broadcastMessage(msg);
                    this.this$0.broadcastActionBar(msg);
                    this.this$0.currentTimer = null;
                    this.cancel();
                    return;
                }
                HashMap<String, String> localMap = new HashMap<String, String>();
                localMap.put("%timeLeft%", String.valueOf(this.timeLeft));
                String message = this.this$0.plugin.getMessageManager().prepareMessage(this.this$0.plugin.getMessageManager().getMessage("timer.countdown"), localMap);
                if (((Boolean)this.this$0.plugin.getConfigManager().get("chatTimer")).booleanValue()) {
                    Bukkit.broadcastMessage((String)message);
                }
                this.this$0.broadcastActionBar(message);
                --this.timeLeft;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    private void cancelTimer() {
        if (this.currentTimer != null) {
            this.currentTimer.cancel();
            this.currentTimer = null;
            this.plugin.getMessageManager().broadcastMessage("timer.broadcast-cancel");
            this.plugin.getSoundManager().broadcastConfigSound();
        }
    }

    private void broadcastMessage(String message) {
        Bukkit.broadcastMessage((String)message);
        this.plugin.getSoundManager().broadcastConfigSound();
    }

    private void broadcastActionBar(String message) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
        }
    }
}

