/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.commands;

import app.qwertz.qwertzcore.QWERTZcore;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class WinCommands
implements CommandExecutor {
    private final QWERTZcore plugin;

    public WinCommands(QWERTZcore plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        switch (label.toLowerCase()) {
            case "addwin": {
                return this.handleAddWin(sender, args);
            }
            case "removewin": {
                return this.handleRemoveWin(sender, args);
            }
            case "wins": {
                return this.handleWins(sender, args);
            }
        }
        return false;
    }

    private boolean handleAddWin(CommandSender sender, String[] args) {
        if (args.length != 1) {
            this.plugin.getMessageManager().sendInvalidUsage(sender, " /addwin <player>");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            this.plugin.getMessageManager().sendMessage(sender, "general.player-not-found");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return true;
        }
        this.plugin.getDatabaseManager().addWin(target.getUniqueId());
        int wins = this.plugin.getDatabaseManager().getWins(target.getUniqueId());
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%wins%", String.valueOf(wins));
        localMap.put("%name%", target.getName());
        HashMap<String, String> localMap2 = new HashMap<String, String>();
        localMap2.put("%wins%", String.valueOf(wins));
        this.plugin.getMessageManager().broadcastMessage("wins.win-broadcast", localMap);
        this.plugin.getMessageManager().sendMessage(target, "wins.give", localMap2);
        this.plugin.getSoundManager().broadcastConfigSound();
        return true;
    }

    private boolean handleRemoveWin(CommandSender sender, String[] args) {
        if (args.length != 1) {
            this.plugin.getMessageManager().sendInvalidUsage(sender, " /removewin <player>");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            this.plugin.getMessageManager().sendMessage(sender, "general.player-not-found");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return true;
        }
        int currentWins = this.plugin.getDatabaseManager().getWins(target.getUniqueId());
        if (currentWins <= 0) {
            HashMap<String, String> localMap = new HashMap<String, String>();
            localMap.put("%name%", target.getName());
            this.plugin.getMessageManager().sendMessage(sender, "wins.no-wins", localMap);
            this.plugin.getSoundManager().playSoundToSender(sender);
            return true;
        }
        this.plugin.getDatabaseManager().removeWin(target.getUniqueId());
        int newWins = this.plugin.getDatabaseManager().getWins(target.getUniqueId());
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%wins%", String.valueOf(newWins));
        localMap.put("%name%", target.getName());
        HashMap<String, String> localMap2 = new HashMap<String, String>();
        localMap2.put("%wins%", String.valueOf(newWins));
        this.plugin.getMessageManager().broadcastMessage("wins.win-removed-broadcast", localMap);
        this.plugin.getMessageManager().sendMessage(target, "wins.remove", localMap2);
        this.plugin.getSoundManager().broadcastConfigSound();
        return true;
    }

    private boolean handleWins(CommandSender sender, String[] args) {
        Player target;
        if (args.length == 0 && sender instanceof Player) {
            target = (Player)sender;
        } else if (args.length == 1) {
            target = Bukkit.getPlayer((String)args[0]);
            if (target == null) {
                this.plugin.getMessageManager().sendMessage(sender, "general.player-not-found");
                this.plugin.getSoundManager().playSoundToSender(sender);
                return true;
            }
        } else {
            this.plugin.getMessageManager().sendInvalidUsage(sender, " /wins [player]");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return true;
        }
        int wins = this.plugin.getDatabaseManager().getWins(target.getUniqueId());
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%wins%", String.valueOf(wins));
        localMap.put("%name%", target.getName());
        this.plugin.getMessageManager().sendMessage(sender, "wins.show-wins", localMap);
        this.plugin.getSoundManager().playSoundToSender(sender);
        return true;
    }
}

