/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.commands;

import app.qwertz.qwertzcore.QWERTZcore;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class WorldGuardCommands
implements CommandExecutor {
    private final QWERTZcore plugin;

    public WorldGuardCommands(QWERTZcore plugin) {
        this.plugin = plugin;
    }

    public boolean enableHighFrequencyFlags() {
        File configFile = new File(WorldGuard.getInstance().getPlatform().getGlobalStateManager().getDataFolder(), "config.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        config.set("regions.high-frequency-flags", (Object)true);
        try {
            config.save(configFile);
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)"wg reload");
            return true;
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("We were unable to enable 'high-frequency-flags' option in the WorldGuard config. /flow will be broken. ");
            return false;
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        boolean currentState;
        String flagName;
        StateFlag flag;
        boolean isGlobal;
        Object region;
        if (!(sender instanceof Player)) {
            this.plugin.getMessageManager().sendMessage(sender, "general.only-player-execute");
            return true;
        }
        Player player = (Player)sender;
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionManager regions = container.get(BukkitAdapter.adapt((World)player.getWorld()));
        if (regions == null) {
            this.plugin.getMessageManager().sendMessage(player, "worldguard.no-regions");
            this.plugin.getSoundManager().playSound(player);
            return true;
        }
        if (args.length > 0) {
            String regionName = args[0];
            region = regions.getRegion(regionName);
            if (region == null) {
                HashMap<String, String> localMap = new HashMap<String, String>();
                localMap.put("%name%", regionName);
                this.plugin.getMessageManager().sendMessage(player, "worldguard.not-found", localMap);
                this.plugin.getSoundManager().playSound(player);
                return true;
            }
            isGlobal = false;
        } else {
            ApplicableRegionSet applicableRegions = regions.getApplicableRegions(BukkitAdapter.asBlockVector((Location)player.getLocation()));
            region = null;
            for (String r : applicableRegions) {
                if (region != null && r.getPriority() <= region.getPriority()) continue;
                region = r;
            }
            boolean bl = isGlobal = region == null;
            if (isGlobal) {
                region = regions.getRegion("__global__");
            }
        }
        switch (command.getName().toLowerCase()) {
            case "flow": 
            case "toggleflow": {
                flag = Flags.WATER_FLOW;
                flagName = this.plugin.getMessageManager().prepareMessage(this.plugin.getMessageManager().getMessage("worldguard.flags.flow"), new HashMap<String, String>());
                break;
            }
            case "pvp": 
            case "togglepvp": {
                flag = Flags.PVP;
                flagName = this.plugin.getMessageManager().prepareMessage(this.plugin.getMessageManager().getMessage("worldguard.flags.pvp"), new HashMap<String, String>());
                break;
            }
            case "break": 
            case "togglebreak": {
                flag = Flags.BLOCK_BREAK;
                flagName = this.plugin.getMessageManager().prepareMessage(this.plugin.getMessageManager().getMessage("worldguard.flags.break"), new HashMap<String, String>());
                break;
            }
            case "place": 
            case "toggleplace": {
                flag = Flags.BLOCK_PLACE;
                flagName = this.plugin.getMessageManager().prepareMessage(this.plugin.getMessageManager().getMessage("worldguard.flags.place"), new HashMap<String, String>());
                break;
            }
            case "falldamage": 
            case "togglefalldamage": {
                flag = Flags.FALL_DAMAGE;
                flagName = this.plugin.getMessageManager().prepareMessage(this.plugin.getMessageManager().getMessage("worldguard.flags.falldamage"), new HashMap<String, String>());
                break;
            }
            case "hunger": 
            case "togglehunger": {
                flag = Flags.HUNGER_DRAIN;
                flagName = this.plugin.getMessageManager().prepareMessage(this.plugin.getMessageManager().getMessage("worldguard.flags.hunger"), new HashMap<String, String>());
                break;
            }
            default: {
                return false;
            }
        }
        if (region == null) {
            this.plugin.getMessageManager().sendMessage(player, "worldguard.invalid-region");
            return true;
        }
        boolean bl = currentState = region.getFlag((Flag)flag) != StateFlag.State.DENY;
        if (!flag.equals(Flags.WATER_FLOW)) {
            region.setFlag((Flag)flag, (Object)(currentState ? StateFlag.State.DENY : StateFlag.State.ALLOW));
        } else {
            StateFlag[] FlowFlags;
            for (StateFlag loop : FlowFlags = new StateFlag[]{Flags.WATER_FLOW, Flags.LAVA_FLOW}) {
                region.setFlag((Flag)loop, (Object)(currentState ? StateFlag.State.DENY : StateFlag.State.ALLOW));
            }
            this.enableHighFrequencyFlags();
        }
        String newState = currentState ? "DISABLED" : "ENABLED";
        String stateColor = currentState ? "%colorDead%" : "%colorAlive%";
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%name%", sender.getName());
        localMap.put("%state%", newState);
        localMap.put("%stateLower%", newState.toLowerCase(Locale.ROOT));
        localMap.put("%stateColor%", stateColor);
        localMap.put("%flag%", flagName);
        if (isGlobal) {
            this.plugin.getMessageManager().broadcastMessage("worldguard.globally", localMap);
        } else {
            localMap.put("%region%", region.getId());
            this.plugin.getMessageManager().broadcastMessage("worldguard.regionally", localMap);
        }
        this.plugin.getSoundManager().broadcastConfigSound();
        return true;
    }
}

