/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.commands.tab;

import app.qwertz.qwertzcore.QWERTZcore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class ConfigTabCompleter
implements TabCompleter {
    private final QWERTZcore plugin;
    private final List<String> fontOptions = Arrays.asList("default", "qwertz", "modern", "blocky");
    private final List<String> booleanOptions = Arrays.asList("true", "false");
    private final List<String> colorList = Arrays.asList("&1", "&2", "&3", "&4", "&5", "&6", "&7", "&8", "&9", "&0", "&a", "&b", "&c", "&d", "&e", "&f", "&k", "&l", "&m", "&n", "&o", "&r");
    private final List<String> pitchOptions = Arrays.asList("0.5", "1.0", "1.5", "2.0");
    private final List<String> volumeOptions = Arrays.asList("50.0", "75.0", "100.0", "125.0", "150.0");

    public ConfigTabCompleter(QWERTZcore plugin) {
        this.plugin = plugin;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> keys = new ArrayList<String>(this.plugin.getConfigManager().getKeys());
            keys.add("spawn");
            return keys.stream().filter(key -> key.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2) {
            String key2 = args[0].toLowerCase();
            if (key2.equals("spawn")) {
                return List.of("currentpos");
            }
            if (key2.equals("font")) {
                return this.fontOptions.stream().filter(font -> font.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
            }
            if (key2.contains("color")) {
                return this.colorList.stream().filter(option -> option.startsWith(args[1].toLowerCase())).collect(Collectors.toList());
            }
            if (key2.equals("soundpitch")) {
                return this.pitchOptions.stream().filter(pitch -> pitch.startsWith(args[1].toLowerCase())).collect(Collectors.toList());
            }
            if (key2.equals("soundvolume")) {
                return this.volumeOptions.stream().filter(volume -> volume.startsWith(args[1].toLowerCase())).collect(Collectors.toList());
            }
            if (key2.equals("soundeffect")) {
                return Arrays.stream(Sound.values()).map(Enum::name).filter(sound -> sound.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
            }
            Object value = this.plugin.getConfigManager().get(key2);
            if (value == null || value instanceof Boolean) {
                return this.booleanOptions.stream().filter(option -> option.startsWith(args[1].toLowerCase())).collect(Collectors.toList());
            }
            return List.of(value.toString());
        }
        return new ArrayList<String>();
    }
}

