/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.util;

import app.qwertz.qwertzcore.QWERTZcore;
import app.qwertz.qwertzcore.blocks.DamageBlock;
import app.qwertz.qwertzcore.blocks.GravityFlipBlock;
import app.qwertz.qwertzcore.blocks.InstantDeathBlock;
import app.qwertz.qwertzcore.blocks.QWERTZcoreBlock;
import app.qwertz.qwertzcore.blocks.QWERTZcoreBlockType;
import app.qwertz.qwertzcore.blocks.RandomDropBlock;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public class BlockManager {
    private final QWERTZcore plugin;
    private final Map<Location, QWERTZcoreBlock> specialBlocks;
    private final Map<String, Class<? extends QWERTZcoreBlock>> blockTypes;

    public BlockManager(QWERTZcore plugin) {
        this.plugin = plugin;
        this.specialBlocks = new HashMap<Location, QWERTZcoreBlock>();
        this.blockTypes = new HashMap<String, Class<? extends QWERTZcoreBlock>>();
        this.registerBlockTypes();
        plugin.getLogger().info("Scheduling task to load special blocks...");
        Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> {
            plugin.getLogger().info("Loading special blocks...");
            int amount = this.loadSpecialBlocks();
            plugin.getLogger().info("Loaded " + amount + " special blocks!");
        }, 20L);
    }

    private void registerBlockTypes() {
        this.blockTypes.put("DAMAGE_BLOCK", DamageBlock.class);
        this.blockTypes.put("INSTANT_DEATH_BLOCK", InstantDeathBlock.class);
        this.blockTypes.put("RANDOM_DROP_BLOCK", RandomDropBlock.class);
        this.blockTypes.put("GRAVITY_FLIP_BLOCK", GravityFlipBlock.class);
    }

    public void setSpecialBlock(Location location, String blockType, Material material) {
        try {
            QWERTZcoreBlockType type = QWERTZcoreBlockType.valueOf(blockType.toUpperCase());
            QWERTZcoreBlock block = this.createBlock(type, material);
            this.specialBlocks.put(location, block);
            this.saveSpecialBlocks();
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid block type: " + blockType);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error setting special block: " + e.getMessage());
        }
    }

    private QWERTZcoreBlock createBlock(QWERTZcoreBlockType type, Material material) {
        switch (type) {
            case DAMAGE_BLOCK: {
                return new DamageBlock(material);
            }
            case INSTANT_DEATH_BLOCK: {
                return new InstantDeathBlock(material);
            }
            case RANDOM_DROP_BLOCK: {
                return new RandomDropBlock(material);
            }
            case GRAVITY_FLIP_BLOCK: {
                return new GravityFlipBlock(material);
            }
        }
        throw new IllegalArgumentException("Unknown block type: " + String.valueOf((Object)type));
    }

    public QWERTZcoreBlock getSpecialBlock(Location location) {
        return this.specialBlocks.get(location);
    }

    public void removeSpecialBlock(Location location) {
        if (this.specialBlocks.remove(location) != null) {
            this.saveSpecialBlocks();
        }
    }

    private int loadSpecialBlocks() {
        int count = 0;
        Map<String, String> savedBlocks = this.plugin.getDatabaseManager().getSpecialBlocks();
        for (Map.Entry<String, String> entry : savedBlocks.entrySet()) {
            String locationString = entry.getKey();
            String blockType = entry.getValue();
            try {
                Location location = this.stringToLocation(locationString);
                if (location == null) {
                    this.plugin.getLogger().warning("Failed to parse location: " + locationString);
                    continue;
                }
                if (blockType == null || blockType.isEmpty()) {
                    this.plugin.getLogger().warning("Invalid block type for location: " + locationString);
                    continue;
                }
                Material material = Material.GRASS_BLOCK;
                this.setSpecialBlock(location, blockType, material);
                ++count;
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid block type '" + blockType + "' for location: " + locationString);
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Error processing special block at " + locationString + ": " + e.getMessage());
            }
        }
        return count;
    }

    public void saveSpecialBlocks() {
        HashMap<String, String> blocksToSave = new HashMap<String, String>();
        for (Map.Entry<Location, QWERTZcoreBlock> entry : this.specialBlocks.entrySet()) {
            QWERTZcoreBlockType blockType = QWERTZcoreBlockType.fromBlock(entry.getValue());
            blocksToSave.put(this.locationToString(entry.getKey()), blockType.name());
        }
        this.plugin.getDatabaseManager().saveSpecialBlocks(blocksToSave);
    }

    private String locationToString(Location location) {
        return Objects.requireNonNull(location.getWorld()).getName() + "," + location.getX() + "," + location.getY() + "," + location.getZ();
    }

    private Location stringToLocation(String str) {
        String[] parts = str.split(",");
        if (parts.length == 4) {
            World world = this.plugin.getServer().getWorld(parts[0]);
            if (world == null) {
                this.plugin.getLogger().warning("World not found: " + parts[0]);
                return null;
            }
            return new Location(world, Double.parseDouble(parts[1]), Double.parseDouble(parts[2]), Double.parseDouble(parts[3]));
        }
        return null;
    }

    public boolean isValidBlockType(String blockType) {
        return this.blockTypes.containsKey(blockType);
    }

    public String[] getAvailableBlockTypes() {
        return this.blockTypes.keySet().toArray(new String[0]);
    }
}

