/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.util;

import app.qwertz.qwertzcore.QWERTZcore;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class MessageManager {
    private final QWERTZcore plugin;
    private final Map<UUID, UUID> lastMessageSender;
    public FileConfiguration messagesConfig;
    private File messagesFile;
    private FileConfiguration defaultMessagesConfig;
    private List<String> themes;
    private FileConfiguration cachedRepoConfig = null;
    private long lastRepoLoadTime = 0L;
    private static final long REPO_LOAD_INTERVAL = 300000L;

    public MessageManager(QWERTZcore plugin) {
        this.plugin = plugin;
        this.lastMessageSender = new HashMap<UUID, UUID>();
        this.themes = new ArrayList<String>();
        this.themes.add("internal");
        this.themes.add("file");
        this.loadMessages();
        this.fetchThemesFromGitHub();
    }

    private void fetchThemesFromGitHub() {
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                String line;
                URL url = new URL("https://api.github.com/repos/QWERTZexe/QWERTZ-Core/contents/themes");
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setRequestProperty("Accept", "application/vnd.github.v3+json");
                if (conn.getResponseCode() != 200) {
                    throw new RuntimeException("HTTP error code: " + conn.getResponseCode());
                }
                BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    response.append(line);
                }
                br.close();
                conn.disconnect();
                Gson gson = new Gson();
                List items = (List)gson.fromJson(response.toString(), new TypeToken<List<Map<String, Object>>>(){}.getType());
                for (Map item : items) {
                    if (!"dir".equals(item.get("type"))) continue;
                    this.themes.add((String)item.get("name"));
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to fetch themes from GitHub: " + e.getMessage());
            }
        });
    }

    public List<String> getThemes() {
        return this.themes;
    }

    public void setTheme(String theme) {
        try {
            this.messagesConfig.set("active-theme", (Object)theme);
            this.messagesConfig.save(this.messagesFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadMessages() {
        this.messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!this.messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        InputStream defaultStream = this.plugin.getResource("messages.yml");
        if (defaultStream != null) {
            this.defaultMessagesConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultStream));
            this.updateMessages();
        } else {
            this.plugin.getLogger().warning("Default messages.yml not found in JAR!");
        }
    }

    private void updateMessages() {
        Set keys = this.defaultMessagesConfig.getKeys(true);
        for (String key : keys) {
            if (this.messagesConfig.contains(key)) continue;
            this.messagesConfig.set(key, this.defaultMessagesConfig.get(key));
            try {
                this.messagesConfig.save(this.messagesFile);
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Unable to save messages.yml!");
            }
        }
    }

    public boolean canReceiveMessages(Player player) {
        return this.plugin.getDatabaseManager().isMessageToggleEnabled(player.getUniqueId());
    }

    public void toggleMessages(Player player) {
        boolean currentState = this.plugin.getDatabaseManager().isMessageToggleEnabled(player.getUniqueId());
        this.plugin.getDatabaseManager().setMessageToggleEnabled(player.getUniqueId(), !currentState);
    }

    public void setReplyTarget(Player sender, Player recipient) {
        this.lastMessageSender.put(recipient.getUniqueId(), sender.getUniqueId());
    }

    public Player getReplyTarget(Player player) {
        UUID lastSenderUUID = this.lastMessageSender.get(player.getUniqueId());
        return lastSenderUUID != null ? this.plugin.getServer().getPlayer(lastSenderUUID) : null;
    }

    public String prepareMessage(String message, HashMap<String, String> localPlaceholders) {
        ConfigurationSection placeholders;
        for (Map.Entry<String, String> entry : localPlaceholders.entrySet()) {
            message = message.replace(entry.getKey(), entry.getValue());
        }
        FileConfiguration config = this.getConfigToUse();
        if (config.contains("placeholders") && (placeholders = config.getConfigurationSection("placeholders")) != null) {
            for (String key : placeholders.getKeys(false)) {
                String placeholder = "%" + key + "%";
                String value = placeholders.getString(key);
                assert (value != null) : "Invalid placeholder";
                message = message.replace(placeholder, value);
            }
        }
        message = message.replace("%colorPrimary%", "\u00a7e");
        message = message.replace("%colorSecondary%", "\u00a76");
        message = message.replace("%colorTertiary%", "\u00a7b");
        message = message.replace("%colorError%", "\u00a7c");
        message = message.replace("%colorSuccess%", "\u00a7a");
        message = message.replace("%colorAlive%", "\u00a7a");
        message = message.replace("%colorDead%", "\u00a7c");
        message = message.replace("%CORE_ICON_RAW%", "\u2747");
        message = message.replace("%CORE_ICON%", QWERTZcore.CORE_ICON);
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        message = QWERTZcore.translateHexColorCodes(message);
        return message;
    }

    public FileConfiguration loadFromRepo(String themeName, String type) {
        YamlConfiguration yamlConfiguration;
        block11: {
            String repoUrl = "https://raw.githubusercontent.com/QWERTZexe/QWERTZ-Core/refs/heads/main/themes/" + themeName + "/" + type + ".yml";
            URL url = new URL(repoUrl);
            URLConnection connection = url.openConnection();
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            InputStream inputStream = connection.getInputStream();
            try {
                yamlConfiguration = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(inputStream));
                if (inputStream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        this.plugin.getLogger().warning("Error reading messages.yml from repo: " + e.getMessage());
                        return null;
                    }
                }
                catch (IOException e) {
                    this.plugin.getLogger().warning("Error connecting to repo: " + e.getMessage());
                    return null;
                }
            }
            inputStream.close();
        }
        return yamlConfiguration;
    }

    private FileConfiguration getConfigToUse() {
        String activeTheme = this.messagesConfig.getString("active-theme");
        if (Objects.equals(activeTheme, "file")) {
            return this.messagesConfig;
        }
        if (Objects.equals(activeTheme, "internal")) {
            return this.defaultMessagesConfig;
        }
        long currentTime = System.currentTimeMillis();
        if (this.cachedRepoConfig == null || currentTime - this.lastRepoLoadTime > 300000L) {
            FileConfiguration repoConfig = this.loadFromRepo(activeTheme, "messages");
            if (repoConfig != null) {
                this.cachedRepoConfig = repoConfig;
                this.lastRepoLoadTime = currentTime;
            } else {
                this.plugin.getLogger().warning("Failed to load theme from repo, using internal.");
                this.cachedRepoConfig = this.defaultMessagesConfig;
            }
        }
        return this.cachedRepoConfig;
    }

    public String getMessage(String path) {
        FileConfiguration config = this.getConfigToUse();
        String message = config.getString(path);
        if (message == null) {
            return QWERTZcore.CORE_ICON + " %colorError%Message not found: " + path;
        }
        return message;
    }

    public void broadcastMessage(String message, HashMap<String, String> localPlaceholders) {
        message = this.getMessage(message);
        message = this.prepareMessage(message, localPlaceholders);
        if (((Boolean)this.plugin.getConfigManager().get("biggerMessages")).booleanValue()) {
            Bukkit.broadcastMessage((String)"");
            Bukkit.broadcastMessage((String)message);
            Bukkit.broadcastMessage((String)"");
        } else {
            Bukkit.broadcastMessage((String)message);
        }
    }

    public void broadcastMessage(String message) {
        message = this.getMessage(message);
        message = this.prepareMessage(message, new HashMap<String, String>());
        if (((Boolean)this.plugin.getConfigManager().get("biggerMessages")).booleanValue()) {
            Bukkit.broadcastMessage((String)"");
            Bukkit.broadcastMessage((String)message);
            Bukkit.broadcastMessage((String)"");
        } else {
            Bukkit.broadcastMessage((String)message);
        }
    }

    public void sendMessage(CommandSender recipent, String message, HashMap<String, String> localPlaceholders) {
        message = this.getMessage(message);
        message = this.prepareMessage(message, localPlaceholders);
        recipent.sendMessage(message);
    }

    public void sendMessage(Player recipent, String message, HashMap<String, String> localPlaceholders) {
        message = this.getMessage(message);
        message = this.prepareMessage(message, localPlaceholders);
        recipent.sendMessage(message);
    }

    public void sendMessage(CommandSender recipent, String message) {
        message = this.getMessage(message);
        message = this.prepareMessage(message, new HashMap<String, String>());
        recipent.sendMessage(message);
    }

    public void sendMessage(Player recipent, String message) {
        message = this.getMessage(message);
        message = this.prepareMessage(message, new HashMap<String, String>());
        recipent.sendMessage(message);
    }

    public void sendInvalidUsage(Player recipent, String usage) {
        String message = "general.invalid-usage";
        message = this.getMessage(message);
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%usage%", usage);
        message = this.prepareMessage(message, localMap);
        recipent.sendMessage(message);
    }

    public void sendInvalidUsage(CommandSender recipent, String usage) {
        String message = "general.invalid-usage";
        message = this.getMessage(message);
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%usage%", usage);
        message = this.prepareMessage(message, localMap);
        recipent.sendMessage(message);
    }

    public List<String> getStringList(String path) {
        FileConfiguration config = this.getConfigToUse();
        return config.getStringList(path);
    }
}

