/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.util;

import app.qwertz.qwertzcore.QWERTZcore;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class RejoinManager {
    private final QWERTZcore plugin;
    private final Map<UUID, Long> playerLeaveTimes;
    private final Map<UUID, Location> playerLeaveLocations;
    private final Map<UUID, Boolean> playerWasAlive;

    public RejoinManager(QWERTZcore plugin) {
        this.plugin = plugin;
        this.playerLeaveTimes = new HashMap<UUID, Long>();
        this.playerLeaveLocations = new HashMap<UUID, Location>();
        this.playerWasAlive = new HashMap<UUID, Boolean>();
        plugin.getServer().getScheduler().runTaskTimer((Plugin)plugin, this::cleanupExpiredData, 6000L, 6000L);
    }

    public void recordPlayerLeave(Player player) {
        if (this.plugin.getEventManager().isPlayerAlive(player)) {
            UUID playerId = player.getUniqueId();
            long currentTime = System.currentTimeMillis();
            this.playerLeaveTimes.put(playerId, currentTime);
            this.playerLeaveLocations.put(playerId, player.getLocation());
            this.playerWasAlive.put(playerId, this.plugin.getEventManager().isPlayerAlive(player));
            this.plugin.getLogger().info("Recorded player leave: " + player.getName() + " at " + currentTime);
        }
    }

    public boolean isRejoining(Player player) {
        long rejoinTimeMs;
        boolean isRejoining;
        if (!this.plugin.getConfigManager().getAllowRejoining()) {
            return false;
        }
        UUID playerId = player.getUniqueId();
        if (!this.playerLeaveTimes.containsKey(playerId)) {
            return false;
        }
        long leaveTime = this.playerLeaveTimes.get(playerId);
        long currentTime = System.currentTimeMillis();
        boolean bl = isRejoining = currentTime - leaveTime <= (rejoinTimeMs = (long)this.plugin.getConfigManager().getRejoinTime() * 1000L);
        if (isRejoining) {
            this.plugin.getLogger().info("Player " + player.getName() + " is rejoining within " + this.plugin.getConfigManager().getRejoinTime() + " seconds");
        }
        return isRejoining;
    }

    public Location getLeaveLocation(UUID playerId) {
        return this.playerLeaveLocations.get(playerId);
    }

    public boolean wasAliveWhenLeft(UUID playerId) {
        return this.playerWasAlive.getOrDefault(playerId, false);
    }

    public void cleanupPlayerData(UUID playerId) {
        this.playerLeaveTimes.remove(playerId);
        this.playerLeaveLocations.remove(playerId);
        this.playerWasAlive.remove(playerId);
    }

    public void handlePlayerRejoin(Player player) {
        UUID playerId = player.getUniqueId();
        if (!this.isRejoining(player)) {
            this.cleanupPlayerData(playerId);
            return;
        }
        this.plugin.getLogger().info("Handling rejoin for player: " + player.getName());
        Location leaveLocation = this.getLeaveLocation(playerId);
        boolean wasAlive = this.wasAliveWhenLeft(playerId);
        if (leaveLocation != null && leaveLocation.getWorld() != null) {
            player.teleport(leaveLocation);
            this.plugin.getLogger().info("Teleported rejoining player " + player.getName() + " back to previous location");
        }
        if (wasAlive) {
            this.plugin.getEventManager().revivePlayer(player, player);
            this.plugin.getLogger().info("Restored alive state for rejoining player: " + player.getName());
        }
        this.cleanupPlayerData(playerId);
        this.plugin.getMessageManager().sendMessage(player, "rejoin.welcome-back");
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%name%", player.getName());
        this.plugin.getMessageManager().broadcastMessage("chatting.rejoin-msg", localMap);
        this.plugin.getLogger().info("Successfully handled rejoin for player: " + player.getName());
    }

    public void cleanupExpiredData() {
        long currentTime = System.currentTimeMillis();
        long rejoinTimeMs = (long)this.plugin.getConfigManager().getRejoinTime() * 1000L;
        this.playerLeaveTimes.entrySet().removeIf(entry -> {
            boolean expired;
            boolean bl = expired = currentTime - (Long)entry.getValue() > rejoinTimeMs;
            if (expired) {
                UUID playerId = (UUID)entry.getKey();
                this.playerLeaveLocations.remove(playerId);
                this.playerWasAlive.remove(playerId);
                this.plugin.getLogger().info("Cleaned up expired rejoin data for player: " + String.valueOf(playerId));
            }
            return expired;
        });
    }

    public int getTrackedPlayerCount() {
        return this.playerLeaveTimes.size();
    }
}

