/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.util;

import app.qwertz.qwertzcore.QWERTZcore;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class TablistManager {
    private final QWERTZcore plugin;
    private FileConfiguration tabConfig;
    private FileConfiguration fileTabConfig;
    private FileConfiguration internalTabConfig;
    private final Map<Integer, String> pingColors = new TreeMap(Comparator.naturalOrder());
    private int tabTaskID = -1;

    public TablistManager(QWERTZcore plugin) {
        this.plugin = plugin;
        this.loadTabConfig();
        this.tabConfig = this.getConfigToUse();
        this.setupPingColors();
        this.setupPingColors();
        this.startTablistUpdater();
    }

    private void setupPingColors() {
        ConfigurationSection pingSection = this.tabConfig.getConfigurationSection("ping-colors");
        if (pingSection != null) {
            pingSection.getKeys(false).forEach(key -> {
                try {
                    if (!key.equals("default")) {
                        int threshold = Integer.parseInt(key);
                        this.pingColors.put(threshold, pingSection.getString(key));
                    }
                }
                catch (NumberFormatException e) {
                    this.plugin.getLogger().warning("Invalid ping threshold in tab.yml: " + key);
                }
            });
        }
    }

    private FileConfiguration getConfigToUse() {
        String activeTheme = this.plugin.getMessageManager().messagesConfig.getString("active-theme");
        if (Objects.equals(activeTheme, "file")) {
            return this.fileTabConfig;
        }
        if (Objects.equals(activeTheme, "internal")) {
            return this.internalTabConfig;
        }
        FileConfiguration repoConfig = this.plugin.getMessageManager().loadFromRepo(activeTheme, "tab");
        if (repoConfig != null) {
            return repoConfig;
        }
        this.plugin.getLogger().warning("Failed to load theme from repo, using internal.");
        return this.internalTabConfig;
    }

    private void loadTabConfig() {
        File tabFile = new File(this.plugin.getDataFolder(), "tab.yml");
        if (!tabFile.exists()) {
            this.plugin.saveResource("tab.yml", false);
        }
        this.fileTabConfig = YamlConfiguration.loadConfiguration((File)tabFile);
        InputStream defaultStream = this.plugin.getResource("tab.yml");
        if (defaultStream != null) {
            this.internalTabConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultStream));
        }
    }

    public void updateTablist(Player player) {
        if (this.plugin.getConfigManager().getTabList()) {
            String header = this.buildHeaderFooter("header");
            String footer = this.buildHeaderFooter("footer");
            player.setPlayerListHeaderFooter(header, footer);
            this.updatePlayerListName(player);
        }
    }

    private String buildHeaderFooter(String path) {
        List lines = this.tabConfig.getStringList(path);
        StringBuilder builder = new StringBuilder();
        for (String line : lines) {
            builder.append(this.prepareLine(line)).append("\n");
        }
        return builder.toString();
    }

    private String prepareLine(String line) {
        return this.plugin.getMessageManager().prepareMessage(line, new HashMap<String, String>()).replace("%server%", this.plugin.getConfigManager().getServerName()).replace("%event%", this.plugin.getConfigManager().getEventName()).replace("%discord%", this.plugin.getConfigManager().getDiscordLink()).replace("%player%", String.valueOf(this.plugin.getVanishManager().getNonVanishedPlayerCount()));
    }

    private void updatePlayerListName(Player player) {
        String format = this.tabConfig.getString("player-list-name", "%prefix%%player_name%%suffix% %ping_color%%ping%ms");
        String pingColor = this.getPingColor(player.getPing());
        String listName = format.replace("%prefix%", this.plugin.getRankManager().getPrefix(player)).replace("%suffix%", this.plugin.getRankManager().getSuffix(player)).replace("%player%", player.getName()).replace("%ping_color%", pingColor).replace("%ping%", String.valueOf(player.getPing()));
        Scoreboard scoreboard = player.getScoreboard();
        Team team = scoreboard.getTeam(player.getName());
        if (team == null) {
            team = scoreboard.registerNewTeam(player.getName());
        }
        team.setPrefix(this.plugin.getRankManager().getPrefix(player));
        team.setSuffix(this.plugin.getRankManager().getSuffix(player) + " " + pingColor + player.getPing());
        team.addEntry(player.getName());
        player.setPlayerListName(ChatColor.translateAlternateColorCodes((char)'&', (String)listName));
    }

    private String getPingColor(int ping) {
        for (Map.Entry<Integer, String> entry : this.pingColors.entrySet()) {
            if (ping > entry.getKey()) continue;
            return entry.getValue();
        }
        return this.tabConfig.getString("ping-colors.default", "&4");
    }

    private void startTablistUpdater() {
        this.stopTabUpdater();
        this.tabTaskID = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.updateTablist(player);
            }
        }, 20L, 20L).getTaskId();
    }

    public void stopTabUpdater() {
        if (this.tabTaskID != -1) {
            Bukkit.getScheduler().cancelTask(this.tabTaskID);
            this.tabTaskID = -1;
        }
    }
}

