/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore;

import app.qwertz.qwertzcore.bstats.Metrics;
import app.qwertz.qwertzcore.commands.AdvertisementCommand;
import app.qwertz.qwertzcore.commands.BroadcastCommand;
import app.qwertz.qwertzcore.commands.ChatMuteCommand;
import app.qwertz.qwertzcore.commands.ChatReviveCommand;
import app.qwertz.qwertzcore.commands.ClearInventoryCommand;
import app.qwertz.qwertzcore.commands.ConfigCommand;
import app.qwertz.qwertzcore.commands.CoreCommand;
import app.qwertz.qwertzcore.commands.DiscordCommand;
import app.qwertz.qwertzcore.commands.EmojiCommand;
import app.qwertz.qwertzcore.commands.EventBlockCommand;
import app.qwertz.qwertzcore.commands.EventCommands;
import app.qwertz.qwertzcore.commands.EventCountdownCommand;
import app.qwertz.qwertzcore.commands.GamemodeCommand;
import app.qwertz.qwertzcore.commands.HideCommand;
import app.qwertz.qwertzcore.commands.InvseeCommand;
import app.qwertz.qwertzcore.commands.KitCommand;
import app.qwertz.qwertzcore.commands.MessageCommands;
import app.qwertz.qwertzcore.commands.PollCommand;
import app.qwertz.qwertzcore.commands.PollVoteCommand;
import app.qwertz.qwertzcore.commands.RejoinCommand;
import app.qwertz.qwertzcore.commands.ReloadCoreCommand;
import app.qwertz.qwertzcore.commands.ReviveTokenCommands;
import app.qwertz.qwertzcore.commands.SetterCommands;
import app.qwertz.qwertzcore.commands.SpawnCommand;
import app.qwertz.qwertzcore.commands.SpeedCommand;
import app.qwertz.qwertzcore.commands.ThemeCommand;
import app.qwertz.qwertzcore.commands.TimerCommand;
import app.qwertz.qwertzcore.commands.VanishCommands;
import app.qwertz.qwertzcore.commands.WarpCommands;
import app.qwertz.qwertzcore.commands.WinCommands;
import app.qwertz.qwertzcore.commands.WorldGuardCommands;
import app.qwertz.qwertzcore.commands.tab.AdTabCompleter;
import app.qwertz.qwertzcore.commands.tab.ChatReviveTabCompleter;
import app.qwertz.qwertzcore.commands.tab.ConfigTabCompleter;
import app.qwertz.qwertzcore.commands.tab.EventBlockTabCompleter;
import app.qwertz.qwertzcore.commands.tab.GameModeTabCompleter;
import app.qwertz.qwertzcore.commands.tab.GiveCommandTabCompleter;
import app.qwertz.qwertzcore.commands.tab.HideTabCompleter;
import app.qwertz.qwertzcore.commands.tab.KitTabCompleter;
import app.qwertz.qwertzcore.commands.tab.RejoinTabCompleter;
import app.qwertz.qwertzcore.commands.tab.ReviveLastTabCompleter;
import app.qwertz.qwertzcore.commands.tab.SpeedTabCompleter;
import app.qwertz.qwertzcore.commands.tab.ThemeTabCompleter;
import app.qwertz.qwertzcore.commands.tab.TimerTabCompleter;
import app.qwertz.qwertzcore.commands.tab.WarpTabCompleter;
import app.qwertz.qwertzcore.commands.tab.WorldGuardTabCompleter;
import app.qwertz.qwertzcore.gui.ConfigGUI;
import app.qwertz.qwertzcore.listeners.ChatRevivalChatListener;
import app.qwertz.qwertzcore.listeners.PollChatListener;
import app.qwertz.qwertzcore.papi.Placeholders;
import app.qwertz.qwertzcore.util.BlockEventListener;
import app.qwertz.qwertzcore.util.BlockManager;
import app.qwertz.qwertzcore.util.ChatManager;
import app.qwertz.qwertzcore.util.CommandRemapper;
import app.qwertz.qwertzcore.util.ConfigManager;
import app.qwertz.qwertzcore.util.DatabaseManager;
import app.qwertz.qwertzcore.util.EventManager;
import app.qwertz.qwertzcore.util.MessageManager;
import app.qwertz.qwertzcore.util.PlayerDeathListener;
import app.qwertz.qwertzcore.util.PlayerEventListener;
import app.qwertz.qwertzcore.util.RankManager;
import app.qwertz.qwertzcore.util.RejoinManager;
import app.qwertz.qwertzcore.util.RestrictedCommandsListener;
import app.qwertz.qwertzcore.util.ScoreboardManager;
import app.qwertz.qwertzcore.util.SoundManager;
import app.qwertz.qwertzcore.util.TablistManager;
import app.qwertz.qwertzcore.util.UpdateChecker;
import app.qwertz.qwertzcore.util.VanishManager;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class QWERTZcore
extends JavaPlugin {
    private static final Pattern HEX_PATTERN = Pattern.compile("&#([A-Fa-f0-9]{6})");
    public static final String CORE_ICON_RAW = "\u2747";
    public static final String CORE_ICON_COLOR = "#FF6700";
    public static final String CORE_ICON = QWERTZcore.translateHexColorCodes("&#FF6700\u2747") + String.valueOf(ChatColor.RESET);
    public static final String VERSION = "3.1";
    public static final String AUTHORS = "QWERTZ_EXE";
    public static final String DISCORD_LINK = "https://discord.gg/Vp6Q4FHCzf";
    public static final String WEBSITE = "https://qwertz.app";
    private Metrics metrics;
    public Boolean isUsingWorldGuard = false;
    private VanishManager vanishManager;
    private SoundManager soundManager;
    private EventManager eventManager;
    private ConfigManager configManager;
    private RankManager rankManager;
    private ScoreboardManager scoreboardManager;
    private TablistManager tablistManager;
    private ChatManager chatManager;
    private DatabaseManager databaseManager;
    private HideCommand hideCommand;
    private EventCountdownCommand eventCountdownCommand;
    private MessageManager messageManager;
    private UpdateChecker updateChecker;
    private BlockManager blockManager;
    private ReloadCoreCommand reloadCoreCommand;
    private PollCommand pollCommand;
    private ChatReviveCommand chatReviveCommand;
    private RejoinManager rejoinManager;

    public void onEnable() {
        this.getLogger().info("Enabling QWERTZ Core...");
        this.configManager = new ConfigManager(this);
        this.configManager.loadConfig();
        this.vanishManager = new VanishManager(this);
        this.eventManager = new EventManager(this);
        this.rankManager = new RankManager(this);
        if (this.rankManager.isUsingLuckPerms()) {
            this.getLogger().info("[EXTENSION] LuckPerms found and hooked successfully.");
        } else if (this.rankManager.isUsingPowerRanks()) {
            this.getLogger().info("[EXTENSION] PowerRanks found and hooked successfully.");
        } else {
            this.getLogger().warning("[EXTENSION] LuckPerms not found. Using default rank system.");
        }
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            this.getLogger().info("[EXTENSION] PlaceholderAPI found and added placeholders successfully.");
            new Placeholders(this).register();
        } else {
            this.getLogger().warning("[EXTENSION] PlaceholderAPI not found. No placeholders will be provided.");
        }
        if (Bukkit.getPluginManager().getPlugin("WorldGuard") != null) {
            this.getLogger().info("[EXTENSION] WorldGuard found and added security commands successfully.");
            this.isUsingWorldGuard = true;
        } else {
            this.getLogger().warning("[EXTENSION] WorldGuard not found. No security commands will be provided.");
        }
        this.messageManager = new MessageManager(this);
        this.databaseManager = new DatabaseManager(this);
        this.scoreboardManager = new ScoreboardManager(this);
        this.tablistManager = new TablistManager(this);
        this.chatManager = new ChatManager(this);
        this.databaseManager.initializeSpecialBlocks();
        this.soundManager = new SoundManager(this);
        this.updateChecker = new UpdateChecker(this);
        this.blockManager = new BlockManager(this);
        this.rejoinManager = new RejoinManager(this);
        this.registerCommands();
        this.registerListeners();
        PluginCommand configCommand = this.getCommand("config");
        if (configCommand != null) {
            configCommand.setExecutor((CommandExecutor)new ConfigCommand(this));
            configCommand.setTabCompleter((TabCompleter)new ConfigTabCompleter(this));
        }
        int pluginId = 23512;
        this.metrics = new Metrics((Plugin)this, pluginId);
        for (String commandName : this.getDescription().getCommands().keySet()) {
            PluginCommand command = this.getCommand(commandName);
            if (command == null) continue;
            CommandExecutor originalExecutor = command.getExecutor();
            command.setExecutor((CommandExecutor)new CommandRemapper(this, originalExecutor, commandName));
        }
        this.printAsciiArt();
        this.getLogger().info("QWERTZ Core has been enabled!");
    }

    private void printAsciiArt() {
        ConsoleCommandSender console = Bukkit.getConsoleSender();
        String[] asciiArt = new String[]{"\u00a76\u28fc\u28ff\u28ff\u281f\u2801\u2800\u2800\u2880\u28e4\u28fe\u28ff\u287f\u281f\u2809\u2800\u2800\u2800\u2800\u2800\u2800\u28c0\u28e4\u28f4\u287e\u283f\u281b\u281b\u280b\u2809\u2800\u2800\u2800\u2800\u2800\u2800\u2800\u2809\u2809\u2819\u281b\u283f\u283f\u28ff\u28f6\u28e6\u28c4\u28c0\u2800\u2800\u2800\u2809\u281b\u283f\u28ff\u28ff\u28f6\u28c4\u2840\u2800\u2800\u2808\u283b\u28bf\u28ff\u28e6", "\u00a75\u28ff\u281f\u2801\u2800\u2800\u2880\u28f4\u28ff\u28ff\u283f\u280b\u2800\u2800\u2800\u2800\u2800\u2880\u28e4\u28f6\u28ff\u283f\u280b\u2801\u2800\u2800\u2800\u2800\u2800\u2800\u2800\u2800\u2800\u2880\u28c0\u28c0\u2840\u2800 \u2800\u2800\u2800\u2800\u2800\u2809\u2819\u283b\u28bf\u28ff\u28f6\u28e4\u2840\u2800\u2800\u2808\u2819\u28bf\u28ff\u28ff\u28f6\u28c4\u2800\u2800\u2800\u2818\u28bf", "\u00a74\u280b\u2800\u2800\u28a0\u28f4\u28ff\u28ff\u281f\u2801\u2800\u2800\u2800\u2800\u28c0\u28f4\u28fe\u287f\u281b\u2809\u2800\u2800\u2800\u28c0\u28e0\u28e4\u28f4\u28f6\u28f6\u28ff\u28ff\u28ff\u28ff\u28ff\u28ff\u28ff\u28ff\u28ff\u28ff\u28f7\u28e6\u28e4\u28c4\u2840\u2800\u2800\u2800\u2800\u2808\u2819\u283f\u28ff\u28f7\u28e6\u2840\u2800\u2800\u2808\u283b\u28ff\u28ff\u28f7\u28c4\u2800\u2800\u2808", "\u00a73\u2800\u2880\u28f4\u28ff\u28ff\u281f\u2801\u2800\u2800\u2800\u2880\u28e0\u28fe\u28ff\u281f\u2801\u2800\u2800\u2880\u28e4\u28f6\u28ff\u28ff\u28ff\u28ff\u283f\u281f\u281b\u2809\u2801\u2800\u2800\u2800\u2800\u2800\u2800\u2808\u2809\u2819\u281b\u283f\u28bf\u28ff\u28f7\u28e6\u28c4\u2840\u2800\u2800\u2800\u2800\u2819\u28bf\u28ff\u28f6\u28c4\u2800\u2800\u2800\u281b\u28bf\u28ff\u28f7\u2840\u2800", "\u00a72\u2880\u28fe\u28ff\u287f\u2803\u2800\u2800\u2800\u2880\u28f4\u28ff\u287f\u280b\u2800\u2800\u2880\u28f4\u28fe\u28ff\u28ff\u28ff\u283f\u281b\u2809\u2800\u28c0\u28e4\u28f4\u28f6\u28fe\u28f6\u28ff\u28ff\u28ff\u28ff\u28f6\u28f6\u28f6\u28e6\u28e4\u28c0\u2840\u2800\u2809\u281b\u283f\u28ff\u28f7\u28e6\u28c4\u2840\u2800\u2800\u2808\u283b\u28ff\u28f7\u28c4\u2800\u2800\u2800\u281b\u28bf\u28ff\u28c4", "\u00a71\u28ff\u28ff\u281f\u2801\u2800\u2800\u2880\u28f4\u28ff\u281f\u2801\u2800\u2800\u28e0\u28f6\u28ff\u28ff\u287f\u281f\u280b\u2800\u2880\u28e4\u28f6\u28ff\u28ff\u287f\u283f\u281b\u281b\u281b\u2809\u2809\u2819\u281b\u281b\u283b\u283f\u283f\u28ff\u28ff\u28ff\u28f7\u28e6\u28c4\u2840\u2800\u2819\u283b\u28ff\u28ff\u28e6\u28c0\u2800\u2800\u2809\u28bb\u28ff\u28f7\u2844\u2800\u2800\u2800\u2839\u28ff", "\u00a7r\u28ff\u280b\u2800\u2800\u2800\u28f0\u28ff\u285f\u2801\u2800\u2800\u28e0\u28fe\u28ff\u28ff\u281f\u2809\u2800\u2880\u28e4\u28fe\u28ff\u283f\u281b\u2809\u2800\u28c0\u28e4\u28e4\u28f6\u28f6\u28f6\u28ff\u28f6\u28f6\u28f6\u28e6\u28e4\u28e4\u28c0\u2840\u2808\u2819\u283f\u28ff\u28ff\u28f7\u28e4\u2840\u2800\u2819\u28bf\u28ff\u28e6\u2840\u2800\u2800\u2839\u28ff\u28ff\u28c6\u2800\u2800\u2800\u2818", "\u00a79\u2807\u2800\u2800\u2880\u28fe\u287f\u280b\u2800\u2880\u28f0\u28ff\u28ff\u28ff\u281f\u2801\u2880\u28e0\u28fe\u28ff\u283f\u280b\u2801\u2880\u28e0\u28f4\u28fe\u28ff\u283f\u281f\u281b\u281b\u281b\u2809\u2809\u2809\u2819\u281b\u281b\u281b\u283f\u283f\u28f7\u28e6\u28c4\u2840\u2819\u283b\u28ff\u28ff\u28e6\u2840\u2800\u2819\u28ff\u28f7\u2844\u2800\u2800\u2818\u28ff\u28ff\u28e7\u2800\u2800\u2800", "\u00a78\u2800\u2800\u2880\u28ff\u287f\u2803\u2800\u2800\u28fc\u28ff\u28ff\u285f\u2803\u2800\u28e0\u28fc\u28ff\u281f\u2803\u2800\u2880\u28e4\u28ff\u28ff\u283f\u281b\u2800\u28c0\u28e4\u28e4\u28fc\u28ff\u28ff\u28ff\u28ff\u28ff\u28ff\u28ff\u28e4\u28c0\u2840\u2800\u281b\u28bf\u28ff\u28e7\u2840\u2800\u283b\u28ff\u28ff\u28c4\u2800\u2818\u28ff\u28ff\u2844\u2800\u2800\u2838\u28ff\u28ff\u28e7\u2800\u2800", "\u00a77\u2800\u28a0\u28ff\u287f\u2801\u2800\u2880\u28fe\u28ff\u287f\u280f\u2800\u28e0\u28fe\u28ff\u281f\u2801\u2800\u28e0\u28f6\u28ff\u283f\u280b\u28e1\u28f4\u28fe\u28ff\u287f\u283f\u283f\u281b\u281b\u281b\u281b\u281b\u281b\u283b\u283f\u28bf\u28ff\u28ff\u28f6\u28e4\u2840\u2808\u283b\u28ff\u28e6\u28c0\u2808\u283b\u28ff\u28e7\u2840\u2808\u28bb\u28ff\u2844\u2800\u2800\u2819\u28ff\u28ff\u28c6\u2800", "\u00a7a\u28a0\u28ff\u285f\u2800\u2800\u28a0\u28ff\u28ff\u285f\u2801\u2880\u28fe\u28ff\u287f\u2801\u2800\u28e0\u28fe\u28ff\u281f\u2881\u28f4\u28ff\u28ff\u281f\u280b\u2800\u2800\u2800\u28c0\u28e0\u28e4\u28e4\u28e4\u28e4\u28e4\u28c0\u2800\u2800\u2808\u2819\u283b\u28ff\u28ff\u28f6\u28c4\u2808\u283b\u28ff\u28e6\u2840\u2808\u28bf\u28f7\u2840\u2800\u28bb\u28ff\u2844\u2800\u2800\u2818\u28ff\u28ff\u2844", "\u00a7b\u285f\u2800\u2800\u28a0\u28ff\u28ff\u280f\u2800\u28f0\u28ff\u28ff\u280b\u2800\u2880\u28fc\u28ff\u287f\u2801\u28f4\u28ff\u287f\u280b\u2800\u2800\u28c0\u28f4\u28fe\u28ff\u287f\u281f\u281b\u281b\u281b\u281b\u283f\u283f\u28ff\u28f7\u28e6\u28c4\u2840\u2800 \u2839\u28ff\u28ff\u28e6\u2840\u2809\u28bf\u28f7\u2844\u2800\u28bb\u28f7\u2840\u2800\u28bb\u28ff\u2844\u2800\u2800\u2818\u28ff\u28ff", "\u00a7c\u287f\u2800\u2800\u2880\u28fe\u28ff\u280b\u2800\u28b8\u28ff\u287f\u2803\u2800\u28a0\u28fe\u28ff\u280b\u2880\u28fe\u28ff\u281f\u2800\u2800\u28e0\u28fe\u28ff\u287f\u281f\u2889\u28c0\u28e0\u28e4\u28e4\u28e4\u28e4\u28c0\u2840\u2800\u2809\u283b\u28bf\u28ff\u28e6\u2800\u2808\u28bf\u28ff\u28f7\u2844\u2808\u28bb\u28ff\u2846\u2800\u28bb\u28e7\u2800\u2800\u28bb\u28ff\u2800\u2800\u2800\u2818\u28ff", "\u00a7d\u2803\u2800\u2800\u28fe\u28ff\u2807\u2800\u28a0\u28ff\u28ff\u2801\u2800\u28f0\u28ff\u28ff\u2803\u28a0\u28fe\u287f\u2803\u2800\u2880\u28fe\u28ff\u287f\u288b\u28e4\u28fe\u28ff\u28ff\u287f\u283f\u283f\u283f\u283f\u28bf\u28ff\u28ff\u28e6\u28c4\u2800\u2839\u28ff\u28f7\u28c4\u2808\u28bb\u28ff\u28ff\u2844\u2800\u28bb\u28ff\u2840\u2800\u28bf\u2846\u2800\u2808\u28bf\u28c7\u2800\u2800\u2800\u28bb", "\u00a7e\u2800\u2800\u28fc\u28ff\u28df\u2800\u2880\u28fe\u28ff\u2807\u2800\u28a0\u28ff\u28ff\u280f\u28a0\u28ff\u287f\u2801\u2800\u28e0\u28ff\u28ff\u280f\u28e0\u28fe\u28ff\u281f\u288b\u28e1\u28e4\u28f6\u28fe\u28ff\u28f6\u28e6\u28c4\u2819\u28bf\u28ff\u28f7\u2844\u2818\u28ff\u28ff\u28c6\u2800\u28bb\u28ff\u28ff\u2840\u2800\u28bf\u28e7\u2800\u2818\u28f7\u2800\u2800\u28b8\u28ff\u2800\u2800\u2800\u2818", "\u00a7f\u2800\u2820\u28ff\u28ff\u2807\u2800\u28fc\u28ff\u285f\u2800\u2800\u28fc\u28ff\u285f\u2800\u28fa\u28ff\u2803\u2800\u28b0\u28ff\u28ff\u2803\u28f0\u28ff\u283f\u2881\u28f4\u28ff\u287f\u281b\u2889\u28c9\u2809\u2809\u283b\u28ff\u28e7\u2840\u28bb\u28ff\u28ff\u2846\u2818\u28ff\u28ff\u2844\u2800\u28bf\u28ff\u28e7\u2800\u2818\u28ff\u2846\u2800\u28bb\u2847\u2800\u2800\u28bf\u2847\u2800\u2800\u2800", "\u00a76\u2800\u28b8\u28ff\u287f\u2800\u28f8\u28ff\u28ff\u2803\u2800\u28b0\u28ff\u285f\u2800\u28b0\u28ff\u284f\u2800\u28a0\u28ff\u28ff\u2807\u28f0\u28ff\u280f\u28f4\u28ff\u281f\u00a76/\u00af\u00af\u00af\u00af\u00af\\\u00a76\u28c4\u2818\u28bf\u28e7\u2800\u28bb\u28ff\u28c7\u2800\u28b9\u28ff\u28f7\u2800\u28b8\u28ff\u28ff\u2800\u2830\u28ff\u28c7\u2800\u28b9\u28ff\u2800\u2800\u28b8\u28c7\u2800\u2800\u2800", "\u00a75\u2800\u28fe\u28ff\u2807\u2800\u28fd\u28ff\u287f\u2800\u2800\u28ff\u28ff\u2803\u2800\u28fc\u28ff\u2800\u2800\u28fa\u28ff\u285f\u28a0\u28ff\u285f\u28fc\u287f\u2801\u28fc\u00a76|     |\u00a75\u28ff\u2846\u28b8\u28ff\u2806\u2808\u28ff\u28ff\u2800\u28b8\u28ff\u28ff\u2800\u2800\u28ff\u28ff\u2800\u28a8\u28ff\u28ff\u2800\u28b8\u28ff\u2800\u2800\u28b8\u28ff\u2800\u2800\u28a0", "\u00a74\u2800\u28ff\u28ff\u2800\u2820\u28ff\u28ff\u2847\u2800\u2800\u28ff\u285f\u2800\u2800\u28ff\u284f\u2800\u28a0\u28ff\u28ff\u2801\u28fc\u28ff\u28a0\u28ff\u2847\u28b0\u28ff\u00a76|     |\u00a74\u28ff\u2847\u28b8\u28ff\u2847\u2800\u28ff\u28df\u2800\u28b8\u28ff\u28ff\u2800\u28b8\u28ff\u28ff\u2800\u28b0\u28ff\u2847\u2800\u28bb\u28ff\u2800\u2800\u28b8\u28ff\u2800\u2800\u28b8", "\u00a73\u2800\u28ff\u28ff\u2800\u2880\u28ff\u28ff\u2847\u2800\u2800\u28ff\u285f\u2800\u2800\u28ff\u2867\u2800\u28b8\u28ff\u284f\u2800\u28ff\u284f\u28b8\u28ff\u2847\u28b8\u28ff\u00a76|     |\u00a73\u281f\u28a1\u28ff\u28ff\u2800\u28fc\u28ff\u284f\u2800\u28fc\u28ff\u285f\u2880\u28fe\u28ff\u2847\u2800\u28fe\u28ff\u2847\u2800\u28ff\u28ff\u2800\u2800\u28ff\u28ff\u2800\u2800\u28b8", "\u00a72\u2800\u28ff\u28ff\u2800\u2820\u28ff\u28ff\u2847\u2800\u2800\u28ff\u2847\u2800\u2800\u28ff\u2847\u2800\u28b8\u28ff\u2801\u2800\u28ff\u28c7\u2818\u28ff\u28e7\u2818\u28ff\u00a76\\_____/\u00af\\\u00a72\u287f\u2801\u28f4\u28ff\u28ff\u2803\u28fc\u28ff\u28ff\u2803\u28fc\u28ff\u287f\u2800\u28fc\u28ff\u287f\u2800\u28fc\u28ff\u284f\u2800\u28b8\u28ff\u287f\u2800\u2800\u28fc", "\u00a71\u2800\u28bf\u28ff\u2840\u2800\u28bf\u28ff\u28e7\u2800\u2800\u28ff\u2846\u2800\u2800\u28ff\u2846\u2800\u28b8\u28ff\u2840\u2800\u28ff\u28ff\u2840\u2839\u28ff\u28e6\u2858\u283f\u28ff\u28ff\u28ff\u00a76\\    \\\u00a71\u28fe\u28ff\u287f\u280b\u28fc\u28ff\u287f\u2803\u28fc\u28ff\u28ff\u2803\u28fc\u28ff\u28ff\u2801\u28f0\u28ff\u287f\u2801\u2880\u28ff\u28ff\u2847\u2800\u2800\u28fe", "\u00a7r\u2800\u28b8\u28ff\u2847\u2800\u28b9\u28ff\u28ff\u2800\u2800\u28b8\u28df\u2800\u2800\u28b9\u28c7\u2800\u28b8\u28ff\u28e7\u2800\u2839\u28ff\u28e7\u2840\u2839\u28ff\u28ff\u28f7\u28e6\u28ec\u28ed\u28e4\u00a76\\____\\\u00a7r\u280b\u28e0\u28fe\u28ff\u281f\u2880\u28fc\u28ff\u287f\u2803\u28f0\u28ff\u28ff\u2803\u28f0\u28ff\u28ff\u2801\u2800\u28fc\u28ff\u28ff\u2800\u2800\u28b0\u28ff", "\u00a79\u2800\u2808\u28ff\u28ff\u2800\u2808\u28ff\u28ff\u2844\u2800\u2808\u28ff\u2846\u2800\u2838\u28ff\u2840\u2800\u28bf\u28ff\u28e7\u2840\u2839\u28ff\u28f7\u28c4\u2848\u2819\u283f\u283f\u28bf\u28ff\u28ff\u287f\u283f\u281f\u281b\u28c1\u28e4\u28fe\u287f\u281f\u2801\u28f0\u28fe\u28ff\u281f\u28a1\u28fe\u28ff\u287f\u2803\u28a0\u28ff\u28ff\u2803\u2800\u28f0\u28ff\u28ff\u2807\u2800\u2800\u28fc\u287f", "\u00a78\u2800\u2800\u28ff\u28ff\u2847\u2800\u28b9\u28ff\u28e7\u2800\u2800\u28bb\u28ff\u2800\u2800\u28bb\u28f7\u2800\u2808\u28ff\u28ff\u28ff\u28e6\u2808\u28bb\u28ff\u28ff\u28f6\u28e6\u28e4\u28e4\u2844\u28a0\u28e4\u28e4\u28f4\u28fe\u28ff\u285f\u280b\u2800\u28a0\u28fe\u28ff\u285f\u2801\u28f4\u28ff\u28ff\u285f\u2800\u28b0\u28ff\u28ff\u2803\u2800\u28b0\u28ff\u28ff\u284f\u2800\u2800\u28fc\u28ff\u2803", "\u00a77\u2800\u2800\u2818\u28ff\u28f7\u2800\u2800\u28bf\u28ff\u2844\u2800\u2818\u28ff\u28e7\u2800\u2818\u28ff\u28e7\u2840\u2808\u283b\u28ff\u28ff\u28f7\u28e4\u2849\u281b\u283f\u28ff\u28ff\u28ff\u28ff\u28ff\u28ff\u287f\u281f\u280b\u2809\u2880\u28e4\u28f6\u28ff\u281f\u2809\u2880\u28f4\u28ff\u287f\u280b\u2880\u28f4\u28ff\u287f\u2803\u2800\u28a0\u28ff\u287f\u287f\u2801\u2800\u28f0\u28ff\u280f\u2800", "\u00a7a\u28c7\u2800\u2800\u2839\u28ff\u28e7\u2800\u2808\u28ff\u28ff\u28c6\u2800\u2839\u28ff\u28f7\u2840\u2818\u28bf\u28ff\u28e6\u2840\u2808\u281b\u28bf\u28ff\u28ff\u28f7\u28e6\u28c4\u28c0\u28c8\u28c1\u28c0\u28c0\u28e0\u28e4\u28f6\u28fe\u287f\u281f\u280b\u2800\u28e0\u28f6\u28ff\u287f\u280b\u2880\u28e4\u28ff\u28ff\u281f\u2801\u2800\u28f0\u28ff\u28ff\u281f\u2801\u2800\u28fc\u28ff\u280f\u2800\u2800", "\u00a7b\u28ff\u2846\u2800\u2800\u28bb\u28ff\u28f7\u2840\u2808\u28bf\u28ff\u28e6\u2800\u2818\u28bf\u28f7\u28c4\u2800\u2839\u28bf\u28ff\u28f6\u28c4\u2840\u2800\u2809\u281b\u281b\u283f\u283f\u283f\u283f\u283f\u283f\u281b\u280b\u2809\u2800\u2880\u28e0\u28f4\u28fe\u287f\u281f\u2809\u28e0\u28f6\u28ff\u28ff\u287f\u2809\u2800\u28e0\u28fe\u28ff\u28ff\u2803\u2800\u2880\u28fe\u28ff\u280b\u2800\u2800\u28fc", "\u00a7c\u28bb\u28ff\u28c6\u2800\u2800\u283b\u28ff\u28f7\u2840\u2808\u283b\u28ff\u28ff\u28c4\u2800\u2819\u283f\u28f7\u28e4\u2840\u2809\u281b\u283f\u28ff\u28f7\u28e6\u28e4\u28c0\u28c0\u28c0\u28c0\u28c0\u28c0\u28c0\u28e4\u28e4\u28f6\u28fe\u283f\u281f\u281b\u2889\u28e0\u28f4\u28ff\u28ff\u28ff\u281f\u280b\u2800\u28e0\u28f6\u28ff\u287f\u281b\u2801\u2800\u28f4\u28ff\u281f\u2801\u2800\u28a0\u28fe\u28bf", "\u00a7d\u2800\u28bb\u28ff\u28e7\u2840\u2800\u2819\u28ff\u28ff\u28c4\u2800\u2808\u28bf\u28ff\u28f7\u28c4\u2800\u2808\u283b\u28bf\u28f7\u28e6\u28c4\u2840\u2809\u2819\u281b\u281b\u283b\u283f\u281b\u281b\u281b\u281b\u2809\u2809\u2800\u2880\u28e0\u28f4\u28fe\u28ff\u28ff\u28ff\u287f\u281f\u2801\u2800\u28e0\u28fe\u28ff\u287f\u280b\u2800\u2800\u28e0\u28fe\u287f\u280b\u2800\u2880\u28f4\u28ff\u285f\u2801", "\u00a7e\u2800\u2800\u283b\u28ff\u28f7\u2844\u2800\u2818\u28bf\u28ff\u28e6\u2844\u2800\u2809\u283f\u28ff\u28f7\u28e4\u28c0\u2800\u2808\u2819\u283b\u283f\u28ff\u28f6\u28f6\u28f4\u28e6\u28f4\u28f6\u28f4\u28e4\u28f6\u28f6\u28fe\u28ff\u28ff\u283f\u283f\u281f\u281b\u2809\u2800\u2800\u28c0\u28f4\u28ff\u287f\u281f\u2801\u2800\u2800\u28e0\u28fe\u287f\u280b\u2800\u2880\u28f4\u28ff\u28ff\u2803\u2800\u2800", "\u00a7f\u2844\u2800\u2800\u2819\u28bf\u28ff\u28e6\u2840\u2800\u2819\u28bf\u28ff\u28e6\u2840\u2800\u2808\u281b\u28bf\u28ff\u28ff\u28f6\u28e4\u28c0\u2840\u2800\u2808\u2809\u2809\u2809\u281b\u281b\u281b\u281b\u280b\u2809\u2809\u2800\u2800\u2800\u2800\u2880\u28c0\u28e4\u28f6\u28ff\u287f\u281f\u280b\u2800\u2800\u2880\u28e0\u28fe\u283f\u280b\u2800\u28e0\u28f4\u28ff\u287f\u281b\u2800\u2800\u2880\u28f4", "\u00a76\u28ff\u28c6\u2800\u2800\u2808\u281b\u28ff\u28ff\u28e6\u2840\u2800\u2819\u283f\u28ff\u28f7\u28e4\u28c0\u2840\u2808\u2819\u283b\u28bf\u28ff\u28ff\u28ff\u28f7\u28f6\u28f6\u28f6\u28e4\u28e4\u28e4\u28e4\u28e4\u28f4\u28f6\u28f6\u28ff\u28fe\u28ff\u283f\u281f\u281b\u2809\u2800\u2800\u28c0\u28e0\u28f4\u28f6\u287f\u280b\u2801\u28c0\u28e4\u28fe\u28ff\u287f\u280b\u2800\u2800\u28e0\u28f4\u28ff\u287f"};
        console.sendMessage("");
        for (String line : asciiArt) {
            console.sendMessage(ChatColor.translateAlternateColorCodes((char)'\u00a7', (String)line));
        }
        console.sendMessage("");
    }

    public void onDisable() {
        this.getLogger().info("Disabling QWERTZ Core...");
        this.metrics.shutdown();
        this.metrics = null;
        HandlerList.unregisterAll((Plugin)this);
        this.configManager = null;
        this.vanishManager = null;
        this.soundManager = null;
        this.eventManager = null;
        this.rankManager = null;
        this.scoreboardManager.stopScoreboardUpdater();
        this.scoreboardManager.removeScoreboardFromAllPlayers();
        this.scoreboardManager = null;
        this.tablistManager.stopTabUpdater();
        this.tablistManager = null;
        this.chatManager = null;
        this.databaseManager = null;
        this.messageManager = null;
        this.blockManager = null;
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        this.getLogger().info("QWERTZ Core has been disabled!");
    }

    private void registerCommands() {
        this.getCommand("core").setExecutor((CommandExecutor)new CoreCommand(this));
        this.getCommand("timer").setExecutor((CommandExecutor)new TimerCommand(this));
        this.getCommand("timer").setTabCompleter((TabCompleter)new TimerTabCompleter());
        this.getCommand("gmc").setExecutor((CommandExecutor)new GamemodeCommand(this));
        this.getCommand("gms").setExecutor((CommandExecutor)new GamemodeCommand(this));
        this.getCommand("gmsp").setExecutor((CommandExecutor)new GamemodeCommand(this));
        this.getCommand("gma").setExecutor((CommandExecutor)new GamemodeCommand(this));
        this.getCommand("gm").setExecutor((CommandExecutor)new GamemodeCommand(this));
        this.getCommand("gm").setTabCompleter((TabCompleter)new GameModeTabCompleter());
        this.chatReviveCommand = new ChatReviveCommand(this);
        this.getCommand("chatrevival").setExecutor((CommandExecutor)this.chatReviveCommand);
        this.getCommand("chatrevival").setTabCompleter((TabCompleter)new ChatReviveTabCompleter());
        EventCommands eventCommands = new EventCommands(this);
        this.getCommand("revive").setExecutor((CommandExecutor)eventCommands);
        this.getCommand("unrevive").setExecutor((CommandExecutor)eventCommands);
        this.getCommand("reviveall").setExecutor((CommandExecutor)eventCommands);
        this.getCommand("unreviveall").setExecutor((CommandExecutor)eventCommands);
        this.getCommand("listalive").setExecutor((CommandExecutor)eventCommands);
        this.getCommand("listdead").setExecutor((CommandExecutor)eventCommands);
        this.getCommand("givedead").setExecutor((CommandExecutor)eventCommands);
        this.getCommand("givealive").setExecutor((CommandExecutor)eventCommands);
        this.getCommand("givedead").setTabCompleter((TabCompleter)new GiveCommandTabCompleter());
        this.getCommand("givealive").setTabCompleter((TabCompleter)new GiveCommandTabCompleter());
        this.getCommand("tpalive").setExecutor((CommandExecutor)eventCommands);
        this.getCommand("tpdead").setExecutor((CommandExecutor)eventCommands);
        this.getCommand("tpall").setExecutor((CommandExecutor)eventCommands);
        this.getCommand("tphere").setExecutor((CommandExecutor)eventCommands);
        this.getCommand("revivelast").setExecutor((CommandExecutor)eventCommands);
        this.getCommand("revivelast").setTabCompleter((TabCompleter)new ReviveLastTabCompleter());
        this.getCommand("healalive").setExecutor((CommandExecutor)eventCommands);
        this.getCommand("healdead").setExecutor((CommandExecutor)eventCommands);
        this.getCommand("vanish").setExecutor((CommandExecutor)new VanishCommands(this));
        this.getCommand("unvanish").setExecutor((CommandExecutor)new VanishCommands(this));
        this.getCommand("config").setExecutor((CommandExecutor)new ConfigCommand(this));
        this.getCommand("spawn").setExecutor((CommandExecutor)new SpawnCommand(this));
        ClearInventoryCommand clearInventoryCommand = new ClearInventoryCommand(this);
        this.getCommand("clearalive").setExecutor((CommandExecutor)clearInventoryCommand);
        this.getCommand("cleardead").setExecutor((CommandExecutor)clearInventoryCommand);
        this.hideCommand = new HideCommand(this);
        this.getCommand("hide").setExecutor((CommandExecutor)this.hideCommand);
        this.getCommand("hide").setTabCompleter((TabCompleter)new HideTabCompleter());
        this.eventCountdownCommand = new EventCountdownCommand(this);
        this.getCommand("eventcountdown").setExecutor((CommandExecutor)this.eventCountdownCommand);
        this.getCommand("eventcountdown").setTabCompleter((TabCompleter)new TimerTabCompleter());
        ReviveTokenCommands reviveCommands = new ReviveTokenCommands(this);
        this.getCommand("userevive").setExecutor((CommandExecutor)reviveCommands);
        this.getCommand("reviveaccept").setExecutor((CommandExecutor)reviveCommands);
        this.getCommand("revivedeny").setExecutor((CommandExecutor)reviveCommands);
        this.getCommand("addrevive").setExecutor((CommandExecutor)reviveCommands);
        this.getCommand("removerevive").setExecutor((CommandExecutor)reviveCommands);
        this.getCommand("revives").setExecutor((CommandExecutor)reviveCommands);
        DiscordCommand discordCommand = new DiscordCommand(this);
        this.getCommand("dc").setExecutor((CommandExecutor)discordCommand);
        this.getCommand("disc").setExecutor((CommandExecutor)discordCommand);
        this.getCommand("discord").setExecutor((CommandExecutor)discordCommand);
        ChatMuteCommand chatMuteCommand = new ChatMuteCommand(this);
        this.getCommand("mutechat").setExecutor((CommandExecutor)chatMuteCommand);
        this.getCommand("unmutechat").setExecutor((CommandExecutor)chatMuteCommand);
        AdvertisementCommand adCommand = new AdvertisementCommand(this);
        this.getCommand("ad").setExecutor((CommandExecutor)adCommand);
        this.getCommand("setad").setExecutor((CommandExecutor)adCommand);
        AdTabCompleter adTabCompleter = new AdTabCompleter();
        this.getCommand("ad").setTabCompleter((TabCompleter)adTabCompleter);
        this.getCommand("setad").setTabCompleter((TabCompleter)adTabCompleter);
        MessageCommands messageCommands = new MessageCommands(this);
        this.getCommand("message").setExecutor((CommandExecutor)messageCommands);
        this.getCommand("reply").setExecutor((CommandExecutor)messageCommands);
        this.getCommand("messagetoggle").setExecutor((CommandExecutor)messageCommands);
        WinCommands winCommands = new WinCommands(this);
        this.getCommand("addwin").setExecutor((CommandExecutor)winCommands);
        this.getCommand("removewin").setExecutor((CommandExecutor)winCommands);
        this.getCommand("wins").setExecutor((CommandExecutor)winCommands);
        WarpCommands warpCommands = new WarpCommands(this);
        this.getCommand("setwarp").setExecutor((CommandExecutor)warpCommands);
        this.getCommand("warp").setExecutor((CommandExecutor)warpCommands);
        this.getCommand("delwarp").setExecutor((CommandExecutor)warpCommands);
        this.getCommand("warps").setExecutor((CommandExecutor)warpCommands);
        WarpTabCompleter warpTabCompleter = new WarpTabCompleter(this);
        this.getCommand("setwarp").setTabCompleter((TabCompleter)warpTabCompleter);
        this.getCommand("warp").setTabCompleter((TabCompleter)warpTabCompleter);
        this.getCommand("delwarp").setTabCompleter((TabCompleter)warpTabCompleter);
        this.getCommand("eventblock").setExecutor((CommandExecutor)new EventBlockCommand(this));
        this.getCommand("eventblock").setTabCompleter((TabCompleter)new EventBlockTabCompleter());
        this.getCommand("createkit").setExecutor((CommandExecutor)new KitCommand(this));
        this.getCommand("kit").setExecutor((CommandExecutor)new KitCommand(this));
        this.getCommand("delkit").setExecutor((CommandExecutor)new KitCommand(this));
        this.getCommand("createkit").setTabCompleter((TabCompleter)new KitTabCompleter(this));
        this.getCommand("kit").setTabCompleter((TabCompleter)new KitTabCompleter(this));
        this.getCommand("delkit").setTabCompleter((TabCompleter)new KitTabCompleter(this));
        this.getCommand("kits").setExecutor((CommandExecutor)new KitCommand(this));
        this.getCommand("invsee").setExecutor((CommandExecutor)new InvseeCommand(this));
        if (this.isUsingWorldGuard.booleanValue()) {
            WorldGuardCommands worldGuardCommands = new WorldGuardCommands(this);
            this.getCommand("pvp").setExecutor((CommandExecutor)worldGuardCommands);
            this.getCommand("flow").setExecutor((CommandExecutor)worldGuardCommands);
            this.getCommand("break").setExecutor((CommandExecutor)worldGuardCommands);
            this.getCommand("place").setExecutor((CommandExecutor)worldGuardCommands);
            this.getCommand("hunger").setExecutor((CommandExecutor)worldGuardCommands);
            this.getCommand("falldamage").setExecutor((CommandExecutor)worldGuardCommands);
            WorldGuardTabCompleter worldGuardTabCompleter = new WorldGuardTabCompleter();
            this.getCommand("pvp").setTabCompleter((TabCompleter)worldGuardTabCompleter);
            this.getCommand("flow").setTabCompleter((TabCompleter)worldGuardTabCompleter);
            this.getCommand("break").setTabCompleter((TabCompleter)worldGuardTabCompleter);
            this.getCommand("place").setTabCompleter((TabCompleter)worldGuardTabCompleter);
            this.getCommand("hunger").setTabCompleter((TabCompleter)worldGuardTabCompleter);
            this.getCommand("falldamage").setTabCompleter((TabCompleter)worldGuardTabCompleter);
        }
        this.pollCommand = new PollCommand(this);
        this.getCommand("poll").setExecutor((CommandExecutor)this.pollCommand);
        this.getCommand("pollvote").setExecutor((CommandExecutor)new PollVoteCommand(this, this.pollCommand));
        this.getCommand("setspawn").setExecutor((CommandExecutor)new SetterCommands(this));
        this.getCommand("setserver").setExecutor((CommandExecutor)new SetterCommands(this));
        this.getCommand("setevent").setExecutor((CommandExecutor)new SetterCommands(this));
        this.reloadCoreCommand = new ReloadCoreCommand(this);
        this.getCommand("reloadcore").setExecutor((CommandExecutor)this.reloadCoreCommand);
        this.getCommand("theme").setExecutor((CommandExecutor)new ThemeCommand(this));
        this.getCommand("theme").setTabCompleter((TabCompleter)new ThemeTabCompleter(this));
        this.getCommand("emojis").setExecutor((CommandExecutor)new EmojiCommand(this));
        this.getCommand("speed").setExecutor((CommandExecutor)new SpeedCommand(this));
        this.getCommand("speed").setTabCompleter((TabCompleter)new SpeedTabCompleter());
        this.getCommand("broadcast").setExecutor((CommandExecutor)new BroadcastCommand(this));
        this.getCommand("rejoin").setExecutor((CommandExecutor)new RejoinCommand(this));
        this.getCommand("rejoin").setTabCompleter((TabCompleter)new RejoinTabCompleter());
    }

    private void registerListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerEventListener(this, this.hideCommand, this.updateChecker), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerDeathListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new RestrictedCommandsListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BlockEventListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ConfigGUI.ChatInputListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PollChatListener(this, this.pollCommand), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ChatRevivalChatListener(this, this.chatReviveCommand), (Plugin)this);
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public SoundManager getSoundManager() {
        return this.soundManager;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public RankManager getRankManager() {
        return this.rankManager;
    }

    public ScoreboardManager getScoreboardManager() {
        return this.scoreboardManager;
    }

    public TablistManager getTablistManager() {
        return this.tablistManager;
    }

    public ChatManager getChatManager() {
        return this.chatManager;
    }

    public void cancelEventCountdown() {
        if (this.eventCountdownCommand != null) {
            this.eventCountdownCommand.cancelCountdown();
        }
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    public BlockManager getBlockManager() {
        return this.blockManager;
    }

    public VanishManager getVanishManager() {
        return this.vanishManager;
    }

    public PollCommand getPollCommand() {
        return this.pollCommand;
    }

    public ChatReviveCommand getChatReviveCommand() {
        return this.chatReviveCommand;
    }

    public RejoinManager getRejoinManager() {
        return this.rejoinManager;
    }

    public void reloadCore(CommandSender sender) {
        this.reloadCoreCommand.reload(sender);
    }

    public static String translateHexColorCodes(String message) {
        int colorChar = 167;
        Matcher matcher = HEX_PATTERN.matcher(message);
        StringBuffer buffer = new StringBuffer(message.length() + 32);
        while (matcher.find()) {
            String group = matcher.group(1);
            matcher.appendReplacement(buffer, "\u00a7x\u00a7" + group.charAt(0) + "\u00a7" + group.charAt(1) + "\u00a7" + group.charAt(2) + "\u00a7" + group.charAt(3) + "\u00a7" + group.charAt(4) + "\u00a7" + group.charAt(5));
        }
        return matcher.appendTail(buffer).toString();
    }
}

