/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.commands;

import app.qwertz.qwertzcore.QWERTZcore;
import java.util.HashMap;
import java.util.Map;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class AdvertisementCommand
implements CommandExecutor {
    private final QWERTZcore plugin;
    private final Map<String, ChatColor> platformColors;

    public AdvertisementCommand(QWERTZcore plugin) {
        this.plugin = plugin;
        this.platformColors = new HashMap<String, ChatColor>();
        this.initializePlatformColors();
    }

    private void initializePlatformColors() {
        this.platformColors.put("twitch", ChatColor.DARK_PURPLE);
        this.platformColors.put("tiktok", ChatColor.LIGHT_PURPLE);
        this.platformColors.put("youtube", ChatColor.RED);
        this.platformColors.put("discord", ChatColor.BLUE);
        this.platformColors.put("store", ChatColor.GREEN);
        this.platformColors.put("website", ChatColor.YELLOW);
        this.platformColors.put("other", ChatColor.GRAY);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (label.equalsIgnoreCase("ad")) {
            return this.handleAdCommand(sender, args);
        }
        if (label.equalsIgnoreCase("setad")) {
            return this.handleSetAdCommand(sender, args);
        }
        return false;
    }

    private boolean handleAdCommand(CommandSender sender, String[] args) {
        if (args.length != 1) {
            this.plugin.getMessageManager().sendInvalidUsage(sender, "/ad <platform>");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return true;
        }
        String platform = args[0].toLowerCase();
        if (!this.platformColors.containsKey(platform)) {
            this.plugin.getMessageManager().sendMessage(sender, "advertisement.invalid-platform");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return true;
        }
        String adMessage = (String)this.plugin.getConfigManager().get(platform);
        if (adMessage == null || adMessage.isEmpty()) {
            this.plugin.getMessageManager().sendMessage(sender, "advertisement.no-ad-set");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return true;
        }
        String[] parts = adMessage.split(" ");
        StringBuilder messageBuilder = new StringBuilder();
        String link = parts[parts.length - 1];
        if (!link.startsWith("http://") && !link.startsWith("https://")) {
            this.plugin.getMessageManager().sendMessage(sender, "advertisement.invalid-url");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return true;
        }
        for (int i = 0; i < parts.length - 1; ++i) {
            messageBuilder.append(parts[i]).append(" ");
        }
        TextComponent advertisement = new TextComponent();
        TextComponent iconComponent = new TextComponent("\u2747");
        iconComponent.setColor(ChatColor.of((String)"#FF6700"));
        advertisement.addExtra((BaseComponent)iconComponent);
        advertisement.addExtra((BaseComponent)new TextComponent(" "));
        advertisement.addExtra((BaseComponent)new TextComponent(messageBuilder.toString().trim() + " "));
        TextComponent clickableLink = new TextComponent(link);
        clickableLink.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, link));
        clickableLink.setColor(ChatColor.AQUA);
        advertisement.addExtra((BaseComponent)clickableLink);
        ChatColor platformColor = this.platformColors.get(platform);
        String separator = String.valueOf(platformColor) + "-----------------------------------------------------";
        Bukkit.broadcastMessage((String)separator);
        Bukkit.spigot().broadcast((BaseComponent)advertisement);
        Bukkit.broadcastMessage((String)separator);
        this.plugin.getSoundManager().broadcastConfigSound();
        return true;
    }

    private boolean handleSetAdCommand(CommandSender sender, String[] args) {
        if (args.length < 2) {
            this.plugin.getMessageManager().sendInvalidUsage(sender, "/setad <platform> <message>");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return true;
        }
        String platform = args[0].toLowerCase();
        if (!this.platformColors.containsKey(platform)) {
            this.plugin.getMessageManager().sendMessage(sender, "advertisement.invalid-platform");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return true;
        }
        String message = String.join((CharSequence)" ", args).substring(platform.length() + 1);
        this.plugin.getConfigManager().set(platform, message);
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%platform%", platform);
        this.plugin.getMessageManager().sendMessage(sender, "advertisement.setad-success", localMap);
        this.plugin.getSoundManager().playSoundToSender(sender);
        return true;
    }
}

