/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.commands;

import app.qwertz.qwertzcore.QWERTZcore;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.PlayerInventory;

public class ClearInventoryCommand
implements CommandExecutor {
    private final QWERTZcore plugin;

    public ClearInventoryCommand(QWERTZcore plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        boolean clearAlive = label.equalsIgnoreCase("clearalive");
        int clearedCount = 0;
        for (Player player : Bukkit.getOnlinePlayers()) {
            boolean isDead = this.plugin.getEventManager().isPlayerDead(player);
            if ((!clearAlive || isDead) && (clearAlive || !isDead)) continue;
            this.clearPlayerInventory(player);
            this.plugin.getMessageManager().sendMessage(player, "clearinv.got-cleared");
            this.plugin.getSoundManager().playSound(player);
            ++clearedCount;
        }
        String playerType = clearAlive ? "alive" : "dead";
        String playerTypeColor = clearAlive ? "%colorAlive%" : "%colorDead%";
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%amount%", String.valueOf(clearedCount));
        localMap.put("%group%", playerType);
        localMap.put("%groupColor%", playerTypeColor);
        this.plugin.getMessageManager().broadcastMessage("clearinv.broadcast", localMap);
        this.plugin.getSoundManager().broadcastConfigSound();
        return true;
    }

    private void clearPlayerInventory(Player player) {
        PlayerInventory inventory = player.getInventory();
        inventory.clear();
        player.setItemOnCursor(null);
        player.getOpenInventory();
        Inventory topInventory = player.getOpenInventory().getTopInventory();
        topInventory.clear();
    }
}

