/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.commands;

import app.qwertz.qwertzcore.QWERTZcore;
import app.qwertz.qwertzcore.blocks.QWERTZcoreBlockType;
import java.util.Arrays;
import java.util.HashMap;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class EventBlockCommand
implements CommandExecutor {
    private final QWERTZcore plugin;

    public EventBlockCommand(QWERTZcore plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            this.plugin.getMessageManager().sendMessage(sender, "general.only-player-execute");
            return true;
        }
        HashMap<String, String> localMap = new HashMap<String, String>();
        String types = Arrays.toString((Object[])QWERTZcoreBlockType.values());
        localMap.put("%types%", types);
        Player player = (Player)sender;
        if (args.length < 1) {
            this.plugin.getMessageManager().sendInvalidUsage(player, "/eventblock <blocktype> [material]");
            this.plugin.getMessageManager().sendMessage(player, "specialblocks.info", localMap);
            this.plugin.getSoundManager().playSound(player);
            return true;
        }
        String blockType = args[0].toUpperCase();
        Material material = null;
        if (!(args.length <= 1 || (material = Material.matchMaterial((String)args[1])) != null && material.isBlock())) {
            this.plugin.getMessageManager().sendMessage(player, "specialblocks.invalid-material");
            this.plugin.getSoundManager().playSound(player);
            return true;
        }
        if (!this.plugin.getBlockManager().isValidBlockType(blockType)) {
            this.plugin.getMessageManager().sendMessage(player, "specialblocks.invalid-type", localMap);
            this.plugin.getSoundManager().playSound(player);
            return true;
        }
        ItemStack item = new ItemStack(material != null ? material : QWERTZcoreBlockType.valueOf(blockType).getDefaultMaterial());
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(QWERTZcore.CORE_ICON + String.valueOf(ChatColor.GOLD) + " QWERTZ Core " + blockType);
            meta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + "Place this block to create a special event block!"));
            item.setItemMeta(meta);
            player.getInventory().addItem(new ItemStack[]{item});
            this.plugin.getSoundManager().playSound(player);
            HashMap<String, String> localMap2 = new HashMap<String, String>();
            localMap2.put("%blockType%", blockType);
            localMap2.put("%material%", item.getType().name());
            this.plugin.getMessageManager().sendMessage(player, "specialblocks.receive", localMap2);
        }
        return true;
    }
}

