/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.commands;

import app.qwertz.qwertzcore.QWERTZcore;
import java.util.HashMap;
import org.bukkit.GameMode;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class GamemodeCommand
implements CommandExecutor {
    private final QWERTZcore plugin;

    public GamemodeCommand(QWERTZcore plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        GameMode targetGameMode;
        if (!(sender instanceof Player)) {
            this.plugin.getMessageManager().sendMessage(sender, "general.only-player-execute");
            return true;
        }
        Player player = (Player)sender;
        switch (command.getName().toLowerCase()) {
            case "gmc": {
                targetGameMode = GameMode.CREATIVE;
                break;
            }
            case "gms": {
                targetGameMode = GameMode.SURVIVAL;
                break;
            }
            case "gmsp": {
                targetGameMode = GameMode.SPECTATOR;
                break;
            }
            case "gma": {
                targetGameMode = GameMode.ADVENTURE;
                break;
            }
            case "gm": {
                if (args.length == 0) {
                    this.plugin.getMessageManager().sendInvalidUsage(sender, "/gm <creative|survival|adventure|spectator>");
                    this.plugin.getSoundManager().playSoundToSender(sender);
                    return false;
                }
                targetGameMode = this.parseGameMode(args[0]);
                if (targetGameMode != null) break;
                this.plugin.getMessageManager().sendMessage(sender, "gamemode.invalid");
                this.plugin.getSoundManager().playSoundToSender(sender);
                return false;
            }
            default: {
                return false;
            }
        }
        player.setGameMode(targetGameMode);
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%gamemode%", targetGameMode.name());
        this.plugin.getMessageManager().sendMessage(player, "gamemode.success", localMap);
        this.plugin.getSoundManager().playSound(player);
        return true;
    }

    private GameMode parseGameMode(String mode) {
        switch (mode.toLowerCase()) {
            case "1": 
            case "c": 
            case "creative": {
                return GameMode.CREATIVE;
            }
            case "0": 
            case "s": 
            case "survival": {
                return GameMode.SURVIVAL;
            }
            case "2": 
            case "a": 
            case "adventure": {
                return GameMode.ADVENTURE;
            }
            case "3": 
            case "sp": 
            case "spectator": {
                return GameMode.SPECTATOR;
            }
        }
        return null;
    }
}

