/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.commands;

import app.qwertz.qwertzcore.QWERTZcore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class KitCommand
implements CommandExecutor {
    private final QWERTZcore plugin;

    public KitCommand(QWERTZcore plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            this.plugin.getMessageManager().sendMessage(sender, "general.only-player-execute");
            return true;
        }
        Player player = (Player)sender;
        if (label.equalsIgnoreCase("createkit")) {
            if (args.length != 1) {
                this.plugin.getMessageManager().sendInvalidUsage(player, "/createkit <kitname>");
                this.plugin.getSoundManager().playSound(player);
                return true;
            }
            this.createKit(player, args[0]);
        } else if (label.equalsIgnoreCase("kit")) {
            if (args.length != 2) {
                this.plugin.getMessageManager().sendInvalidUsage(player, "/kit <kitname> <player|alive|dead|all>");
                this.plugin.getSoundManager().playSound(player);
                return true;
            }
            this.giveKit(player, args[0], args[1]);
        } else if (label.equalsIgnoreCase("delkit")) {
            if (args.length != 1) {
                this.plugin.getMessageManager().sendInvalidUsage(player, "/delkit <kitname>");
                this.plugin.getSoundManager().playSound(player);
                return true;
            }
            this.deleteKit(player, args[0]);
        } else if (label.equalsIgnoreCase("kits")) {
            this.listKits(player);
        }
        return true;
    }

    private void createKit(Player player, String kitName) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ItemStack item : player.getInventory().getContents()) {
            items.add(item != null ? item.clone() : null);
        }
        for (ItemStack item : player.getInventory().getArmorContents()) {
            items.add(item != null ? item.clone() : null);
        }
        items.add(player.getInventory().getItemInOffHand().clone());
        this.plugin.getConfigManager().saveKit(kitName, items);
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%name%", kitName);
        this.plugin.getMessageManager().sendMessage(player, "kit.created", localMap);
        this.plugin.getSoundManager().playSound(player);
    }

    private void giveKit(Player sender, String kitName, String target) {
        List<ItemStack> items = this.plugin.getConfigManager().getKit(kitName);
        if (items == null) {
            HashMap<String, String> localMap = new HashMap<String, String>();
            localMap.put("%name%", kitName);
            this.plugin.getMessageManager().sendMessage(sender, "kit.nonexistent", localMap);
            this.plugin.getSoundManager().playSoundToSender((CommandSender)sender);
            return;
        }
        ArrayList<Player> targetPlayers = new ArrayList<Player>();
        switch (target.toLowerCase()) {
            case "alive": {
                Player player;
                for (UUID uuid : this.plugin.getEventManager().getAlivePlayers()) {
                    player = Bukkit.getPlayer((UUID)uuid);
                    if (player == null) continue;
                    targetPlayers.add(player);
                }
                break;
            }
            case "dead": {
                Player player;
                for (UUID uuid : this.plugin.getEventManager().getDeadPlayers()) {
                    player = Bukkit.getPlayer((UUID)uuid);
                    if (player == null) continue;
                    targetPlayers.add(player);
                }
                break;
            }
            case "all": {
                targetPlayers.addAll(Bukkit.getOnlinePlayers());
                break;
            }
            default: {
                Player targetPlayer = Bukkit.getPlayer((String)target);
                if (targetPlayer != null) {
                    targetPlayers.add(targetPlayer);
                    break;
                }
                this.plugin.getMessageManager().sendMessage(sender, "general.player-not-found");
                this.plugin.getSoundManager().playSoundToSender((CommandSender)sender);
                return;
            }
        }
        for (Player targetPlayer : targetPlayers) {
            targetPlayer.getInventory().clear();
            for (int i = 0; i < 36 && i < items.size(); ++i) {
                if (items.get(i) == null) continue;
                targetPlayer.getInventory().setItem(i, items.get(i).clone());
            }
            if (items.size() > 36) {
                ItemStack[] armorContents = new ItemStack[4];
                for (int i = 0; i < 4 && i + 36 < items.size(); ++i) {
                    armorContents[i] = items.get(i + 36) != null ? items.get(i + 36).clone() : null;
                }
                targetPlayer.getInventory().setArmorContents(armorContents);
            }
            if (items.size() > 40) {
                targetPlayer.getInventory().setItemInOffHand(items.get(40) != null ? items.get(40).clone() : null);
            }
            HashMap<String, String> localMap = new HashMap<String, String>();
            localMap.put("%name%", kitName);
            this.plugin.getMessageManager().sendMessage(targetPlayer, "kit.received", localMap);
            this.plugin.getSoundManager().playSound(targetPlayer);
        }
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%name%", kitName);
        localMap.put("%amount%", String.valueOf(targetPlayers.size()));
        this.plugin.getMessageManager().broadcastMessage("kit.broadcast", localMap);
        this.plugin.getSoundManager().broadcastConfigSound();
    }

    private void deleteKit(Player player, String kitName) {
        if (this.plugin.getConfigManager().getKit(kitName) == null) {
            HashMap<String, String> localMap = new HashMap<String, String>();
            localMap.put("%name%", kitName);
            this.plugin.getMessageManager().sendMessage(player, "kit.nonexistent", localMap);
            this.plugin.getSoundManager().playSound(player);
            return;
        }
        this.plugin.getConfigManager().deleteKit(kitName);
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%name%", kitName);
        this.plugin.getMessageManager().sendMessage(player, "kit.deleted", localMap);
        this.plugin.getSoundManager().playSound(player);
    }

    private void listKits(Player player) {
        Set<String> kitNames = this.plugin.getConfigManager().getKitNames();
        if (kitNames.isEmpty()) {
            this.plugin.getMessageManager().sendMessage(player, "kit.no-kits");
            this.plugin.getSoundManager().playSound(player);
        } else {
            HashMap<String, String> localMap = new HashMap<String, String>();
            localMap.put("%list%", String.join((CharSequence)", ", kitNames));
            this.plugin.getMessageManager().sendMessage(player, "kit.list", localMap);
            this.plugin.getSoundManager().playSound(player);
        }
    }
}

