/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.commands;

import app.qwertz.qwertzcore.QWERTZcore;
import app.qwertz.qwertzcore.gui.PollGUI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PollCommand
implements CommandExecutor {
    private final QWERTZcore plugin;
    private Map<UUID, Integer> votes;
    private List<String> options;
    private String question;
    private boolean pollActive = false;
    private Map<UUID, PollCreationState> playerStates = new HashMap<UUID, PollCreationState>();
    private Map<UUID, String> playerQuestions = new HashMap<UUID, String>();
    private Map<UUID, Integer> playerDurations = new HashMap<UUID, Integer>();
    private Map<UUID, List<String>> playerOptions = new HashMap<UUID, List<String>>();

    public PollCommand(QWERTZcore plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        int duration;
        if (!(sender instanceof Player)) {
            this.plugin.getMessageManager().sendMessage(sender, "general.only-player-execute");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.createPollGUI(player).open();
            return true;
        }
        if (args.length < 2 || args.length == 3) {
            this.plugin.getMessageManager().sendInvalidUsage(sender, " /poll <duration> <question> [<answer1> <answer2>] [answer3] ...");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return true;
        }
        if (this.pollActive) {
            this.plugin.getMessageManager().sendMessage(sender, "poll.already-active");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return true;
        }
        try {
            duration = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            this.plugin.getMessageManager().sendMessage(sender, "poll.invalid-duration");
            this.plugin.getSoundManager().playSoundToSender(sender);
            return true;
        }
        this.question = args[1].replace("-", " ");
        this.options = new ArrayList<String>();
        for (int i = 2; i < args.length; ++i) {
            this.options.add(args[i].replace("-", " "));
        }
        this.createPoll(player, duration, this.question, this.options);
        return true;
    }

    public void createPollFromGUI(Player player, int duration, String question, List<String> options) {
        if (this.pollActive) {
            this.plugin.getMessageManager().sendMessage(player, "poll.already-active");
            this.plugin.getSoundManager().playSoundToSender((CommandSender)player);
            return;
        }
        this.createPoll(player, duration, question, options);
    }

    public void setPlayerState(UUID playerId, PollCreationState state) {
        this.playerStates.put(playerId, state);
    }

    public PollCreationState getPlayerState(UUID playerId) {
        return this.playerStates.getOrDefault(playerId, PollCreationState.QUESTION);
    }

    public void setPlayerQuestion(UUID playerId, String question) {
        this.playerQuestions.put(playerId, question);
    }

    public String getPlayerQuestion(UUID playerId) {
        return this.playerQuestions.getOrDefault(playerId, "");
    }

    public void setPlayerDuration(UUID playerId, int duration) {
        this.playerDurations.put(playerId, duration);
    }

    public int getPlayerDuration(UUID playerId) {
        return this.playerDurations.getOrDefault(playerId, 30);
    }

    public void setPlayerOptions(UUID playerId, List<String> options) {
        this.playerOptions.put(playerId, new ArrayList<String>(options));
    }

    public List<String> getPlayerOptions(UUID playerId) {
        return this.playerOptions.getOrDefault(playerId, new ArrayList());
    }

    public void clearPlayerState(UUID playerId) {
        this.playerStates.remove(playerId);
        this.playerQuestions.remove(playerId);
        this.playerDurations.remove(playerId);
        this.playerOptions.remove(playerId);
    }

    public PollGUI createPollGUI(Player player) {
        return new PollGUI(this.plugin, player, this);
    }

    private void createPoll(Player player, int duration, String question, List<String> options) {
        this.question = question;
        this.options = options;
        this.votes = new HashMap<UUID, Integer>();
        this.pollActive = true;
        this.displayPoll();
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, this::endPoll, (long)duration * 20L);
    }

    private void displayPoll() {
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%question%", this.question);
        Bukkit.broadcastMessage((String)this.plugin.getMessageManager().prepareMessage(this.plugin.getMessageManager().getMessage("poll.new-poll"), localMap));
        Bukkit.broadcastMessage((String)"");
        for (int i = 0; i < this.options.size(); ++i) {
            HashMap<String, String> tempMap = new HashMap<String, String>();
            tempMap.put("%index%", String.valueOf(i + 1));
            tempMap.put("%option%", this.options.get(i));
            TextComponent message = new TextComponent(this.plugin.getMessageManager().prepareMessage(this.plugin.getMessageManager().getMessage("poll.option"), tempMap));
            message.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/pollvote " + i));
            message.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(this.plugin.getMessageManager().prepareMessage(this.plugin.getMessageManager().getMessage("poll.hover"), new HashMap<String, String>())).create()));
            Bukkit.spigot().broadcast((BaseComponent)message);
        }
        Bukkit.broadcastMessage((String)"");
        Bukkit.broadcastMessage((String)this.plugin.getMessageManager().prepareMessage(this.plugin.getMessageManager().getMessage("poll.click-to-vote"), new HashMap<String, String>()));
        Bukkit.broadcastMessage((String)"");
        this.plugin.getSoundManager().broadcastConfigSound();
    }

    private void endPoll() {
        this.pollActive = false;
        this.plugin.getSoundManager().broadcastConfigSound();
        Bukkit.broadcastMessage((String)this.plugin.getMessageManager().prepareMessage(this.plugin.getMessageManager().getMessage("poll.result-title"), new HashMap<String, String>()));
        Bukkit.broadcastMessage((String)"");
        Map<Integer, Long> voteCount = this.votes.values().stream().collect(Collectors.groupingBy(i -> i, Collectors.counting()));
        List sortedResults = voteCount.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toList());
        for (Map.Entry entry : sortedResults) {
            int optionIndex = (Integer)entry.getKey();
            long count = (Long)entry.getValue();
            HashMap<String, String> localMap = new HashMap<String, String>();
            localMap.put("%index%", String.valueOf(optionIndex + 1));
            localMap.put("%option%", this.options.get(optionIndex));
            localMap.put("%amount%", String.valueOf(count));
            Bukkit.broadcastMessage((String)this.plugin.getMessageManager().prepareMessage(this.plugin.getMessageManager().getMessage("poll.result-option"), localMap));
        }
        Bukkit.broadcastMessage((String)"");
    }

    public void vote(Player player, int option) {
        if (!this.pollActive) {
            this.plugin.getMessageManager().sendMessage(player, "poll.no-active-poll");
            this.plugin.getSoundManager().playSound(player);
            return;
        }
        if (option < 0 || option >= this.options.size()) {
            this.plugin.getMessageManager().sendMessage(player, "poll.invalid-option");
            this.plugin.getSoundManager().playSound(player);
            return;
        }
        this.votes.put(player.getUniqueId(), option);
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%option%", this.options.get(option));
        this.plugin.getMessageManager().sendMessage(player, "poll.vote-success", localMap);
        this.plugin.getSoundManager().playSound(player);
    }

    public static enum PollCreationState {
        QUESTION,
        DURATION,
        OPTIONS;

    }
}

