/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.commands;

import app.qwertz.qwertzcore.QWERTZcore;
import java.util.HashMap;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SpeedCommand
implements CommandExecutor {
    private final QWERTZcore plugin;

    public SpeedCommand(QWERTZcore plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        int speed;
        if (!(sender instanceof Player)) {
            this.plugin.getMessageManager().sendMessage(sender, "general.only-player-execute");
            return true;
        }
        Player player = (Player)sender;
        if (args.length != 1) {
            this.plugin.getMessageManager().sendInvalidUsage(sender, "/speed <speed>");
            return true;
        }
        try {
            speed = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            this.plugin.getMessageManager().sendMessage(sender, "configgui.invalid-number");
            return true;
        }
        if (speed < 1 || speed > 10) {
            this.plugin.getMessageManager().sendMessage(sender, "speed.out-of-range");
            return true;
        }
        float speedValue = (float)speed / 10.0f;
        player.setWalkSpeed(speedValue);
        player.setFlySpeed(speedValue);
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%speed%", String.valueOf(speed));
        this.plugin.getMessageManager().sendMessage(sender, "speed.changed", localMap);
        return true;
    }
}

