/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.commands;

import app.qwertz.qwertzcore.QWERTZcore;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class WarpCommands
implements CommandExecutor {
    private final QWERTZcore plugin;
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private final Map<UUID, BukkitTask> pendingTeleports = new HashMap<UUID, BukkitTask>();

    public WarpCommands(QWERTZcore plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            this.plugin.getMessageManager().sendMessage(sender, "general.only-player-execute");
            return true;
        }
        Player player = (Player)sender;
        switch (label.toLowerCase()) {
            case "setwarp": {
                return this.handleSetWarp(player, args);
            }
            case "warp": {
                return this.handleWarp(player, args);
            }
            case "delwarp": {
                return this.handleDelWarp(player, args);
            }
            case "warps": 
            case "listwarps": {
                return this.handleWarps(player);
            }
        }
        return false;
    }

    private boolean handleSetWarp(Player player, String[] args) {
        if (!player.hasPermission("qwertzcore.setwarp")) {
            this.plugin.getMessageManager().sendMessage(player, "warps.cannot-set");
            this.plugin.getSoundManager().playSound(player);
            return true;
        }
        if (args.length != 1) {
            this.plugin.getMessageManager().sendInvalidUsage(player, "/setwarp <name>");
            this.plugin.getSoundManager().playSound(player);
            return true;
        }
        String warpName = args[0].toLowerCase();
        Location location = player.getLocation();
        this.plugin.getConfigManager().addWarp(warpName, location);
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%warp%", warpName);
        this.plugin.getMessageManager().sendMessage(player, "warps.set", localMap);
        this.plugin.getSoundManager().playSound(player);
        return true;
    }

    private boolean handleWarp(Player player, String[] args) {
        if (args.length != 1) {
            this.plugin.getMessageManager().sendInvalidUsage(player, "/warp <name>");
            this.plugin.getSoundManager().playSound(player);
            return true;
        }
        String warpName = args[0].toLowerCase();
        Location warpLocation = this.plugin.getConfigManager().getWarp(warpName);
        if (warpLocation == null) {
            HashMap<String, String> localMap = new HashMap<String, String>();
            localMap.put("%warp%", warpName);
            this.plugin.getMessageManager().sendMessage(player, "warps.nonexistent", localMap);
            this.plugin.getSoundManager().playSound(player);
            return true;
        }
        UUID playerUUID = player.getUniqueId();
        if (this.plugin.getEventManager().isPlayerDead(player)) {
            this.teleportToWarp(player, warpLocation, false);
        } else {
            long currentTime = System.currentTimeMillis();
            if (this.cooldowns.containsKey(playerUUID) && currentTime - this.cooldowns.get(playerUUID) < 10000L) {
                this.teleportToWarp(player, warpLocation, true);
                this.cooldowns.remove(playerUUID);
                if (this.pendingTeleports.containsKey(playerUUID)) {
                    this.pendingTeleports.get(playerUUID).cancel();
                    this.pendingTeleports.remove(playerUUID);
                }
            } else {
                player.sendTitle(this.plugin.getMessageManager().prepareMessage(this.plugin.getMessageManager().getMessage("warps.alive-title.title"), new HashMap<String, String>()), this.plugin.getMessageManager().prepareMessage(this.plugin.getMessageManager().getMessage("warps.alive-title.subtitle"), new HashMap<String, String>()), 10, 70, 20);
                this.plugin.getMessageManager().sendMessage(player, "warps.alive-message");
                this.plugin.getSoundManager().playSound(player);
                this.cooldowns.put(playerUUID, currentTime);
                BukkitTask task = this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                    this.cooldowns.remove(playerUUID);
                    this.pendingTeleports.remove(playerUUID);
                }, 200L);
                this.pendingTeleports.put(playerUUID, task);
            }
        }
        return true;
    }

    private boolean handleDelWarp(Player player, String[] args) {
        if (!player.hasPermission("qwertzcore.delwarp")) {
            this.plugin.getMessageManager().sendMessage(player, "warps.cannot-delete");
            this.plugin.getSoundManager().playSound(player);
            return true;
        }
        if (args.length != 1) {
            this.plugin.getMessageManager().sendInvalidUsage(player, "/delwarp <name>");
            this.plugin.getSoundManager().playSound(player);
            return true;
        }
        String warpName = args[0].toLowerCase();
        if (this.plugin.getConfigManager().getWarp(warpName) == null) {
            HashMap<String, String> localMap = new HashMap<String, String>();
            localMap.put("%warp%", warpName);
            this.plugin.getMessageManager().sendMessage(player, "warps.nonexistent", localMap);
            this.plugin.getSoundManager().playSound(player);
            return true;
        }
        this.plugin.getConfigManager().removeWarp(warpName);
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%warp%", warpName);
        this.plugin.getMessageManager().sendMessage(player, "warps.delete", localMap);
        this.plugin.getSoundManager().playSound(player);
        return true;
    }

    private boolean handleWarps(Player player) {
        Set<String> warpNames = this.plugin.getConfigManager().getWarpNames();
        if (warpNames.isEmpty()) {
            this.plugin.getMessageManager().sendMessage(player, "warps.no-warps");
            this.plugin.getSoundManager().playSound(player);
        } else {
            HashMap<String, String> localMap = new HashMap<String, String>();
            localMap.put("%list%", String.join((CharSequence)", ", warpNames));
            this.plugin.getMessageManager().sendMessage(player, "warps.list", localMap);
            this.plugin.getSoundManager().playSound(player);
        }
        return true;
    }

    private void unrevivePlayer(Player player) {
        this.plugin.getEventManager().handlePlayerDeath(player, true);
        this.plugin.getMessageManager().sendMessage(player, "warps.warp-while-alive");
        this.plugin.getSoundManager().playSound(player);
    }

    private void teleportToWarp(Player player, Location location, boolean wasAlive) {
        player.teleport(location);
        this.plugin.getMessageManager().sendMessage(player, "warps.success");
        this.plugin.getSoundManager().playSound(player);
        if (wasAlive) {
            this.unrevivePlayer(player);
        }
    }
}

