/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.gui;

import app.qwertz.qwertzcore.QWERTZcore;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;

public class ConfigGUI
implements Listener {
    private static final UUID RANDOM_UUID = UUID.fromString("92864445-51c5-4c3b-9039-517c9927d1b4");
    private static final String LEFT_ARROW_URL = "http://textures.minecraft.net/texture/a2f0425d64fdc8992928d608109810c1251fe243d60d175bed427c651cbe";
    private static final String RIGHT_ARROW_URL = "http://textures.minecraft.net/texture/6d865aae2746a9b8e9a4fe629fb08d18d0a9251e5ccbe5fa7051f53eab9b94";
    private static final Map<UUID, PendingInput> pendingInputs = new HashMap<UUID, PendingInput>();
    private final QWERTZcore plugin;
    private final Player player;
    private int page;
    private Inventory inventory;

    public ConfigGUI(QWERTZcore plugin, Player player, int page) {
        this.plugin = plugin;
        this.player = player;
        this.page = page;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.inventory = this.buildGUI();
    }

    public void open() {
        this.player.openInventory(this.inventory);
    }

    private Inventory buildGUI() {
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)"Config Editor");
        ItemStack pearl = this.createItem(Material.ENDER_PEARL, "\u00a7bConfig Menu");
        this.fillRow(gui, 0, pearl);
        this.fillRow(gui, 5, pearl);
        this.setupNavigation(gui);
        this.setupConfigItems(gui);
        return gui;
    }

    private void setupNavigation(Inventory gui) {
        boolean hasNext;
        boolean hasPrevious = this.page > 0;
        boolean bl = hasNext = this.page < (int)Math.ceil((double)this.plugin.getConfigManager().getKeys().size() / 5.0) - 1;
        if (hasPrevious) {
            gui.setItem(18, this.createSkull(LEFT_ARROW_URL, "\u00a7aPrevious Page"));
            gui.setItem(27, this.createSkull(LEFT_ARROW_URL, "\u00a7aPrevious Page"));
        } else {
            gui.setItem(18, null);
            gui.setItem(27, null);
        }
        if (hasNext) {
            gui.setItem(26, this.createSkull(RIGHT_ARROW_URL, "\u00a7aNext Page"));
            gui.setItem(35, this.createSkull(RIGHT_ARROW_URL, "\u00a7aNext Page"));
        } else {
            gui.setItem(26, null);
            gui.setItem(35, null);
        }
    }

    private void setupConfigItems(Inventory gui) {
        int index;
        int i;
        int[] keySlots = new int[]{20, 21, 22, 23, 24};
        int[] valueSlots = new int[]{29, 30, 31, 32, 33};
        ArrayList<String> keys = new ArrayList<String>(this.plugin.getConfigManager().getKeys());
        for (i = 0; i < 5; ++i) {
            if (keySlots.length <= i) continue;
            gui.setItem(keySlots[i], null);
            gui.setItem(valueSlots[i], null);
        }
        for (i = 0; i < 5 && (index = this.page * 5 + i) < keys.size(); ++i) {
            String key = (String)keys.get(index);
            Object value = this.plugin.getConfigManager().get(key);
            gui.setItem(keySlots[i], this.createKeyItem(key));
            gui.setItem(valueSlots[i], this.createValueItem(key, value));
        }
    }

    private void handleNavigationClick(int slot) {
        if ((slot == 18 || slot == 27) && this.page > 0) {
            --this.page;
            this.updateGUI();
        } else if ((slot == 26 || slot == 35) && this.page < (int)Math.ceil((double)this.plugin.getConfigManager().getKeys().size() / 5.0) - 1) {
            ++this.page;
            this.updateGUI();
        }
    }

    private void updateGUI() {
        this.setupNavigation(this.inventory);
        this.setupConfigItems(this.inventory);
        this.player.updateInventory();
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getView().getTitle().equals("Config Editor") && event.getInventory().equals((Object)this.inventory)) {
            event.setCancelled(true);
            if (!(event.getWhoClicked() instanceof Player)) {
                return;
            }
            ItemStack item = event.getCurrentItem();
            if (item == null) {
                return;
            }
            this.handleEnderPearlAnimation(this.inventory);
            this.handleNavigationClick(event.getSlot());
            this.handleConfigItemClick(event.getSlot());
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getView().getTitle().equals("Config Editor") && event.getInventory().equals((Object)this.inventory)) {
            ConfigGUI.unregister(this);
        }
    }

    public static void unregister(ConfigGUI gui) {
        HandlerList.unregisterAll((Listener)gui);
    }

    private void handleConfigItemClick(int slot) {
        int[] valueSlots = new int[]{29, 30, 31, 32, 33};
        for (int i = 0; i < valueSlots.length; ++i) {
            if (slot != valueSlots[i]) continue;
            int keyIndex = this.page * 5 + i;
            ArrayList<String> keys = new ArrayList<String>(this.plugin.getConfigManager().getKeys());
            if (keyIndex >= keys.size()) {
                return;
            }
            String key = (String)keys.get(keyIndex);
            Object value = this.plugin.getConfigManager().get(key);
            if (value instanceof Boolean) {
                this.plugin.getConfigManager().set(key, (Boolean)value == false);
                this.plugin.getConfigManager().saveConfig();
                this.updateGUI();
                continue;
            }
            if (value instanceof Number || value instanceof String) {
                this.promptForInput(key);
                continue;
            }
            this.plugin.getMessageManager().sendMessage(this.player, "configgui.unsupported-type");
        }
    }

    private void promptForInput(String key) {
        this.player.closeInventory();
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%key%", key);
        this.plugin.getMessageManager().sendMessage(this.player, "configgui.enter-new-value", localMap);
        pendingInputs.put(this.player.getUniqueId(), new PendingInput(key, this.page));
    }

    private ItemStack createKeyItem(String key) {
        Material mat = switch (key.toLowerCase()) {
            case "spawn" -> Material.COMPASS;
            case "sound", "soundvolume", "soundpitch", "soundeffect" -> Material.NOTE_BLOCK;
            case "server", "event" -> Material.NAME_TAG;
            case "specialblockoutput" -> Material.COMMAND_BLOCK;
            case "suppressvanilla" -> Material.LAVA_BUCKET;
            case "doscoreboard", "dotablist", "dochat" -> Material.WRITTEN_BOOK;
            case "biggermessages" -> Material.STICKY_PISTON;
            case "revivetokensenabled", "revivestaff" -> Material.HEART_OF_THE_SEA;
            case "joinleavemsgsonvanish" -> Material.SPECTRAL_ARROW;
            case "chat" -> Material.ENCHANTED_BOOK;
            case "allowrejoining" -> Material.REPEATING_COMMAND_BLOCK;
            case "rejointime" -> Material.CLOCK;
            default -> Material.PAPER;
        };
        ItemStack item = switch (key.toLowerCase()) {
            case "server", "event" -> this.createSkull("http://textures.minecraft.net/texture/622872342d2cf20754b9e1bae9c0902912dcae12e63b520b6fe8bd911b91018b", "");
            case "youtube" -> this.createSkull("http://textures.minecraft.net/texture/103b1bb8452626fa9ed6b8b756561df7ad5e98eea1fa4386b48f196469e9e2", "");
            case "tiktok" -> this.createSkull("http://textures.minecraft.net/texture/bcf2105bb737638833033dd8244071e75870e2e11c2617e542e8924fb2b90180", "");
            case "other" -> this.createSkull("http://textures.minecraft.net/texture/46ba63344f49dd1c4f5488e926bf3d9e2b29916a6c50d610bb40a5273dc8c82", "");
            case "website" -> this.createSkull("http://textures.minecraft.net/texture/16439d2e306b225516aa9a6d007a7e75edd2d5015d113b42f44be62a517e574f", "");
            case "twitch" -> this.createSkull("http://textures.minecraft.net/texture/8028a09221f50145165c4a3435e5fc0469fde0ec93e3dd10a92f1ba0c811feae", "");
            case "discord" -> this.createSkull("http://textures.minecraft.net/texture/ad833b51566565658f9011de8784e90c1ad9ba5d3337f8c069213bbdee986523", "");
            case "store" -> this.createSkull("http://textures.minecraft.net/texture/c9487f33f5500d1ed50a05818c26aeffb314edddcac6815996dfa2692a182cfc", "");
            case "tponjoin" -> this.createSkull("http://textures.minecraft.net/texture/cbfb41f866e7e8e593659986c9d6e88cd37677b3f7bd44253e5871e66d1d424", "");
            case "tponrevive" -> this.createSkull("http://textures.minecraft.net/texture/32fa8f38c7b22096619c3a6d6498b405530e48d5d4f91e2aacea578844d5c67", "");
            case "tponunrevive" -> this.createSkull("http://textures.minecraft.net/texture/faff2eb498e5c6a04484f0c9f785b448479ab213df95ec91176a308a12add70", "");
            case "tpondeath" -> this.createSkull("http://textures.minecraft.net/texture/14d844fee24d5f27ddb669438528d83b684d901b75a6889fe7488dfc4cf7a1c", "");
            case "checkforupdates" -> this.createSkull("http://textures.minecraft.net/texture/9cdb8f43656c06c4e8683e2e6341b4479f157f48082fea4aff09b37ca3c6995b", "");
            case "emojis" -> this.createSkull("http://textures.minecraft.net/texture/de4e994eacf90b60ee87b10c50acb80dd1daf9ee6f2c63a79b01154b16dcf0cf", "");
            case "chattimer" -> this.createSkull("http://textures.minecraft.net/texture/dbcb230a410e93b7d4b5c289631d614b90453843d6ed03daf5e4015a2fe1f56b", "");
            case "coloredchat" -> this.createSkull("http://textures.minecraft.net/texture/f4e94273c727b1f2c9376b5cae4ed9a48d5851bd2ab2fd83d5f81a6e6aff193d", "");
            default -> new ItemStack(mat);
        };
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName("\u00a7e" + key);
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createValueItem(String key, Object value) {
        Material mat = Material.BARRIER;
        Object name = "\u00a7cUnsupported Type";
        if (value instanceof Boolean) {
            mat = (Boolean)value != false ? Material.LIME_WOOL : Material.RED_WOOL;
            name = (Boolean)value != false ? "\u00a7aTrue" : "\u00a7cFalse";
        } else if (value instanceof Number) {
            mat = Material.OAK_SIGN;
            name = "\u00a7b" + String.valueOf(value);
        } else if (value instanceof String) {
            mat = Material.NAME_TAG;
            name = "\u00a7f" + String.valueOf(value);
        }
        ItemStack item = new ItemStack(mat);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName((String)name);
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createSkull(String textureUrl, String name) {
        ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)skull.getItemMeta();
        PlayerProfile profile = Bukkit.createPlayerProfile((UUID)RANDOM_UUID);
        PlayerTextures textures = profile.getTextures();
        try {
            textures.setSkin(new URL(textureUrl));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Invalid texture URL", e);
        }
        profile.setTextures(textures);
        meta.setOwnerProfile(profile);
        meta.setDisplayName(name);
        skull.setItemMeta((ItemMeta)meta);
        return skull;
    }

    private void handleEnderPearlAnimation(Inventory inv) {
        ItemStack eye = this.createItem(Material.ENDER_EYE, "\u00a7bConfig Menu");
        for (int i = 0; i < 9; ++i) {
            inv.setItem(i, eye);
            inv.setItem(i + 45, eye);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            ItemStack pearl = this.createItem(Material.ENDER_PEARL, "\u00a7bConfig Menu");
            for (int i = 0; i < 9; ++i) {
                inv.setItem(i, pearl);
                inv.setItem(i + 45, pearl);
            }
        }, 20L);
    }

    private void fillRow(Inventory inv, int row, ItemStack item) {
        for (int i = 0; i < 9; ++i) {
            inv.setItem(row * 9 + i, item);
        }
    }

    private ItemStack createItem(Material mat, String name) {
        ItemStack item = new ItemStack(mat);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        item.setItemMeta(meta);
        return item;
    }

    private static class PendingInput {
        final String key;
        final int page;

        PendingInput(String key, int page) {
            this.key = key;
            this.page = page;
        }
    }

    public static class ChatInputListener
    implements Listener {
        private final QWERTZcore plugin;

        public ChatInputListener(QWERTZcore plugin) {
            this.plugin = plugin;
        }

        @EventHandler
        public void onChat(AsyncPlayerChatEvent event) {
            UUID uuid = event.getPlayer().getUniqueId();
            if (!pendingInputs.containsKey(uuid)) {
                return;
            }
            event.setCancelled(true);
            PendingInput input = pendingInputs.remove(uuid);
            String key = input.key;
            String value = event.getMessage();
            Player player = event.getPlayer();
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                Object currentValue = this.plugin.getConfigManager().get(key);
                try {
                    if (currentValue instanceof Integer) {
                        this.plugin.getConfigManager().set(key, Integer.parseInt(value));
                    } else if (currentValue instanceof Double) {
                        this.plugin.getConfigManager().set(key, Double.parseDouble(value));
                    } else if (currentValue instanceof Number) {
                        if (value.contains(".")) {
                            this.plugin.getConfigManager().set(key, Double.parseDouble(value));
                        } else {
                            this.plugin.getConfigManager().set(key, Integer.parseInt(value));
                        }
                    } else if (currentValue instanceof String) {
                        this.plugin.getConfigManager().set(key, value);
                    } else {
                        this.plugin.getMessageManager().sendMessage(player, "configgui.unsupported-type");
                        return;
                    }
                    this.plugin.getConfigManager().saveConfig();
                    HashMap<String, String> localMap = new HashMap<String, String>();
                    localMap.put("%key%", key);
                    localMap.put("%value%", value);
                    this.plugin.getMessageManager().sendMessage(player, "configgui.set-key-to-value", localMap);
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> new ConfigGUI(this.plugin, player, input.page).open());
                }
                catch (NumberFormatException e) {
                    this.plugin.getMessageManager().sendMessage(player, "configgui.invalid-number-format");
                }
            });
        }
    }
}

