/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.gui;

import app.qwertz.qwertzcore.QWERTZcore;
import java.util.Iterator;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class InvseeGUI
implements Listener {
    private final QWERTZcore plugin;
    private final Player viewer;
    private final Player target;
    private final Inventory gui;
    private BukkitTask updateTask;

    public InvseeGUI(QWERTZcore plugin, Player viewer, Player target) {
        this.plugin = plugin;
        this.viewer = viewer;
        this.target = target;
        this.gui = Bukkit.createInventory(null, (int)54, (String)(QWERTZcore.CORE_ICON + " " + String.valueOf(ChatColor.DARK_PURPLE) + target.getName() + "'s Inventory"));
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void open() {
        this.updateGUI();
        this.viewer.openInventory(this.gui);
        this.startUpdateTask();
    }

    private void updateGUI() {
        int i;
        ItemStack blackPane = new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
        for (i = 9; i < 18; ++i) {
            this.gui.setItem(i, blackPane);
        }
        for (i = 1; i < 5; ++i) {
            this.gui.setItem(i, blackPane);
        }
        for (i = 0; i < 36; ++i) {
            this.gui.setItem(i + 18, this.target.getInventory().getItem(i + 9));
        }
        for (i = 0; i < 9; ++i) {
            this.gui.setItem(i + 45, this.target.getInventory().getItem(i));
        }
        this.gui.setItem(0, this.target.getInventory().getItemInOffHand());
        ItemStack[] armor = this.target.getInventory().getArmorContents();
        for (int i2 = 0; i2 < 4; ++i2) {
            this.gui.setItem(i2 + 5, armor[i2]);
        }
    }

    private void startUpdateTask() {
        this.updateTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, this::updateGUI, 1L, 1L);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getInventory() != this.gui) {
            return;
        }
        if (event.getRawSlot() >= 0 && event.getRawSlot() < 54) {
            if (event.getRawSlot() >= 9 && event.getRawSlot() < 18 || event.getRawSlot() >= 1 && event.getRawSlot() < 5) {
                event.setCancelled(true);
                return;
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                if (event.getRawSlot() >= 18 && event.getRawSlot() < 54) {
                    int targetSlot = event.getRawSlot() - 18;
                    int column = targetSlot % 9;
                    if (targetSlot < 9) {
                        this.target.getInventory().setItem(9 + column, event.getCurrentItem());
                    } else if (targetSlot >= 9 && targetSlot < 18) {
                        this.target.getInventory().setItem(18 + column, event.getCurrentItem());
                    } else if (targetSlot >= 18 && targetSlot < 27) {
                        this.target.getInventory().setItem(27 + column, event.getCurrentItem());
                    } else if (targetSlot >= 27 && targetSlot < 36) {
                        this.target.getInventory().setItem(column, event.getCurrentItem());
                    }
                } else if (event.getRawSlot() >= 5 && event.getRawSlot() < 9) {
                    int armorSlot = event.getRawSlot() - 5;
                    this.target.getInventory().setArmorContents(new ItemStack[]{this.gui.getItem(5), this.gui.getItem(6), this.gui.getItem(7), this.gui.getItem(8)});
                } else if (event.getRawSlot() == 0) {
                    this.target.getInventory().setItemInOffHand(event.getCurrentItem());
                }
                this.target.updateInventory();
            });
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (event.getInventory() != this.gui) {
            return;
        }
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            if ((slot < 9 || slot >= 18) && (slot < 1 || slot >= 5)) continue;
            event.setCancelled(true);
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            Iterator iterator = event.getRawSlots().iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                if (slot >= 18 && slot < 54) {
                    int targetSlot = slot - 18;
                    int column = targetSlot % 9;
                    if (targetSlot < 9) {
                        this.target.getInventory().setItem(9 + column, (ItemStack)event.getNewItems().get(slot));
                        continue;
                    }
                    if (targetSlot >= 9 && targetSlot < 18) {
                        this.target.getInventory().setItem(18 + column, (ItemStack)event.getNewItems().get(slot));
                        continue;
                    }
                    if (targetSlot >= 18 && targetSlot < 27) {
                        this.target.getInventory().setItem(27 + column, (ItemStack)event.getNewItems().get(slot));
                        continue;
                    }
                    if (targetSlot < 27 || targetSlot >= 36) continue;
                    this.target.getInventory().setItem(column, (ItemStack)event.getNewItems().get(slot));
                    continue;
                }
                if (slot >= 5 && slot < 9) {
                    this.target.getInventory().setArmorContents(new ItemStack[]{this.gui.getItem(5), this.gui.getItem(6), this.gui.getItem(7), this.gui.getItem(8)});
                    continue;
                }
                if (slot != 0) continue;
                this.target.getInventory().setItemInOffHand((ItemStack)event.getNewItems().get(slot));
            }
            this.target.updateInventory();
        });
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getInventory() != this.gui) {
            return;
        }
        this.updateTask.cancel();
        InventoryCloseEvent.getHandlerList().unregister((Listener)this);
        InventoryClickEvent.getHandlerList().unregister((Listener)this);
        InventoryDragEvent.getHandlerList().unregister((Listener)this);
        PlayerDropItemEvent.getHandlerList().unregister((Listener)this);
        PlayerPickupItemEvent.getHandlerList().unregister((Listener)this);
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        if (event.getPlayer() == this.target) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, this::updateGUI);
        }
    }

    @EventHandler
    public void onPlayerPickupItem(PlayerPickupItemEvent event) {
        if (event.getPlayer() == this.target) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, this::updateGUI);
        }
    }
}

