/*
 * Decompiled with CFR 0.152.
 */
package app.qwertz.qwertzcore.util;

import app.qwertz.qwertzcore.QWERTZcore;
import app.qwertz.qwertzcore.commands.ChatReviveCommand;
import java.util.HashMap;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public class ChatListener
implements Listener {
    private final QWERTZcore plugin;
    private final Object answer;
    private final String gameType;
    private final ChatReviveCommand chatReviveCommand;
    private boolean gameOver = false;

    public ChatListener(QWERTZcore plugin, Object answer, String gameType, ChatReviveCommand chatReviveCommand) {
        this.plugin = plugin;
        this.answer = answer;
        this.gameType = gameType;
        this.chatReviveCommand = chatReviveCommand;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        if (this.gameOver) {
            return;
        }
        String message = event.getMessage().trim();
        if (this.gameType.equals("guess") || this.gameType.equals("math")) {
            try {
                int guessedNumber = Integer.parseInt(message);
                if (guessedNumber == (Integer)this.answer) {
                    this.announceWinner(event.getPlayer().getName());
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if ((this.gameType.equals("typer") || this.gameType.equals("custom")) && message.equalsIgnoreCase((String)this.answer)) {
            this.announceWinner(event.getPlayer().getName());
        }
    }

    private void announceWinner(String playerName) {
        HashMap<String, String> localMap = new HashMap<String, String>();
        localMap.put("%player%", playerName);
        this.plugin.getMessageManager().broadcastMessage("chatrevival.winner", localMap);
        this.plugin.getSoundManager().broadcastConfigSound();
        if (this.gameType.equals("guess") || this.gameType.equals("math")) {
            HashMap<String, String> localMap2 = new HashMap<String, String>();
            localMap2.put("%answer%", String.valueOf(this.answer));
            this.plugin.getMessageManager().broadcastMessage("chatrevival.correct-answer", localMap2);
            this.plugin.getSoundManager().broadcastConfigSound();
        }
        this.endGame();
    }

    public void cancelGame() {
        if (this.gameType.equals("guess") || this.gameType.equals("math")) {
            HashMap<String, String> localMap = new HashMap<String, String>();
            localMap.put("%answer%", String.valueOf(this.answer));
            this.plugin.getMessageManager().broadcastMessage("chatrevival.correct-answer", localMap);
            this.plugin.getSoundManager().broadcastConfigSound();
        } else if (this.gameType.equals("typer")) {
            HashMap<String, String> localMap = new HashMap<String, String>();
            localMap.put("%sentence%", String.valueOf(this.answer));
            this.plugin.getMessageManager().broadcastMessage("chatrevival.correct-sentence", localMap);
            this.plugin.getSoundManager().broadcastConfigSound();
        } else if (this.gameType.equals("custom")) {
            HashMap<String, String> localMap = new HashMap<String, String>();
            localMap.put("%answer%", String.valueOf(this.answer));
            this.plugin.getMessageManager().broadcastMessage("chatrevival.correct-answer", localMap);
            this.plugin.getSoundManager().broadcastConfigSound();
        }
        this.endGame();
    }

    private void endGame() {
        this.gameOver = true;
        HandlerList.unregisterAll((Listener)this);
        this.chatReviveCommand.setActiveGameNull();
    }

    public boolean isGameOver() {
        return this.gameOver;
    }
}

